package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import androidx.core.content.FileProvider;
import android.text.InputType;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.BuildConfig;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.signatureActivity;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.answerstable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.dynamicquestionstable;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

/**
 * Created by HP on 30-01-2017.
 */

public class task_summaryadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> subcategory,questionnumbers,questions,answers,typeofquestion;
    private String companyname,customername,atmid,emailid,category,todaydate;
    private String typeofselection="";
    private SimpleDateFormat dateFormatter;
    private String count="0",correctanswervalue="";
    private String[] booleananswers;
    private sqldatabase mDbHelper;
    private static final int CAMERA_CAPTURE_IMAGE_REQUEST_CODE = 100;
    public static String summaryquestion="",summarypicturefilename="",summarysubcategory="",summaryquestionumber="";
    public static File summaryimagefilepath = null;
    String selected=null;
    private DatePickerDialog datePickerDialog;
    private int year, month, day,mHour, mMinute;
    public task_summaryadapter(Context context, String companyname,String customername,String atmid,String emailid,String category,ArrayList<String> subcategory, ArrayList<String> questionnumbers, ArrayList<String> questions,ArrayList<String> answers,ArrayList<String> typeofquestion) {

        super(context, R.layout.custom_summary, questions);
        this.mycontext = context;
        this.companyname = companyname;
        this.customername = customername;
        this.atmid = atmid;
        this.emailid = emailid;
        this.category = category;
        this.subcategory = subcategory;
        this.questionnumbers = questionnumbers;
        this.questions = questions;
        this.answers = answers;
        this.typeofquestion = typeofquestion;
        dateFormatter = new SimpleDateFormat
                ("yyyy-MM-dd HH:mm:ss");
        todaydate = dateFormatter.format(new Date());
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_summary, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.heading = (TextView) convertView.findViewById(R.id.heading);
            myholder.question = (TextView) convertView.findViewById(R.id.questions);
            myholder.answer = (TextView) convertView.findViewById(R.id.answer);
            myholder.edit = (ImageView) convertView.findViewById(R.id.edit);
            myholder.imagequestion = (TextView) convertView.findViewById(R.id.imagequestion);
            myholder.imageedit = (ImageView) convertView.findViewById(R.id.imageedit);
            myholder.signatureimage = (ImageView) convertView.findViewById(R.id.signatureimage);
            myholder.questionnumber = (TextView) convertView.findViewById(R.id.questionumbervalue);
            myholder.imagequestionnumber = (TextView) convertView.findViewById(R.id.imagequestionnumber);
            convertView.setTag(myholder);


        } else {
            myholder = (holder) convertView.getTag();

        }
        if(subcategory.get(position).equalsIgnoreCase(""))
        {
            myholder.heading.setText(category);
        }else {
            myholder.heading.setText(subcategory.get(position));
        }
        if (position != 0) {
            if (subcategory.get(position).equalsIgnoreCase(
                    subcategory.get(position - 1))) {
                myholder.heading.setVisibility(convertView.GONE);
            } else {
                myholder.heading.setVisibility(convertView.VISIBLE);
            }
        } else {
            myholder.heading.setVisibility(convertView.VISIBLE);
        }
        final RelativeLayout questionslayout = (RelativeLayout) convertView.findViewById(R.id.questionslayout);
        final RelativeLayout imagelayout = (RelativeLayout) convertView.findViewById(R.id.imagelayout);
        final ImageView edittxt = (ImageView) convertView.findViewById(R.id.edit);
        final TextView questiontxt = (TextView) convertView.findViewById(R.id.questions);
        final TextView answertxt = (TextView) convertView.findViewById(R.id.answer);
        final ImageView signatureedit = (ImageView) convertView.findViewById(R.id.imageedit);
        final TextView imagequestion = (TextView) convertView.findViewById(R.id.imagequestion);
        final TextView questionumbervaluetxt = (TextView) convertView.findViewById(R.id.questionumbervalue);
        final TextView imagequestionnumbertxt = (TextView) convertView.findViewById(R.id.imagequestionnumber);


        if(typeofquestion.get(position).equals("signature")||typeofquestion.get(position).equals("image"))
        {
            questionslayout.setVisibility(View.GONE);
            imagelayout.setVisibility(View.VISIBLE);
            myholder.question.setText("");
            myholder.questionnumber.setText(questionnumbers.get(position)+")");
            myholder.answer.setText("");
            myholder.imagequestion.setText(questions.get(position));
            myholder.imagequestionnumber.setText(questionnumbers.get(position)+")");
            mDbHelper = new sqldatabase(mycontext);
            Cursor answerstablecursor = mDbHelper.get_answerstable(companyname,emailid,category,subcategory.get(position),questions.get(position));
            if(answerstablecursor.moveToFirst()) {

                byte[] cam=answerstablecursor.getBlob(answerstablecursor.getColumnIndex(answerstable.IMAGE));
                BitmapFactory.Options options = new BitmapFactory.Options();
                Bitmap bitmap = BitmapFactory.decodeByteArray(cam, 0, cam.length, options);
                myholder.signatureimage.setImageBitmap(bitmap);
                // myholder.signatureimage.setImageBitmap(globalvariables.StringToBitMap(answerstablecursor.getString(answerstablecursor.getColumnIndex(answerstable.IMAGE))));

            }
            else
            {
                myholder.signatureimage.setImageBitmap(null);
            }
            answerstablecursor.close();
            mDbHelper.close();

        }
        else
        {
            questionslayout.setVisibility(View.VISIBLE);
            imagelayout.setVisibility(View.GONE);
            myholder.question.setText(questions.get(position));
            myholder.questionnumber.setText(questionnumbers.get(position)+")");
            myholder.answer.setText(answers.get(position));
            myholder.imagequestion.setText("");
            myholder.imagequestionnumber.setText(questionnumbers.get(position)+")");
            myholder.signatureimage.setImageBitmap(null);
            sqldatabase mDbHelper  = new sqldatabase(mycontext);
            Cursor answertablecursor = mDbHelper.get_answerstable(companyname,emailid,category,subcategory.get(position),questiontxt.getText().toString());
            if (answertablecursor.moveToFirst()) {
                answertxt.setText(answertablecursor.getString(answertablecursor.getColumnIndex(answerstable.ANSWER)));

            }
            answertablecursor.close();
            mDbHelper.close();
        }






        edittxt.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                // TODO Auto-generated method stub
                if(typeofquestion.get(position).equals("boolean"))
                {
                    AlertDialog.Builder builder = new AlertDialog.Builder(
                            getContext());
                    builder.setTitle("Select");

                    CharSequence[] choiceList;

                    int selected=-1; // = -1 does not select anything
                    String message = "";

                    sqldatabase mDbHelper  = new sqldatabase(mycontext);
                    Cursor answertablecursor = mDbHelper.get_answerstable(companyname,emailid,category,subcategory.get(position),questiontxt.getText().toString());
                    if (answertablecursor.moveToFirst()) {
                        message = answertablecursor.getString(answertablecursor.getColumnIndex(answerstable.ANSWER));

                    } else {
                        selected = -1;
                    }
                    answertablecursor.close();

                    Cursor dynamicquestionscursor = mDbHelper.get_dynamicquestions_type(companyname,category,subcategory.get(position),questiontxt.getText().toString());
                    if (dynamicquestionscursor.moveToFirst()) {
                        count = dynamicquestionscursor.getString(dynamicquestionscursor.getColumnIndex(dynamicquestionstable.COUNT));
                        String optionforanswers = dynamicquestionscursor.getString(dynamicquestionscursor.getColumnIndex(dynamicquestionstable.OPTIONFORANSWERS));
                        correctanswervalue = dynamicquestionscursor.getString(dynamicquestionscursor.getColumnIndex(dynamicquestionstable.CORRECTANSWER));
                        booleananswers = optionforanswers.split("#@") ;
                        List<CharSequence> options = new ArrayList<>();
                        for(int i=1;i<=Integer.valueOf(count);i++)
                        {
                            options.add(new String(booleananswers[i]));
                            if(message.equals(booleananswers[i]))
                            {
                                selected = i-1;
                            }
                        }

                        choiceList = options.toArray(new CharSequence[options.size()]);

                        builder.setSingleChoiceItems(choiceList, selected,
                                new DialogInterface.OnClickListener() {

                                    @Override
                                    public void onClick(DialogInterface dialog,
                                                        int which) {
                                        for(int i=0;i<Integer.valueOf(count);i++)
                                        {
                                            if (which == i)
                                            {
                                                typeofselection = booleananswers[i+1] ;
                                            }
                                        }
                                    }
                                });

                        builder.setPositiveButton("OK",
                                new DialogInterface.OnClickListener() {
                                    public void onClick(DialogInterface dialog,
                                                        int whichButton) {
                                        sqldatabase mDbHelper  = new sqldatabase(mycontext);





                                        if (correctanswervalue.equals(typeofselection)) {
                                            mDbHelper.update_answerstable_submit( category, subcategory.get(position),questionumbervaluetxt.getText().toString().substring(0, questionumbervaluetxt.getText().toString().length() - 1), questiontxt.getText().toString(), "boolean", typeofselection, null, "no data available", todaydate,"no");
                                        } else {
                                            mDbHelper.update_answerstable_submit(category,subcategory.get(position), questionumbervaluetxt.getText().toString().substring(0, questionumbervaluetxt.getText().toString().length() - 1), questiontxt.getText().toString(), "boolean", typeofselection, null, "no data available", todaydate,"yes");
                                        }

                                        Toast.makeText(mycontext,"Edited",Toast.LENGTH_LONG).show();
                                        notifyDataSetChanged();
                                        mDbHelper.close();
                                    }
                                }).create();
                        builder.show();
                    }
                    dynamicquestionscursor.close();
                    mDbHelper.close();

                }
                else if(typeofquestion.get(position).equals("editbox")) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(
                            getContext());
                    builder.setTitle("Edit Message");
                    final EditText input = new EditText(getContext());
                    final sqldatabase mDbHelper  = new sqldatabase(mycontext);
                    Cursor answertablecursor = mDbHelper.get_answerstable(companyname,emailid,category,subcategory.get(position),questiontxt.getText().toString());
                    if (answertablecursor.moveToFirst()) {
                        String message = answertablecursor.getString(answertablecursor.getColumnIndex(answerstable.ANSWER));
                        input.setText(message);
                    }
                    answertablecursor.close();


                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(
                            LinearLayout.LayoutParams.MATCH_PARENT,
                            LinearLayout.LayoutParams.MATCH_PARENT);
                    input.setLayoutParams(lp);
                    builder.setView(input);
                    builder.setPositiveButton("OK",
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog,
                                                    int whichButton) {

                                    if(input.getText().toString().equalsIgnoreCase(""))
                                    {
                                        // mDbHelper.delete_answerstable(companyname,emailid,category,subcategory.get(position),questiontxt.getText().toString());
                                        Toast.makeText(mycontext,"blank text is not allowed!!",Toast.LENGTH_LONG).show();
                                    }
                                    else
                                    {
                                        Log.e("category",category);
                                        Log.e("questionumber",questionumbervaluetxt.getText().toString().substring(0, questionumbervaluetxt.getText().toString().length() - 1));
                                        Log.e("question",questiontxt.getText().toString());
                                        Log.e("answer",input.getText().toString().replace("'", "`"));
                                        //     Log.e("correctanswervalue",correctanswervalue);

                                        mDbHelper.update_answerstable_submit(category,subcategory.get(position),questionumbervaluetxt.getText().toString().substring(0,questionumbervaluetxt.getText().toString().length()-1),questiontxt.getText().toString(),"editbox",input.getText().toString().replace("'", "`"),null,"no data available",todaydate,"no");

                                        Toast.makeText(mycontext,"Edited",Toast.LENGTH_LONG).show();
                                    }


                                    notifyDataSetChanged();
                                }
                            }).create();
                    builder.show();
                    mDbHelper.close();

                }


                else if(typeofquestion.get(position).equals("integer")) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(
                            getContext());
                    builder.setTitle("Edit Message");
                    final EditText input = new EditText(getContext());
                    input.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_DECIMAL  | InputType.TYPE_NUMBER_FLAG_SIGNED);
                    final sqldatabase mDbHelper  = new sqldatabase(mycontext);
                    Cursor answertablecursor = mDbHelper.get_answerstable(companyname,emailid,category,subcategory.get(position),questiontxt.getText().toString());
                    if (answertablecursor.moveToFirst()) {
                        String message = answertablecursor.getString(answertablecursor.getColumnIndex(answerstable.ANSWER));
                        input.setText(message);
                    }
                    answertablecursor.close();


                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(
                            LinearLayout.LayoutParams.MATCH_PARENT,
                            LinearLayout.LayoutParams.MATCH_PARENT);
                    input.setLayoutParams(lp);
                    builder.setView(input);
                    builder.setPositiveButton("OK",
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog,
                                                    int whichButton) {

                                    if(input.getText().toString().equalsIgnoreCase(""))
                                    {
                                        // mDbHelper.delete_answerstable(companyname,emailid,category,subcategory.get(position),questiontxt.getText().toString());
                                        Toast.makeText(mycontext,"blank text is not allowed!!",Toast.LENGTH_LONG).show();
                                    }
                                    else
                                    {
                                        mDbHelper.update_answerstable_submit(category,subcategory.get(position),questionumbervaluetxt.getText().toString().substring(0,questionumbervaluetxt.getText().toString().length()-1),questiontxt.getText().toString(),"integer",input.getText().toString().replace("'", "`"),null,"no data available",todaydate,"no");

                                        Toast.makeText(mycontext,"Edited",Toast.LENGTH_LONG).show();
                                    }


                                    notifyDataSetChanged();
                                }
                            }).create();
                    builder.show();
                    mDbHelper.close();

                }



                else if(typeofquestion.get(position).equals("dropdown")) {

                    ///////////////////////////////////////////////////////

                    String optionsforanswer = null;

                    sqldatabase mDbHelper  = new sqldatabase(mycontext);
                    Cursor dynamicquestionscursor = mDbHelper.get_dynamicquestions_type(companyname,category,subcategory.get(position),questiontxt.getText().toString());
                    if (dynamicquestionscursor.moveToFirst()) {

                        optionsforanswer = dynamicquestionscursor.getString(dynamicquestionscursor.getColumnIndex(dynamicquestionstable.OPTIONFORANSWERS));
                    }

                    String[] ddoptions =  optionsforanswer.split("#@");
                    List<CharSequence> list = new ArrayList<CharSequence>();
                    for (int i=1;i<ddoptions.length;i++){
                        list.add(ddoptions[i]);  // Add the item in the list
                    }

                    Cursor answertablecursor = mDbHelper.get_answerstable(companyname,emailid,category,subcategory.get(position),questions.get(position));
                    if(answertablecursor.moveToFirst())
                    {
                        selected=(answertablecursor.getString(answertablecursor.getColumnIndex(answerstable.ANSWER)));
                    }
                    else{
                        selected=null;
                    }
                    //////////////////////////////////////////////////

                    // Intialize  readable sequence of char values
                    final CharSequence[] dialogList=  list.toArray(new CharSequence[list.size()]);
                    final AlertDialog.Builder builderDialog = new AlertDialog.Builder(v.getRootView().getContext());
                    builderDialog.setTitle("Select Item");
                    int count = dialogList.length;
                    boolean[] is_checked = new boolean[count];
                    String[] ddanswers;
                    if(selected!=null) {
                        ddanswers = selected.split("#@");
                        if (ddanswers.length > 0) {
                            for (int j = 0; j < list.size(); ++j) {
                                for (int i = 0; i < ddanswers.length; i++) {
                                    if (list.get(j).equals(ddanswers[i])) {
                                        is_checked[j] = true;
                                    }
                                }
                            }
                        }
                    }
                    // Creating multiple selection by using setMutliChoiceItem method
                    builderDialog.setMultiChoiceItems(dialogList, is_checked,
                            new DialogInterface.OnMultiChoiceClickListener() {
                                public void onClick(DialogInterface dialog,
                                                    int whichButton, boolean isChecked) {
                                }
                            });

                    builderDialog.setPositiveButton("OK",
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {

                                    ListView list = ((AlertDialog) dialog).getListView();
                                    // make selected item in the comma seprated string
                                    StringBuilder stringBuilder = new StringBuilder();
                                    for (int i = 0; i < list.getCount(); i++) {
                                        boolean checked = list.isItemChecked(i);

                                        if (checked) {
                                            if (stringBuilder.length() > 0) stringBuilder.append("#@");
                                            stringBuilder.append(list.getItemAtPosition(i));


                                        }
                                    }


                                    if (stringBuilder.toString().trim().equals("")) {


                                        Toast.makeText(mycontext,"blank text is not allowed!!",Toast.LENGTH_LONG).show();
                                        notifyDataSetChanged();

                                    } else {


                                        selected=stringBuilder.toString();

                                        sqldatabase mDbHelper  = new sqldatabase(mycontext);

                                        mDbHelper.update_answerstable_submit( category,subcategory.get(position),questionumbervaluetxt.getText().toString().substring(0,questionumbervaluetxt.getText().toString().length()-1),questiontxt.getText().toString(),"dropdown",selected,null,"no data available",todaydate,"no");
                                        notifyDataSetChanged();
                                    }
                                }
                            });

                    builderDialog.setNegativeButton("Cancel",
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    notifyDataSetChanged();
                                }
                            });
                    AlertDialog alert = builderDialog.create();
                    alert.show();


                    ///////////////////////////////////////////////////////

                }



                else if(typeofquestion.get(position).equals("date")) {

                    // calender class's instance and get current date , month and year from calender
                    final Calendar c = Calendar.getInstance();
                    int mYear = c.get(Calendar.YEAR); // current year
                    int mMonth = c.get(Calendar.MONTH); // current month
                    int mDay = c.get(Calendar.DAY_OF_MONTH); // current day
                    // date picker dialog
                    datePickerDialog = new DatePickerDialog(v.getRootView().getContext(),
                            new DatePickerDialog.OnDateSetListener() {

                                @Override
                                public void onDateSet(DatePicker view, int year,
                                                      int monthOfYear, int dayOfMonth) {
                                    sqldatabase mDbHelper  = new sqldatabase(mycontext);
                                    // set day of month , month and year value in the edit text

                                    String selecteddate=(dayOfMonth + "-"
                                            + (monthOfYear + 1) + "-" + year);

                                    mDbHelper.update_answerstable_submit( category,subcategory.get(position),questionumbervaluetxt.getText().toString().substring(0,questionumbervaluetxt.getText().toString().length()-1),questiontxt.getText().toString(),"date",selecteddate,null,"no data available",todaydate,"no");
                                    notifyDataSetChanged();

                                }
                            }, mYear, mMonth, mDay);
                    datePickerDialog.show();
                }


                else if(typeofquestion.get(position).equals("time")) {

                    final Calendar c = Calendar.getInstance();
                    mHour = c.get(Calendar.HOUR_OF_DAY);
                    mMinute = c.get(Calendar.MINUTE);

                    // Launch Time Picker Dialog
                    TimePickerDialog timePickerDialog = new TimePickerDialog(v.getRootView().getContext(),
                            new TimePickerDialog.OnTimeSetListener() {

                                @Override
                                public void onTimeSet(TimePicker view, int hourOfDay,
                                                      int minute) {

                                    sqldatabase mDbHelper  = new sqldatabase(mycontext);

                                    String selectedtime=(hourOfDay + ":" + minute);

                                    mDbHelper.update_answerstable_submit( category,subcategory.get(position),questionumbervaluetxt.getText().toString().substring(0,questionumbervaluetxt.getText().toString().length()-1),questiontxt.getText().toString(),"time",selectedtime,null,"no data available",todaydate,"no");
                                    notifyDataSetChanged();

                                }
                            }, mHour, mMinute, false);
                    timePickerDialog.show();

                }


            }
        });

        signatureedit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(typeofquestion.get(position).equals("signature")) {
                    Intent intent = new Intent(mycontext, signatureActivity.class);
                    Bundle extras = new Bundle();
                    extras.putString("companyname", companyname);
                    extras.putString("customername", customername);
                    extras.putString("atmid", atmid);
                    extras.putString("emailid", emailid);
                    extras.putString("category", category);
                    extras.putString("subcategory", subcategory.get(position));
                    extras.putString("companyname", companyname);
                    extras.putString("questionumber", imagequestionnumbertxt.getText().toString().substring(0,imagequestionnumbertxt.getText().toString().length()-1));
                    extras.putString("question", imagequestion.getText().toString());
                    intent.putExtras(extras);
                    // intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    // mycontext.startActivity(intent);
                    ((Activity) mycontext).startActivityForResult(intent, 500);
                    notifyDataSetChanged();
                }
                else if(typeofquestion.get(position).equals("image"))
                {
                    if (!isDeviceSupportCamera()) {
                        Toast.makeText(mycontext,
                                "Sorry! Your device doesn't support camera",
                                Toast.LENGTH_LONG).show();
                    }
                    else
                    {
                        captureImage(imagequestion.getText().toString(),subcategory.get(position),imagequestionnumbertxt.getText().toString().substring(0,imagequestionnumbertxt.getText().toString().length()-1));
                    }
                }
            }
        });
        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {

        TextView question,answer,heading,imagequestion,questionnumber,imagequestionnumber;
        ImageView edit,imageedit,signatureimage;


    }
    private boolean isDeviceSupportCamera() {
        if (mycontext.getPackageManager().hasSystemFeature(
                PackageManager.FEATURE_CAMERA)) {
            // this device has a camera
            return true;
        } else {
            // no camera on this device
            return false;
        }
    }
    private void captureImage(String question,String subcategorytxt,String questionnumber) {
        try {
            Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
            //   Uri fileUri = getOutputMediaFileUri();
            Uri fileUri = FileProvider.getUriForFile(mycontext,
                    BuildConfig.APPLICATION_ID + ".provider",
                    getOutputMediaFileUri());
            intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri);
            summaryquestion = question;
            //Toast.makeText(mycontext,"sender="+question,Toast.LENGTH_LONG).show();
            summarysubcategory = subcategorytxt;
            summaryquestionumber = questionnumber;
//	        Log.d("fileUri.getPath() in adapter", ""+fileUri.getPath());
            ((Activity) mycontext).startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE);//(Activity) mycontext).
        }catch(Exception e)
        {
            // Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();

            try {
                Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
                //   Uri fileUri = getOutputMediaFileUri();
                Uri fileUri = getOutputMediaFileUriException();
                intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri);
                summaryquestion = question;
                //Toast.makeText(mycontext,"sender="+question,Toast.LENGTH_LONG).show();
                summarysubcategory = subcategorytxt;
                summaryquestionumber = questionnumber;
//	        Log.d("fileUri.getPath() in adapter", ""+fileUri.getPath());
                ((Activity) mycontext).startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE);//(Activity) mycontext).
            }catch(Exception e1)
            {
                // Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
            }
        }
    }
    private File getOutputMediaFileUri() {
        File mediaFile = null;

        File mediaStorageDir = new File("/sdcard/Android/data/com.B2lmobitech.FieldCloudDesk/"+"Images");
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdirs()) {
                return null;
            }
        }
        SimpleDateFormat dateFormatter2 = new SimpleDateFormat
                ("yyyyMMdd_HHmmss");
        mediaFile = new File(mediaStorageDir.getPath() + File.separator

                + "IMG_" + dateFormatter2.format(new Date()) + ".jpg");
        summarypicturefilename = "IMG_" + dateFormatter2.format(new Date()) + ".jpg";
        try {
            mediaFile.createNewFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        summaryimagefilepath = mediaFile;
        return mediaFile;

    }

    private Uri getOutputMediaFileUriException() {
        File mediaFile = null;

        File mediaStorageDir = new File("/sdcard/Android/data/com.B2lmobitech.FieldCloudDesk/"+"Images");
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdirs()) {
                return null;
            }
        }
        SimpleDateFormat dateFormatter2 = new SimpleDateFormat
                ("yyyyMMdd_HHmmss");
        mediaFile = new File(mediaStorageDir.getPath() + File.separator

                + "IMG_" + dateFormatter2.format(new Date()) + ".jpg");
        summarypicturefilename = "IMG_" + dateFormatter2.format(new Date()) + ".jpg";
        try {
            mediaFile.createNewFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        summaryimagefilepath = mediaFile;
        return Uri.fromFile(mediaFile);

    }
}
