package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.serviceold.showworkreport;

import java.util.ArrayList;

/**
 * Created by HP on 30-01-2017.
 */

public class workreportadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> ticket,status,date,description;
    private ArrayList<Bitmap> imagebmp;

    public workreportadapter(Context context, ArrayList<String> ticket, ArrayList<String> status, ArrayList<String> date, ArrayList<String> description, ArrayList<Bitmap> imagebmp) {

        super(context, R.layout.custom_workreportlist, ticket);
        this.mycontext = context;
        this.ticket = ticket;
        this.status = status;
        this.date = date;
        this.description = description;
        this.imagebmp = imagebmp;

    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_workreportlist, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.ticketvalue = (TextView) convertView.findViewById(R.id.ticket);
            myholder.statusvalue = (TextView) convertView.findViewById(R.id.status);
            myholder.datevalue = (TextView) convertView.findViewById(R.id.date);
            myholder.descriptionvalue = (TextView) convertView.findViewById(R.id.description);
            myholder.image = (ImageView) convertView.findViewById(R.id.image);
            convertView.setTag(myholder);
            convertView.setBackgroundColor(position % 2 == 0 ? Color.WHITE : Color.parseColor("#FEFCFF"));

        } else {
            myholder = (holder) convertView.getTag();

        }

        myholder.ticketvalue.setText("Ticket No: "+ticket.get(position));
        myholder.statusvalue.setText(status.get(position));
        myholder.datevalue.setText("Date: "+date.get(position).split(" ")[0]);
        myholder.descriptionvalue.setText(description.get(position));
        if(imagebmp.get(position)!=null) {
            myholder.image.setImageBitmap(imagebmp.get(position));
        }
        else
        {
            myholder.image.setImageResource(R.drawable.ic_action_camerasmall);
        }
       final RelativeLayout listlayout = (RelativeLayout) convertView.findViewById(R.id.custom_workreportlist);
        listlayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(mycontext, showworkreport.class);
                Bundle extras = new Bundle();
                extras.putString("date",date.get(position));
                extras.putString("ticket", ticket.get(position));
                intent.putExtras(extras);
                mycontext.startActivity(intent);
            }
        });
        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {

        TextView ticketvalue,statusvalue,datevalue,descriptionvalue;
        ImageView image;

    }
}
