package com.b2lmobitech.fieldcloudplus.serviceold;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.customerlistadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;

public class customerlist extends AppCompatActivity {
private Context mycontext;
    private ProgressBar progressbar;
    private ListView list;
    private ArrayList<String> customers,customertype;
    private ArrayList<Bitmap> customerimage;
    private customerlistadapter adapter;
    private TextView nohistory;
    private getcustomerslist gettask = null;
    private String url_get_customers = "",registeredcompany,registeredemailid,registeredquestionmode,registeredcombinationname,registeredcombinationtype;
    private int status =0;
    private Snackbar snackBar;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_customerlist);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        mycontext = this;


        Intent intent = getIntent();

        registeredcombinationname = intent.getStringExtra("combinationname");
        registeredcombinationtype = intent.getStringExtra("combinationtype");
        registeredquestionmode = intent.getStringExtra("questionmode");

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        progressbar = (ProgressBar)findViewById(R.id.customerprogressBar);
        list = (ListView) findViewById(R.id.customerlist);
        nohistory = (TextView) findViewById(R.id.nohistory);
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
        customers = new ArrayList<String>();
        customertype = new ArrayList<String>();
        customerimage = new ArrayList<Bitmap>();

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        if(isNetworkAvailable())
        {
            nohistory.setVisibility(View.GONE);
            gettask = new getcustomerslist();
            StartAsyncTaskInParallel(gettask);
        }
        else
        {
            nohistory.setVisibility(View.VISIBLE);
            //Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }



    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(getcustomerslist task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class getcustomerslist extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_customers"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_customers = product.getString("url");


                    List<NameValuePair> getcustomersparams = new ArrayList<NameValuePair>();
                    getcustomersparams.add(new BasicNameValuePair("companyname", registeredcompany ));

                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_customers, "GET", getcustomersparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("clientcustomer"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();
                        for(int i=0;i<countval;i++)
                        {
                            product2 = productObj2.getJSONObject(i);
                            customers.add(product2.getString("customername"));
                            customertype.add(product2.getString("customertype"));
                            customerimage.add(globalvariables.StringToBitMap(product2.getString("clientimage")));
                            //customeraddress.add(product2.getString("clientimage"));//+",\nLandmark:"+product2.getString("clientlandmark")+",\n-"+product2.getString("pincode")+",\n"+product2.getString("state")+",\n"+product2.getString("country")+".");

                        }


                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            gettask = null;
            progressbar.setVisibility(View.GONE);
            if(status==1)
            {
               // Toast.makeText(mycontext,""+customerimage,Toast.LENGTH_LONG).show();
                nohistory.setVisibility(View.GONE);
                adapter = new customerlistadapter(mycontext,customers,customerimage,customertype,registeredquestionmode,registeredcombinationname,registeredcombinationtype);
                list.setAdapter(adapter);
            }
            else
            {
                nohistory.setVisibility(View.VISIBLE);
            }

        }
        @Override
        protected void onCancelled() {
            gettask = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
