package com.b2lmobitech.fieldcloudplus.serviceold;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.helpcenteradapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;

public class helpcenter extends AppCompatActivity {
    private Context mycontext;
    private ArrayList<String> headings, explanations, picturetitles;
    private ArrayList<Bitmap> pictures;
    private ProgressBar progressbar;
    private ListView helpcenterlistview;
    private helpcenteradapter adapter;
    private int status =0,getsuccess=0;
    private String url_get_helptip = "",registeredcompanytype;
    private  gethelptip gethelptiptask = null;
    private Snackbar snackBar;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_helpcenter);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        mycontext = this;
        helpcenterlistview = (ListView) findViewById(R.id.helpcenterlistview);
        progressbar = (ProgressBar) findViewById(R.id.helpcenterprogressBar);
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompanytype = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companytype, "");
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
        headings = new ArrayList<String>();
        explanations = new ArrayList<String>();
        picturetitles = new ArrayList<String>();
        pictures = new ArrayList<Bitmap>();
        adapter = new helpcenteradapter(mycontext, headings,explanations,picturetitles,pictures);
        helpcenterlistview.setAdapter(adapter);
        if(isNetworkAvailable())
        {
            snackBar.dismiss();
            if(!(registeredcompanytype.equalsIgnoreCase("Attendance")))
            {
                registeredcompanytype = "Service";
            }
            gethelptiptask = new gethelptip();
            StartAsyncTaskInParallel(gethelptiptask);
        }
        else
        {
            //Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }
    }
    public  boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    //    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private  void StartAsyncTaskInParallel(gethelptip task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class gethelptip extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            status = 0;
            headings.clear();
            explanations.clear();
            picturetitles.clear();
            pictures.clear();
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_helptip"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_helptip = product.getString("url");


                    List<NameValuePair> gethelpparams = new ArrayList<NameValuePair>();
                    gethelpparams.add(new BasicNameValuePair("companytype",registeredcompanytype ));


                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_helptip, "GET", gethelpparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("helptip"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();
                        for(int i=0;i<countval;i++) {
                            product2 = productObj2.getJSONObject(i);
                            headings.add(product2.getString("heading"));
                            explanations.add(product2.getString("explanation"));
                            picturetitles.add(product2.getString("picturetitle"));
                            pictures.add(globalvariables.StringToBitMap(product2.getString("picture")));
                        }

                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            gethelptiptask = null;
            progressbar.setVisibility(View.GONE);
            //Toast.makeText(mycontext,"url_get_expenses"+url_get_expenses, Toast.LENGTH_LONG).show();
            if(status==1)
            {
                adapter.notifyDataSetChanged();
            }
            else
            {
                snackBar.dismiss();
                snackBar = Snackbar.make(findViewById(android.R.id.content), "No data found", Snackbar.LENGTH_INDEFINITE);
                toast();
            }

        }
        @Override
        protected void onCancelled() {
            gethelptiptask = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
