package com.b2lmobitech.fieldcloudplus.serviceold;


import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import android.widget.ListView;

import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.inspectionadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;


public class inspectionreport extends AppCompatActivity {

    private Context mycontext;


    String registeredcompany,registeredemailid;

    private ArrayList<String> subcategories,questionnumberslist,questions,answers,typeofquestion,image;

    ListView issueslistview;

    String ticketstatus="";


    private ProgressDialog pDialog;


    JSONArray tickets = null;

    JSONParser jsonParser = new JSONParser();




    private static final String ALL_TICKET_URL ="http://fieldcloud.in/App/get_preventivedetailsanswer.php";



    private static final String TICKET_SUCCESS = "success";
    private static final String TICKET_MESSAGE = "message";



    JSONArray products = null;

    String customername,facility,category,questionmode,combinationname,typename,emailid;

    String searchdate;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.activity_issueslist);

        mycontext = this;


        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        Intent intent = getIntent();

        customername=intent.getStringExtra("customername");
        facility=intent.getStringExtra("facility");
        category=intent.getStringExtra("category");
        questionmode=intent.getStringExtra("questionmode");
        combinationname=intent.getStringExtra("combinationname");
        typename=intent.getStringExtra("typename");
        emailid=intent.getStringExtra("emailid");
        searchdate=intent.getStringExtra("date");


        issueslistview=(ListView) findViewById(R.id.issueslistview);

        subcategories = new ArrayList<String>();
        questions = new ArrayList<String>();
        questionnumberslist = new ArrayList<String>();
        answers = new ArrayList<String>();
        typeofquestion = new ArrayList<String>();
        image = new ArrayList<String>();

        if(isNetworkAvailable())
        {

            new GetInspectionDetail().execute();
        }
        else
        {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

            alertdialog.setTitle("No Internet Connection");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("Try Again!!");
            alertdialog.setPositiveButton("OK",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            finish();
                        }
                    }).create();

            alertdialog.show();
        }



      /*  issueslistadapter adapter =new

                issueslistadapter(TicketList.this, ticketnumber,customername,facility,emailid,question,answer,location,questionmode,questiontype,combinationname,typename);


        issueslistview.setAdapter(adapter);*/

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
       // getSupportActionBar().setTitle(ticketstatus+" Ticket");
        //    getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }




    class GetInspectionDetail extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(inspectionreport.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;



            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",searchdate ));
                params.add(new BasicNameValuePair("emailid",emailid ));
                params.add(new BasicNameValuePair("customername",customername ));
                params.add(new BasicNameValuePair("facility",facility ));
                params.add(new BasicNameValuePair("category",category ));
                params.add(new BasicNameValuePair("combinationname",combinationname ));
                params.add(new BasicNameValuePair("typename",typename ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_TICKET_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();



                    if(count>=1)
                    {



                        for (int i = 0; i <count; i++) {

                            photoobj=tickets.getJSONObject(i);



                            subcategories.add(photoobj.getString("subcategory"));
                            questionnumberslist.add(photoobj.getString("questionnumber"));
                            questions.add(photoobj.getString("question"));
                            answers.add(photoobj.getString("answer"));
                            typeofquestion.add(photoobj.getString("typeofquestion"));
                            image.add(photoobj.getString("image"));


                        }

                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            inspectionadapter    adapter = new inspectionadapter(mycontext,registeredcompany,customername,facility,registeredemailid,category,subcategories,questionnumberslist,questions,answers,typeofquestion,image);
            issueslistview.setAdapter(adapter);

        }
    }





}
