package com.b2lmobitech.fieldcloudplus.serviceold;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.location.Address;
import android.location.Geocoder;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import androidx.core.app.ActivityCompat;

import com.b2lmobitech.fieldcloudplus.task.service.ReminderReceiver;

import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.attendancetable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.locationtable;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

/**
 * Created by HP on 09-02-2017.
 */

public class locationbroadcast  extends BroadcastReceiver{
    private Context mycontext;
    //---location
    private LocationManager locationManager;
    private LocationListener locationListener;
    private boolean isGPSEnabled = false;
    private boolean isNetworkEnabled = false;
    private boolean canGetLocation = false;
    // The minimum distance to change Updates in meters
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 10; // 10 meters
    // The minimum time between updates in milliseconds
    private static final long MIN_TIME_BW_UPDATES = 1000 * 60 * 1;
    private android.location.Location location;
    private boolean running = false;
    private String currentlocation = "Not found";
    private Double currentlocationlaltitue = 0.0, currentlocationlongitude = 0.0;
    private List<Address> addresses = null;
//    private static final AndroidHttpClient ANDROID_HTTP_CLIENT = AndroidHttpClient.newInstance(locationbroadcast.class.getName());
    private sqldatabase mDbHelper;
    private String registeredemailid,registeredcompany,table_date,table_time;
    private SimpleDateFormat sdf,sdf2;
    private static String url_insert_multiplerecords_locationtable = "";
    private int insertcheck = 0;
    private locationsyncdata mytask = null;
    private  PendingIntent pendingintent;
    private AlarmManager alarmmanager;
    @Override
    public void onReceive(Context context, Intent intent) {
        mycontext = context;
       // Toast.makeText(mycontext,"receiver",Toast.LENGTH_LONG).show();
        try {
            if (intent.getAction() != null) {
                if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
                    try {


                            Intent alarmIntent = new Intent(context, ReminderReceiver.class);
                            PendingIntent pendingIntent = PendingIntent.getBroadcast(context, 0, alarmIntent, 0);

                            AlarmManager manager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);

                            Calendar calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(System.currentTimeMillis());
                            calendar.set(Calendar.HOUR_OF_DAY, 6);
                            calendar.set(Calendar.MINUTE, 0);
                            calendar.set(Calendar.SECOND, 1);

                            manager.setRepeating(AlarmManager.RTC_WAKEUP, calendar.getTimeInMillis(),
                                    AlarmManager.INTERVAL_DAY, pendingIntent);

                        PreferenceManager.getDefaultSharedPreferences(context).edit().putBoolean("firstTime", true).apply();
                        call_location_every15mins();

                    }catch(Exception e)
                    {
                        e.printStackTrace();
                    }
                }
            }
        }catch(Exception e)
        {
           // Toast.makeText(mycontext,e.toString(),Toast.LENGTH_LONG).show();
        }
        try {
            if (intent != null) {
                globalvariables.Logoutsharedpreference = mycontext.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
                registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
                registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
                sdf = new SimpleDateFormat("HH:mm:ss");
                sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                mDbHelper = new sqldatabase(mycontext);
                Cursor attendancecursor = mDbHelper.get_attendancetable_checkin(registeredcompany, registeredemailid, sdf2.format(new Date()));

                if (attendancecursor.moveToFirst())//he shoud take attendance today to update location
                {
                    String status_show = attendancecursor.getString(attendancecursor.getColumnIndex(attendancetable.STATUS));
                    if(status_show.equalsIgnoreCase("IN")) {

                    findlocation();
                    insertintotable(currentlocation, currentlocationlaltitue, currentlocationlongitude);
                    try {
                        if (isNetworkAvailable()) {
                            mytask = new locationsyncdata();
                            StartAsyncTaskInParallel(mytask);
                        }
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                    }
                }

                attendancecursor.close();
                mDbHelper.close();
            }
        }catch(Exception e)
        {
            //Toast.makeText(mycontext,e.toString(),Toast.LENGTH_LONG).show();
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    //----Location
    public void findlocation() {

        try {
            final Geocoder geocoder = new Geocoder(mycontext, Locale.getDefault());
            locationManager = (LocationManager) mycontext.getSystemService(Context.LOCATION_SERVICE);

            locationListener = new LocationListener() {

                @Override
                public void onStatusChanged(String provider, int status, Bundle extras) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onProviderEnabled(String provider) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onProviderDisabled(String provider) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onLocationChanged(android.location.Location location) {
                    // TODO Auto-generated method stub

                }
            };
            // getting GPS status
            isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
//            if (!isGPSEnabled) {
//                //Toast.makeText(mycontext, "Turn your GPS 'ON' for location access", Toast.LENGTH_LONG).show();
//                snackBar.dismiss();
//                snackBar = Snackbar.make(findViewById(android.R.id.content), "Turn your GPS 'ON' for location access", Snackbar.LENGTH_INDEFINITE);
//                toast();
//            }
            // getting network status


            isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);

            if(isNetworkEnabled){
                getLocation(LocationManager.NETWORK_PROVIDER);
            }else if(isGPSEnabled){
                getLocation(LocationManager.GPS_PROVIDER);
            }else{
                getLocation(LocationManager.PASSIVE_PROVIDER);
            }



        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

//				 Log.d("currentlocationlaltitue",""+currentlocationlaltitue);
//				 Log.d("currentlocationlongitude",""+currentlocationlongitude);
    }

    public void getLocation(String provider) {

        final Geocoder geocoder = new Geocoder(mycontext, Locale.getDefault());

        if (ActivityCompat.checkSelfPermission(mycontext, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(mycontext, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return;
        }

        locationManager.requestLocationUpdates(provider, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
        if (locationManager != null) {

            //   Log.e("Network locationmanager","coming");
            location = locationManager.getLastKnownLocation(provider);
            if (location != null) {

                currentlocationlaltitue = location.getLatitude();
                currentlocationlongitude = location.getLongitude();

                try {
                    addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                    Address address = addresses.get(0);

                    if(address!=null ) {
                        currentlocation = address.getAddressLine(0);
                    }
                    else
                    {
                        currentlocation = currentlocationlaltitue+","+currentlocationlongitude;
                    }
                    //addressFragments.add(address.getAdminArea());

                    // currentlocation = currentlocation.substring(1,currentlocation.length()-1);
                } catch (Exception e) {
                    // TODO Auto-generated catch block
//											e.printStackTrace();
                    currentlocation = currentlocationlaltitue+","+currentlocationlongitude;
                }
            }
        }else{
            getLocation(LocationManager.PASSIVE_PROVIDER);
        }
    }

    public void fetchCityName(final Context contex, final android.location.Location location)
    {
//			  Log.d("fetchCityName", "fetchCityName");
        if (running)
            return;

        new AsyncTask<Void, Void, String>()
        {
            protected void onPreExecute()
            {
                running = true;
            };

            @Override
            protected String doInBackground(Void... params)
            {
                String cityName = null;

                if (Geocoder.isPresent())
                {
                    try
                    {
                        Geocoder geocoder = new Geocoder(contex, Locale.getDefault());
                        List<Address> addresses = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
                        if (addresses.size() > 0)
                        {
                            cityName = addresses.get(0).getLocality();
                        }
                    }
                    catch (Exception ignored)
                    {
                        // after a while, Geocoder start to trhow "Service not availalbe" exception. really weird since it was working before (same device, same Android version etc..
                    }
                }

                if (cityName != null) // i.e., Geocoder succeed
                {
                    return cityName;
                }
                else // i.e., Geocoder failed
                {
                    return fetchCityNameUsingGoogleMap();
                }
            }

            // Geocoder failed :-(
            // Our B Plan : Google Map
//            private String fetchCityNameUsingGoogleMap()
//            {
//                String googleMapUrl = "http://maps.googleapis.com/maps/api/geocode/json?latlng=" + location.getLatitude() + ","
//                        + location.getLongitude() + "&sensor=false&language=fr";
//
//                try
//                {
//                    JSONObject googleMapResponse = new JSONObject(ANDROID_HTTP_CLIENT.execute(new HttpGet(googleMapUrl),
//                            new BasicResponseHandler()));
//
//                    // many nested loops.. not great -> use expression instead
//                    // loop among all results
//                    JSONArray results = (JSONArray) googleMapResponse.get("results");
//                    String cityName = results.getJSONObject(0).getString("formatted_address");
////		                    Log.d("address check", results.getJSONObject(0).getString("formatted_address"));
//
//                    return cityName;
//                }
//                catch (Exception ignored)
//                {
//                    ignored.printStackTrace();
//                }
//                return null;
//            }

            private String fetchCityNameUsingGoogleMap() {
                String googleMapUrl = "https://maps.googleapis.com/maps/api/geocode/json?latlng="
                        + location.getLatitude() + "," + location.getLongitude() + "&sensor=false&language=en";
                HttpURLConnection connection = null;
                BufferedReader reader = null;
                try {
                    URL url = new URL(googleMapUrl);
                    connection = (HttpURLConnection) url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.connect();

                    InputStream stream = connection.getInputStream();
                    reader = new BufferedReader(new InputStreamReader(stream));
                    StringBuilder buffer = new StringBuilder();
                    String line;
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                    }

                    JSONObject googleMapResponse = new JSONObject(buffer.toString());
                    JSONArray results = googleMapResponse.getJSONArray("results");
                    if (results.length() > 0) {
                        return results.getJSONObject(0).getString("formatted_address");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }


            protected void onPostExecute(String cityName)
            {
                running = false;
//		                Toast.makeText(mycontext, "cityName"+cityName, Toast.LENGTH_LONG).show();
                if (cityName != null)
                {
                    // Do something with cityName
//		                    Log.i("GeocoderHelper", cityName);
//		                    alertdialog(cityName);
                    currentlocation = cityName;
                    currentlocation = currentlocation.substring(1,currentlocation.length()-1);
//		                    Imagecaption.setText("Latitude:"+currentlocationlaltitue+",\nLongitude:"+currentlocationlongitude+",\nLocation:"+currentlocation);

                }

//		                Toast.makeText(mycontext, currentlocation, Toast.LENGTH_LONG).show();
            };
        }.execute();
    }

    private void insertintotable(String presentlocation,Double presentlatitude,Double presentlongitude)
    {
        try {
            table_date = sdf2.format(new Date());
            table_time = sdf.format(new Date());
            mDbHelper = new sqldatabase(mycontext);
            if (presentlatitude != 0.0) {
                if (presentlocation.equalsIgnoreCase("Not found") || presentlocation.equalsIgnoreCase("ot foun")) {
                    mDbHelper.insert_locationtable(registeredcompany, registeredemailid, presentlatitude + "," + presentlongitude, "", String.valueOf(presentlatitude), String.valueOf(presentlongitude), table_date, table_time, "No");
                } else {
                    mDbHelper.insert_locationtable(registeredcompany, registeredemailid, presentlocation, "", String.valueOf(presentlatitude), String.valueOf(presentlongitude), table_date, table_time, "No");

                }
            }
            mDbHelper.close();
        }catch(Exception e)
        {
            //Toast.makeText(mycontext,e.toString(),Toast.LENGTH_LONG).show();
        }
    }
    //----
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)

    private void StartAsyncTaskInParallel(locationsyncdata task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class locationsyncdata extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            mDbHelper = new sqldatabase(mycontext);
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();
                List<NameValuePair> insertparams = new ArrayList<NameValuePair>();
                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "insert_location"));
                JSONArray jsonarray = new JSONArray();

                int insertsuccess = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_insert_multiplerecords_locationtable = product.getString("url");
                    Cursor location_cursor = mDbHelper.get_locationtable_notsynced(registeredcompany, registeredemailid);
                    if(location_cursor.moveToFirst())
                    {
                        ArrayList<String> companyname_sync = new ArrayList<String>();
                        ArrayList<String> emailid_sync = new ArrayList<String>();
                        ArrayList<String> date_sync = new ArrayList<String>();
                        ArrayList<String> time_sync = new ArrayList<String>();
                        do{
                            JSONObject JSONList = new JSONObject();//if you declare outside data vl get replace,so dont chnage from here

                            JSONList.put("companyname",location_cursor.getString(location_cursor.getColumnIndex(locationtable.COMPANYNAME)));
                            JSONList.put("emailid",location_cursor.getString(location_cursor.getColumnIndex(locationtable.EMAILID)));
                            JSONList.put("location",location_cursor.getString(location_cursor.getColumnIndex(locationtable.LOCATION)));
                            JSONList.put("checkinname",location_cursor.getString(location_cursor.getColumnIndex(locationtable.CHECKINNAME)));
                            JSONList.put("latitude",location_cursor.getString(location_cursor.getColumnIndex(locationtable.LATITUDE)));
                            JSONList.put("longitude",location_cursor.getString(location_cursor.getColumnIndex(locationtable.LONGITUDE)));
                            JSONList.put("date",location_cursor.getString(location_cursor.getColumnIndex(locationtable.DATE)));
                            JSONList.put("time",location_cursor.getString(location_cursor.getColumnIndex(locationtable.TIME)));

                            jsonarray.put(JSONList);
                            //---
                            companyname_sync.add(location_cursor.getString(location_cursor.getColumnIndex(locationtable.COMPANYNAME)));
                            emailid_sync.add(location_cursor.getString(location_cursor.getColumnIndex(locationtable.EMAILID)));
                            date_sync.add(location_cursor.getString(location_cursor.getColumnIndex(locationtable.DATE)));
                            time_sync.add(location_cursor.getString(location_cursor.getColumnIndex(locationtable.TIME)));
                        }while(location_cursor.moveToNext());
                        insertparams.add(new BasicNameValuePair("JSON", String.valueOf(jsonarray)));//[{},{}]
                        //{}-Json object,[]-Json array


                        try {
                            JSONObject json_insert = jParser.makeHttpRequest(
                                    url_insert_multiplerecords_locationtable, "POST", insertparams);
                            insertsuccess = json_insert.getInt("success");
//                        message = json_insert.getString("message");

                            if (insertsuccess == 1) {
                                insertcheck = 1;
                                for(int i=0;i<date_sync.size();i++)
                                {
                                    mDbHelper.update_locationtable_sync(companyname_sync.get(i),emailid_sync.get(i),date_sync.get(i),time_sync.get(i),"Yes");
                                }

                            }
                            else
                            {
                                insertcheck = 0;

                            }
                        } catch (Exception e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                            insertcheck = 0;

                        }
                    }else
                    {
                        insertcheck = 2;
                    }

                    location_cursor.close();
                }
//                else
//                {
//                    insertcheck = 0;
//                }

            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products
            try {
                mDbHelper.close();
                mytask = null;
                if (insertcheck == 0) {
                    // Toast.makeText(mycontext,"Please try again!!",Toast.LENGTH_LONG).show();
                } else if (insertcheck == 1) {
                    // Toast.makeText(mycontext,"Data is synced.",Toast.LENGTH_LONG).show();
                } else {
                    // Toast.makeText(mycontext,"No data to sync",Toast.LENGTH_LONG).show();
                }
            }catch(Exception e)
                {
                    //Toast.makeText(mycontext,e.toString(),Toast.LENGTH_LONG).show();
                }

        }
        @Override
        protected void onCancelled() {
            mytask = null;
        }
    }

    //used in dashboard
    private  void call_location_every15mins() {
        try {
            if (alarmmanager != null) {
                alarmmanager.cancel(pendingintent);
                // Toast.makeText(getActivity().getApplicationContext(),"Manual update of location enabled.",Toast.LENGTH_LONG).show();

            }
            Intent intent = new Intent(mycontext, locationbroadcast.class);

            pendingintent = PendingIntent.getBroadcast(mycontext, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT);

            // We want the alarm to go off 3 seconds from now.
            long firstTime = SystemClock.elapsedRealtime();
            firstTime += 3 * 1000;//start 3 seconds after first register.

            // Schedule the alarm!
            alarmmanager = (AlarmManager) mycontext.getSystemService(mycontext.ALARM_SERVICE);
            alarmmanager.setRepeating(AlarmManager.RTC_WAKEUP, firstTime, 15 * 60 * 1000, pendingintent);//ELAPSED_REALTIME_WAKEUP
            SharedPreferences.Editor editor = globalvariables.Logoutsharedpreference.edit();
            editor.putString(globalvariables.logout_locationbroadcast, "yes");
            editor.commit();
        }catch(Exception e)
        {
           // Toast.makeText(mycontext,e.toString(),Toast.LENGTH_LONG).show();
        }
    }


}
