package com.b2lmobitech.fieldcloudplus.serviceold;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;

public class showworkreport extends AppCompatActivity {
private String date,ticket,registeredcompany,registeredemailid;
    private getworkreportdetails report=null;
    private Context mycontext;
    private ProgressBar progressbar;
    private int status=0,getsuccess=0;
    private String url_get_report="",datevalue="",workstatusvalue="",locationvalue="",descriptiontxt="",amountvalue="",name="";
    private Bitmap image=null,signature=null;
    private TextView datetxt,workstatustxt,tickettxt,locationtxt,description,amounttxt,customersignaturenametxt;
    private  ImageView imageicon,signatureicon;
    private Snackbar snackBar;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_showworkreport);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        date = getIntent().getExtras().getString("date","");
        ticket = getIntent().getExtras().getString("ticket","");
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        mycontext = this;
        progressbar = (ProgressBar) findViewById(R.id.reportprogressBar);
        datetxt = (TextView) findViewById(R.id.date);
        workstatustxt = (TextView) findViewById(R.id.workstatus);
        tickettxt = (TextView) findViewById(R.id.ticket);
        locationtxt = (TextView) findViewById(R.id.location);
        description = (TextView) findViewById(R.id.description);
        amounttxt = (TextView) findViewById(R.id.amount);
        customersignaturenametxt = (TextView) findViewById(R.id.customersignaturename);
        imageicon = (ImageView) findViewById(R.id.image);
        signatureicon = (ImageView) findViewById(R.id.signature);
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
        if(isNetworkAvailable())
        {
            report = new getworkreportdetails();
            StartAsyncTaskInParallel(report);
        }
        else
        {
            //Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check the internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }
    }
    public  boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    //    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private  void StartAsyncTaskInParallel(getworkreportdetails task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class getworkreportdetails extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            status = 0;

        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_showworkreport"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_report = product.getString("url");


                    List<NameValuePair> getticketsparams = new ArrayList<NameValuePair>();
                    getticketsparams.add(new BasicNameValuePair("companyname",registeredcompany ));
                    getticketsparams.add(new BasicNameValuePair("workdoneby", registeredemailid ));
                    getticketsparams.add(new BasicNameValuePair("ticketnumber", ticket ));
                    getticketsparams.add(new BasicNameValuePair("dateandtime", date ));

                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_report, "GET", getticketsparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("workreport"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();
                        // for(int i=0;i<countval;i++) {
                        product2 = productObj2.getJSONObject(0);
                        datevalue=product2.getString("dateandtime");
                        workstatusvalue=product2.getString("workstatus");
                        locationvalue=product2.getString("workdonelocation");
                        descriptiontxt=product2.getString("workreportdetails");
                        amountvalue=product2.getString("amountreceived");
                        name=product2.getString("nameofsignature");
                        image=globalvariables.StringToBitMap(product2.getString("image"));
                        signature=globalvariables.StringToBitMap(product2.getString("customersignature"));
                        // }

                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            report = null;
            progressbar.setVisibility(View.GONE);
            if(status==1)
            {
                workstatustxt.setVisibility(View.VISIBLE);
                datetxt.setText("Created On:"+datevalue);
                workstatustxt.setText(workstatusvalue);
                tickettxt.setText("Ticket No:"+ticket);
                locationtxt.setText("Location:"+locationvalue);
                description.setText("Comments:\n"+descriptiontxt);
                amounttxt.setText("Amount:"+amountvalue);
                customersignaturenametxt.setText("Customer Signature:"+name);
                if(amountvalue.equalsIgnoreCase("0"))
                {
                    amounttxt.setVisibility(View.GONE);
                }else
                {
                    amounttxt.setVisibility(View.VISIBLE);
                }
                if(descriptiontxt.equalsIgnoreCase("")||descriptiontxt.equalsIgnoreCase("no data available"))
                {
                    description.setVisibility(View.GONE);
                }else
                {
                    description.setVisibility(View.VISIBLE);
                }
                if(image!=null) {
                    imageicon.setVisibility(View.VISIBLE);
                    imageicon.setImageBitmap(image);

                }
                else
                {
                    imageicon.setVisibility(View.GONE);

                }
                if(signature!=null) {
                    signatureicon.setVisibility(View.VISIBLE);
                    customersignaturenametxt.setVisibility(View.VISIBLE);
                    signatureicon.setImageBitmap(signature);

                }
                else
                {
                    signatureicon.setVisibility(View.GONE);
                    customersignaturenametxt.setVisibility(View.GONE);
                }
            }
            else
            {
               // Toast.makeText(mycontext,"No data found", Toast.LENGTH_LONG).show();
                snackBar.dismiss();
                snackBar = Snackbar.make(findViewById(android.R.id.content),  "No data found", Snackbar.LENGTH_INDEFINITE);
                toast();
            }
        }
        @Override
        protected void onCancelled() {
            report = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
