package com.b2lmobitech.fieldcloudplus.serviceold;

import android.Manifest;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Address;
import android.location.Geocoder;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.core.app.ActivityCompat;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.util.Base64;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.dashboard;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.answerstable;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.summaryadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class summary_offline extends AppCompatActivity {
    private Context mycontext;
    private summaryadapter adapter;
    private sqldatabase mDbHelper;
    private String registeredcompany,registeredemailid,categoryname,registeredcustomer,registeredcustomertype,registeredcombinationname,registeredcombinationtype,registeredquestionmode,registeredfacility;
    private ArrayList<String> subcategories,questionnumberslist,questions,answers,typeofquestion;
    private  updatedataintoserver mytask = null;
    private String url_insert_multiplerecords_answerstable = "";
    private int status=0;
    private ProgressBar progressbar;
    private static final int CAMERA_CAPTURE_IMAGE_REQUEST_CODE = 100;
    public static Context summarycontext;
    //--Location
    private LocationManager locationManager;
    private LocationListener locationListener;
    private boolean isGPSEnabled = false;
    private boolean isNetworkEnabled = false;
    private boolean canGetLocation = false;
    // The minimum distance to change Updates in meters
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 10; // 10 meters
    // The minimum time between updates in milliseconds
    private static final long MIN_TIME_BW_UPDATES = 1000 * 60 * 1;
    private android.location.Location location;
    private boolean running = false;
    private String currentlocation = "Not found";
    private Double currentlocationlaltitue = 0.0, currentlocationlongitude = 0.0;
    private List<Address> addresses = null;
    private static final AndroidHttpClient ANDROID_HTTP_CLIENT = AndroidHttpClient.newInstance(ATMlistactivity.class.getName());
    private Snackbar snackBar;

    String regdate;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_summary);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        mycontext = this;
        summarycontext = this;
        mDbHelper = new sqldatabase(mycontext);
        //  progressbar = new ProgressBar(mycontext, null, android.R.attr.progressBarStyleSmall);
        progressbar = (ProgressBar)findViewById(R.id.progressBarsummary);
        subcategories = new ArrayList<String>();
        questions = new ArrayList<String>();
        questionnumberslist = new ArrayList<String>();
        answers = new ArrayList<String>();
        typeofquestion = new ArrayList<String>();
        ListView summmarylistview = (ListView) findViewById(R.id.summmarylistview);
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        Intent intent = getIntent();
        categoryname=intent.getStringExtra("Categoryname");
        registeredcustomer = intent.getStringExtra("customername");
        registeredcustomertype = intent.getStringExtra("customertype");
        registeredfacility = intent.getStringExtra("facility");
        registeredquestionmode = intent.getStringExtra("questionmode");
        registeredcombinationname = intent.getStringExtra("combinationname");
        registeredcombinationtype = intent.getStringExtra("combinationtype");

        Log.e("facility_summary",registeredcombinationtype);


        Date date = new Date();
        Calendar c = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        regdate= df1.format(c.getTime());

        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
        Cursor answerstablecursor = mDbHelper.get_answerstable_summary(registeredcompany,registeredemailid,categoryname);
        if(answerstablecursor.moveToFirst()) {
            do {
                subcategories.add(answerstablecursor.getString(answerstablecursor.getColumnIndex(answerstable.SUBCATEGORY)));
                questionnumberslist.add(answerstablecursor.getString(answerstablecursor.getColumnIndex(answerstable.QUESTIONNUMBER)));
                questions.add(answerstablecursor.getString(answerstablecursor.getColumnIndex(answerstable.QUESTION)));
                answers.add(answerstablecursor.getString(answerstablecursor.getColumnIndex(answerstable.ANSWER)));
                typeofquestion.add(answerstablecursor.getString(answerstablecursor.getColumnIndex(answerstable.TYPEOFQUESTION)));
            } while (answerstablecursor.moveToNext());
            adapter = new summaryadapter(mycontext,registeredcompany,registeredcustomer,registeredfacility,registeredemailid,categoryname,subcategories,questionnumberslist,questions,answers,typeofquestion);
            summmarylistview.setAdapter(adapter);
        }
        answerstablecursor.close();
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.summary, menu);
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                break;
            case R.id.summary_done:


                 //   findlocation();




                    Cursor answers_cursor = mDbHelper.get_answerstable_summary(registeredcompany, registeredemailid, categoryname);

                    Log.e("answer length", String.valueOf(answers_cursor.getCount()));

                    if (answers_cursor.moveToFirst()) {


                        do {

                            String questionnumber = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTIONNUMBER));
                            String category = categoryname;
                            String subcategory = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.SUBCATEGORY));
                            String question = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTION));
                            String typeofquestion = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.TYPEOFQUESTION));
                            String answer = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.ANSWER));
                            byte[] image = answers_cursor.getBlob(answers_cursor.getColumnIndex(answerstable.IMAGE));
                            Bitmap bmp;
                            if (image != null) {
                                bmp = BitmapFactory.decodeByteArray(image, 0, image.length);
                            } else {
                                bmp = null;
                            }

                            String imagepath = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.IMAGEPATH));
                            String dateandtime = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.DATEANDTIME));
                            String lat = String.valueOf(currentlocationlaltitue);
                            String lon = String.valueOf(currentlocationlongitude);
                            String location = currentlocation;
                            String issue = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.ISSUE));


                            String uniqueid = registeredcustomer + "_" + registeredfacility + "_" + registeredquestionmode + "_" + registeredcombinationname + "_" + regdate;
                            if (typeofquestion.equalsIgnoreCase("image") || typeofquestion.equalsIgnoreCase("signature")) {
                                mDbHelper.insert_answerstablelocal_image(registeredcompany, registeredcustomer, registeredfacility, registeredemailid, category, subcategory, questionnumber, question, typeofquestion, answer, bmp, imagepath, dateandtime, issue, registeredcustomertype, registeredquestionmode, registeredcombinationname, uniqueid);

                            } else {
                                mDbHelper.insert_answerstablelocal(registeredcompany, registeredcustomer, registeredfacility, registeredemailid, category, subcategory, questionnumber, question, typeofquestion, answer, bmp, imagepath, dateandtime, issue, registeredcustomertype, registeredquestionmode, registeredcombinationname, uniqueid);

                            }


                        } while (answers_cursor.moveToNext());


                    }



                if(isNetworkAvailable()) {
//                     mytask = new updatedataintoserver();
//                    StartAsyncTaskInParallel(mytask);
                    progressbar.setVisibility(View.VISIBLE);

                    mytask = new updatedataintoserver();
                    StartAsyncTaskInParallel(mytask);

                    // findlocation();
                }


                else {

                    mDbHelper.delete_answerstablefull();
                    finish();
                }


                    break;
            default:
                break;
        }
        return  true;
        //return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onResume() {
        super.onResume();
        adapter.notifyDataSetChanged();
    }

    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(updatedataintoserver task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class updatedataintoserver extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            Snackbar.make(findViewById(android.R.id.content), "Please do not press back..", Snackbar.LENGTH_LONG)
                    .setAction("Action", null).show();
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();
                List<NameValuePair> insertparams = new ArrayList<NameValuePair>();
                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "insert_answers"));
                JSONArray jsonarray = new JSONArray();

                int insertsuccess = 0;

                Log.e("do in bacg","coming");
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_insert_multiplerecords_answerstable = product.getString("url");

                    Log.e("url",url_insert_multiplerecords_answerstable);


                    Cursor answers_cursor = mDbHelper.get_answerstable_summary(registeredcompany,registeredemailid,categoryname);
                    if(answers_cursor.moveToFirst())
                    {
                        Log.e("answer table","coming");

                        ArrayList<String> category_sync = new ArrayList<String>();
                        ArrayList<String> subcategory_sync = new ArrayList<String>();
                        ArrayList<String> question_sync = new ArrayList<String>();
                        ArrayList<String> questionumber_sync = new ArrayList<String>();



                        // Log.e("camera string",  globalvariables.getString(answers_cursor.getBlob(answers_cursor.getColumnIndex(answerstable.IMAGE))));

                        do{
                            JSONObject JSONList = new JSONObject();//if you declare outside data vl get replace,so dont chnage from here

                            JSONList.put("companyname",registeredcompany);
                            JSONList.put("customername",registeredcustomer);
                            JSONList.put("atmid",registeredfacility);
                            JSONList.put("emailid",registeredemailid);
                            JSONList.put("questionnumber",answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTIONNUMBER)));
                            JSONList.put("category",categoryname);
                            JSONList.put("subcategory",answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.SUBCATEGORY)));
                            JSONList.put("question",answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTION)));
                            JSONList.put("typeofquestion",answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.TYPEOFQUESTION)));
                            JSONList.put("answer",answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.ANSWER)));
                            byte[] cam=answers_cursor.getBlob(answers_cursor.getColumnIndex(answerstable.IMAGE));
                            String temp =null;
                            if(cam!=null) {
                                temp = Base64.encodeToString(cam, Base64.DEFAULT);
                                Log.e("Camera", temp);
                            }
                            JSONList.put("image",temp);
                            JSONList.put("imagepath",answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.IMAGEPATH)));
                            JSONList.put("dateandtime",answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.DATEANDTIME)));
                            JSONList.put("latitude",currentlocationlaltitue);
                            JSONList.put("longitude",currentlocationlongitude);
                            JSONList.put("location",currentlocation);
                            JSONList.put("issue",answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.ISSUE)));

                            JSONList.put("questionmode",registeredquestionmode);
                            JSONList.put("customertype",registeredcustomertype);
                            JSONList.put("combinationname",registeredcombinationname);
                            JSONList.put("combinationtype",registeredcombinationtype);
                            JSONList.put("uniqueid",registeredcustomer+"_"+registeredfacility+"_"+registeredquestionmode+"_"+registeredcombinationname+"_"+regdate);


                            jsonarray.put(JSONList);
                            //---
                            /*subcategory_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.SUBCATEGORY)));
                            question_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTION)));
                            questionumber_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTIONNUMBER)));*/

                            category_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.CATEGORY)));
                            subcategory_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.SUBCATEGORY)));
                            question_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTION)));
                            questionumber_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTIONNUMBER)));


                        }while(answers_cursor.moveToNext());
                        insertparams.add(new BasicNameValuePair("JSON", String.valueOf(jsonarray)));//[{},{}]
                        //{}-Json object,[]-Json array


                        try {
                            JSONObject json_insert = jParser.makeHttpRequest(
                                    url_insert_multiplerecords_answerstable, "POST", insertparams);
                            insertsuccess = json_insert.getInt("success");
//                        message = json_insert.getString("message");

                            if (insertsuccess == 1) {

                                for(int i=0;i<question_sync.size();i++)
                                {
                                    mDbHelper.update_answerstable_local(registeredcompany,registeredcustomer,registeredfacility,registeredemailid,category_sync.get(i),subcategory_sync.get(i),questionumber_sync.get(i),question_sync.get(i));

                                }

                                for(int i=0;i<question_sync.size();i++)
                                {
                                    mDbHelper.delete_answerstable(registeredcompany,registeredcustomer,registeredfacility,registeredemailid,categoryname,subcategory_sync.get(i),questionumber_sync.get(i),question_sync.get(i));

                                }
                                status = 1;

                            }
                            else
                            {
                                status = 0;

                            }
                        } catch (Exception e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();

                        }
                    }

                    answers_cursor.close();
                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products
            if( status == 1)
            {
                Toast.makeText(mycontext,"Submitted.",Toast.LENGTH_LONG).show();
                //finish();

                Cursor answers_synced = mDbHelper.get_answerstablelocal_synced(registeredcompany,registeredemailid,"Yes");
                Cursor question_local =  mDbHelper.get_dynamicquestions_local_all(registeredcompany);

                if(answers_synced.getCount()==question_local.getCount())
                {
                    mDbHelper.delete_dynamicquestions_local_all();
                    mDbHelper.delete_answers_local_all();
                    snackBar.dismiss();
                    //  snackBar = Snackbar.make(findViewById(android.R.id.content), "All Data Synced.", Snackbar.LENGTH_INDEFINITE);
                    // toast();

                    Toast.makeText(mycontext, "All Data Synced", Toast.LENGTH_SHORT).show();

                    Intent intent = new Intent(mycontext, dashboard.class);
                    startActivity(intent);

                }else{

                   finish();
                }
            }
            else
            {
                //Toast.makeText(mycontext,"Not inserted!!Please try again.",Toast.LENGTH_LONG).show();
                snackBar.dismiss();
                snackBar = Snackbar.make(findViewById(android.R.id.content), "Report is not submitted!!Please try again.", Snackbar.LENGTH_INDEFINITE);
                toast();
            }

            mytask = null;
            progressbar.setVisibility(View.GONE);
        }
        @Override
        protected void onCancelled() {
            mytask = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if (requestCode == CAMERA_CAPTURE_IMAGE_REQUEST_CODE) {
            if (resultCode == RESULT_OK) {
                try {
                    File filename = summaryadapter.summaryimagefilepath;
                    decodemyFile(filename);
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    Toast.makeText(getApplicationContext(),
                            "please try again", Toast.LENGTH_SHORT)
                            .show();
                }
            } else if (resultCode == RESULT_CANCELED) {

                // user cancelled Image capture
                Toast.makeText(getApplicationContext(),
                        "You cancelled image capture", Toast.LENGTH_SHORT)
                        .show();

            } else {
                // failed to capture image
                Toast.makeText(getApplicationContext(),
                        "Sorry! Failed to capture image", Toast.LENGTH_SHORT)
                        .show();
            }

        }
        else if (requestCode == 500) {
            if (resultCode == RESULT_OK) {
//                try {
////                    Toast.makeText(getApplicationContext(),
////                            "signature updated", Toast.LENGTH_SHORT)
////                            .show();
//                } catch (Exception e) {
//                    // TODO Auto-generated catch block
//                    Toast.makeText(getApplicationContext(),
//                            "please try again", Toast.LENGTH_SHORT)
//                            .show();
//                }
            } else if (resultCode == RESULT_CANCELED) {

                // user cancelled Image capture
                Toast.makeText(getApplicationContext(),
                        "You cancelled signature", Toast.LENGTH_SHORT)
                        .show();

            } else {
                // failed to capture image
                Toast.makeText(getApplicationContext(),
                        "Sorry! Failed to capture signature", Toast.LENGTH_SHORT)
                        .show();
            }

        }
        adapter.notifyDataSetChanged();

    }
    private void decodemyFile(File f) {
        try {
            // Decode image size
            final BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream(new FileInputStream(f), null, o);

            o.inSampleSize = calculateInSampleSize(o, 300, 300);
            o.inJustDecodeBounds = false;
            //---

            Bitmap bmp = BitmapFactory.decodeStream(new FileInputStream(f), null, o);//o2
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            //bmp.creates
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, stream);
            byte[] byteArray = stream.toByteArray();
            try {
                //convert file into array of bytes
                FileOutputStream fileOuputStream =
                        new FileOutputStream(f);//outputfile
                fileOuputStream.write(byteArray);
                fileOuputStream.flush();
                fileOuputStream.close();

                String questionval = summaryadapter.summaryquestion;
                //Toast.makeText(mycontext,"reciever="+questionval,Toast.LENGTH_LONG).show();
                File filename = summaryadapter.summaryimagefilepath;

                if(Uri.fromFile(filename).getPath()!=null)
                {
                    SimpleDateFormat dateFormatter = new SimpleDateFormat
                            ("yyyy-MM-dd HH:mm:ss");
                    String todaydate = dateFormatter.format(new Date());
                    Cursor answertablecursor = mDbHelper.get_answerstable(registeredcompany, registeredemailid, categoryname, summaryadapter.summarysubcategory, questionval);
                    // Toast.makeText(mycontext,"answertablecursor.getCount()="+answertablecursor.getCount(),Toast.LENGTH_LONG).show();
                    if (answertablecursor.getCount() != 0) {
                        mDbHelper.update_answerstable(registeredcompany,registeredcustomer,registeredfacility, registeredemailid, categoryname, summaryadapter.summarysubcategory,summaryadapter.summaryquestionumber, questionval, "image", "no data available", bmp, summaryadapter.summarypicturefilename, todaydate,"no");
                    } else {

                        mDbHelper.insert_answerstable(registeredcompany,registeredcustomer,registeredfacility, registeredemailid, categoryname, summaryadapter.summarysubcategory,summaryadapter.summaryquestionumber, questionval, "image", "no data available", bmp, summaryadapter.summarypicturefilename, todaydate,"no");
                    }
                    answertablecursor.close();
                    //adapter.notifyDataSetChanged();
                }


            }catch(Exception e){
                e.printStackTrace();
            }



        } catch (FileNotFoundException e) {}
        // return null;
    }
    public static int calculateInSampleSize(
            BitmapFactory.Options options, int reqWidth, int reqHeight) {
        //Raw height and width of image
        final int height = options.outHeight;
        final int width = options.outWidth;
        int inSampleSize = 1;

        if (height > reqHeight || width > reqWidth) {

            final int halfHeight = height / 2;
            final int halfWidth = width / 2;

            // Calculate the largest inSampleSize value that is a power of 2 and keeps both
            // height and width larger than the requested height and width.
            while ((halfHeight / inSampleSize) >= reqHeight
                    && (halfWidth / inSampleSize) >= reqWidth) {
                inSampleSize *= 2;
            }
        }

        return inSampleSize;
    }
    //---
    public void findlocation()
    {

        try {
//				Log.d("findlocation","findlocation");
            final Geocoder geocoder = new Geocoder(mycontext, Locale.getDefault());
            locationManager = (LocationManager) mycontext.getSystemService(Context.LOCATION_SERVICE);

            locationListener = new LocationListener() {

                @Override
                public void onStatusChanged(String provider, int status, Bundle extras) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onProviderEnabled(String provider) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onProviderDisabled(String provider) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onLocationChanged(android.location.Location location) {
                    // TODO Auto-generated method stub

                }
            };
            // getting GPS status
            isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
//            if(!isGPSEnabled)
//            {
//                Toast.makeText(mycontext,"Turn your GPS 'ON' for location access", Toast.LENGTH_LONG).show();
//            }
            // getting network status
            isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
            try {
                if (!isGPSEnabled && !isNetworkEnabled) {
                    // no network provider is enabled
                    //Toast.makeText(mycontext,"Turn your GPS 'ON' for location access (or)data network for internet", Toast.LENGTH_LONG).show();
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content),"Turn your GPS 'ON' for location access (or)data network for internet", Snackbar.LENGTH_INDEFINITE);
                    toast();
                } else {
                    this.canGetLocation = true;

                    // First get location from Network Provider
                    if (isNetworkEnabled) {
                        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                            // TODO: Consider calling
                            //    ActivityCompat#requestPermissions
                            // here to request the missing permissions, and then overriding
                            //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
                            //                                          int[] grantResults)
                            // to handle the case where the user grants the permission. See the documentation
                            // for ActivityCompat#requestPermissions for more details.
                            return;
                        }
                        locationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                        if (locationManager != null) {
                            location = locationManager
                                    .getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
                            if (location != null) {
                                currentlocationlaltitue = location.getLatitude();
                                currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                try {
                                    addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                    Address address = addresses.get(0);
                                    ArrayList<String> addressFragments = new ArrayList<String>();
                                    // Fetch the address lines using getAddressLine,
                                    // join them, and send them to the thread.
                                    for(int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                        addressFragments.add(address.getAddressLine(i));
                                    }
                                    currentlocation = addressFragments.toString();
                                    insert_locationalso(currentlocationlaltitue,currentlocationlongitude,currentlocation);
                                } catch (Exception e) {
                                    // TODO Auto-generated catch block
//										e.printStackTrace();
                                  //fetchCityName(mycontext, location);
                                }
                            }

                            else {
                                locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                                if (locationManager != null) {
                                    location = locationManager
                                            .getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
                                    if (location != null) {
                                        currentlocationlaltitue = location.getLatitude();
                                        currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                        try {
                                            addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                            Address address = addresses.get(0);
                                            ArrayList<String> addressFragments = new ArrayList<String>();
                                            // Fetch the address lines using getAddressLine,
                                            // join them, and send them to the thread.
                                            for (int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                                addressFragments.add(address.getAddressLine(i));
                                            }
                                            currentlocation = addressFragments.toString();
                                            insert_locationalso(currentlocationlaltitue, currentlocationlongitude, currentlocation);
                                        } catch (Exception e) {
                                            // TODO Auto-generated catch block
//										e.printStackTrace();
                                        //    fetchCityName(mycontext, location);
                                        }
                                    }
                                }

                            }
                        }


                        else {
                            locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                            if (locationManager != null) {
                                location = locationManager
                                        .getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
                                if (location != null) {
                                    currentlocationlaltitue = location.getLatitude();
                                    currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                    try {
                                        addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                        Address address = addresses.get(0);
                                        ArrayList<String> addressFragments = new ArrayList<String>();
                                        // Fetch the address lines using getAddressLine,
                                        // join them, and send them to the thread.
                                        for (int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                            addressFragments.add(address.getAddressLine(i));
                                        }
                                        currentlocation = addressFragments.toString();
                                        insert_locationalso(currentlocationlaltitue, currentlocationlongitude, currentlocation);
                                    } catch (Exception e) {
                                        // TODO Auto-generated catch block
//										e.printStackTrace();
                                     //   fetchCityName(mycontext, location);
                                    }
                                }
                            }

                        }

                    }
                    // if GPS Enabled get lat/long using GPS Services
                    if (isGPSEnabled) {
                        if (location == null) {
                            locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
//					             Log.d("GPS Enabled", "GPS Enabled");
                            if (locationManager != null) {
                                location = locationManager
                                        .getLastKnownLocation(LocationManager.GPS_PROVIDER);
                                if (location != null) {
                                    currentlocationlaltitue = location.getLatitude();
                                    currentlocationlongitude = location.getLongitude();

                                    try {
                                        addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                        Address address = addresses.get(0);
                                        ArrayList<String> addressFragments = new ArrayList<String>();
                                        // Fetch the address lines using getAddressLine,
                                        // join them, and send them to the thread.
                                        for(int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                            addressFragments.add(address.getAddressLine(i));
                                        }
                                        currentlocation = addressFragments.toString();
                                        insert_locationalso(currentlocationlaltitue,currentlocationlongitude,currentlocation);
                                    } catch (Exception e) {
                                        // TODO Auto-generated catch block
//											e.printStackTrace();
                                    //    fetchCityName(mycontext, location);
                                    }

                                }

                                else {
                                    locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                                    if (locationManager != null) {
                                        location = locationManager
                                                .getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
                                        if (location != null) {
                                            currentlocationlaltitue = location.getLatitude();
                                            currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                            try {
                                                addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                                Address address = addresses.get(0);
                                                ArrayList<String> addressFragments = new ArrayList<String>();
                                                // Fetch the address lines using getAddressLine,
                                                // join them, and send them to the thread.
                                                for (int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                                    addressFragments.add(address.getAddressLine(i));
                                                }
                                                currentlocation = addressFragments.toString();
                                                insert_locationalso(currentlocationlaltitue, currentlocationlongitude, currentlocation);
                                            } catch (Exception e) {
                                                // TODO Auto-generated catch block
//										e.printStackTrace();
                                             //   fetchCityName(mycontext, location);
                                            }
                                        }
                                    }

                                }

                            }

                            else {
                                locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                                if (locationManager != null) {
                                    location = locationManager
                                            .getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
                                    if (location != null) {
                                        currentlocationlaltitue = location.getLatitude();
                                        currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                        try {
                                            addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                            Address address = addresses.get(0);
                                            ArrayList<String> addressFragments = new ArrayList<String>();
                                            // Fetch the address lines using getAddressLine,
                                            // join them, and send them to the thread.
                                            for (int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                                addressFragments.add(address.getAddressLine(i));
                                            }
                                            currentlocation = addressFragments.toString();
                                            insert_locationalso(currentlocationlaltitue, currentlocationlongitude, currentlocation);
                                        } catch (Exception e) {
                                            // TODO Auto-generated catch block
//										e.printStackTrace();
                                         //   fetchCityName(mycontext, location);
                                        }
                                    }
                                }

                            }
                        }


                    }
                }
            } catch (Exception e1) {
                // TODO Auto-generated catch block
//					e1.printStackTrace();
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
//				e.printStackTrace();
        }


    }

    private void insert_locationalso(Double latitude,Double longitude,String locationname) {
        Cursor answers_cursor = mDbHelper.get_answerstable_summary(registeredcompany, registeredemailid, categoryname);
        if (answers_cursor.moveToFirst()) {


            do {
                JSONObject JSONList = new JSONObject();//if you declare outside data vl get replace,so dont chnage from here

//                JSONList.put("companyname",registeredcompany);
//                JSONList.put("customername",registeredcustomer);
//                JSONList.put("atmid",registeredfacility);
//                JSONList.put("emailid",registeredemailid);
                String questionnumber = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTIONNUMBER));
                String category = categoryname;
                String subcategory = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.SUBCATEGORY));
                String question = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.QUESTION));
                String typeofquestion = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.TYPEOFQUESTION));
                String answer = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.ANSWER));
                byte[] image = answers_cursor.getBlob(answers_cursor.getColumnIndex(answerstable.IMAGE));

                Bitmap bmp = BitmapFactory.decodeByteArray(image, 0, image.length);

                String imagepath = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.IMAGEPATH));
                String dateandtime = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.DATEANDTIME));
                String lat = String.valueOf(currentlocationlaltitue);
                String lon = String.valueOf(currentlocationlongitude);
                String location = currentlocation;
                String issue = answers_cursor.getString(answers_cursor.getColumnIndex(answerstable.ISSUE));

//                JSONList.put("questionmode",registeredquestionmode);
//                JSONList.put("customertype",registeredcustomertype);
//                JSONList.put("combinationname",registeredcombinationname);
//                JSONList.put("combinationtype",registeredcombinationtype);
                String uniqueid = registeredcustomer + "_" + registeredfacility + "_" + registeredquestionmode + "_" + registeredcombinationname + "_" + regdate;

                mDbHelper.insert_answerstablelocal(registeredcompany,registeredcustomer,registeredfacility,registeredemailid, category, subcategory,questionnumber, question, typeofquestion, answer, bmp, imagepath, dateandtime,issue,registeredcustomertype,registeredquestionmode,registeredcombinationname,uniqueid);


            } while (answers_cursor.moveToNext());


            mDbHelper.delete_answerstablefull();
            finish();

        }
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
