package com.b2lmobitech.fieldcloudplus.serviceold;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.text.Html;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;

public class ticketdetails_close extends AppCompatActivity {
    private ProgressBar progressbar;
    private getticketdetails gettask = null;
    private ListView list;
    private ArrayList<String> ticketnumbers;
    private Context mycontext;
    private String url_get_ticketdetails = "",registeredcompany,registeredemailid,createdontxt="",assignedontxt="",ticketnumbertxt="",Categortypetxt="",prioritytxt="";
    private String customernametxt="",customertypetxt="",customermodetxt="",questiontypetxt="",callreasontxt="",latitude="",longitude="",location="",contactpersontxt="",phonenumbertxt="",productstxt="",brand="",model="",serialnumber="",selectedticketnumber="";
    private int status =0;
    private TextView createdon,customertype,assignedon,ticketnumber,Categortype,priority,customer,categorymode,customermode,facility,designation,group,subgroup,team, type,callreason,contactperson,phonenumber,products,brands,models,serials,address;
    private ImageView mapicon;
    private Snackbar snackBar;

    private String questionmode,questiontype,combinationname,combinationtype,facilityval;

    LinearLayout thirdsublayout,fourthsublayout,fifthsublayout,sixthsublayout;

    String products_txt="-",brands_txt="-",models_txt="-",serials_txt="-",designation_txt="-",group_txt="-",subgroup_txt="-",team_txt="-";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ticketdetails_close);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
        mycontext = this;
        progressbar = (ProgressBar)findViewById(R.id.ticketprogressBar);
        selectedticketnumber = getIntent().getExtras().getString("ticketnumber");
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        createdon = (TextView) findViewById(R.id.createdon);
        assignedon = (TextView)findViewById(R.id.assignedon);
        ticketnumber = (TextView)findViewById(R.id.ticnum);
        Categortype = (TextView)findViewById(R.id.Categortype);
        priority = (TextView)findViewById(R.id.priority);
        customer = (TextView)findViewById(R.id.customerdetails);
        customermode = (TextView)findViewById(R.id.customermode);
        customertype = (TextView)findViewById(R.id.customertype);
        facility = (TextView)findViewById(R.id.facility);
        categorymode = (TextView)findViewById(R.id.categorymode);
        type = (TextView)findViewById(R.id.questiontype);
        callreason = (TextView)findViewById(R.id.questionfull);
        contactperson = (TextView)findViewById(R.id.contactperson);
        phonenumber = (TextView)findViewById(R.id.contactphone);
        products = (TextView)findViewById(R.id.product);
        brands = (TextView)findViewById(R.id.brand);
        models = (TextView)findViewById(R.id.model);
        serials = (TextView)findViewById(R.id.serial);
        mapicon = (ImageView)findViewById(R.id.locationfull);
        address = (TextView) findViewById(R.id.addressfull);
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);


        thirdsublayout = (LinearLayout) findViewById(R.id.thirdsublayout);
        fourthsublayout = (LinearLayout)findViewById(R.id.fourthsublayout);
        fifthsublayout = (LinearLayout)findViewById(R.id.fifthsublayout);
        sixthsublayout = (LinearLayout)findViewById(R.id.sixthsublayout);


        designation = (TextView)findViewById(R.id.designation);
        group = (TextView)findViewById(R.id.group);
        subgroup = (TextView)findViewById(R.id.subgroup);
        team = (TextView)findViewById(R.id.team);

        if(isNetworkAvailable())
        {
            gettask = new getticketdetails();
            StartAsyncTaskInParallel(gettask);//getActivity().getApplicationContext().
        }
        else
        {
           // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_ticketdetails_close, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
//        if (id == R.id.action_settings) {
//            return true;
//        }
        if (id == android.R.id.home) {
            onBackPressed();
            return true;
        }
//        else if (id == R.id.ticket_report) {
//           Toast.makeText(mycontext,"report",Toast.LENGTH_LONG).show();
//            return true;
//        }

        return super.onOptionsItemSelected(item);
    }
    public  boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private  void StartAsyncTaskInParallel(getticketdetails task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class getticketdetails extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            status = 0;
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_closeticketdetails"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_ticketdetails = product.getString("url");


                    List<NameValuePair> getticketsparams = new ArrayList<NameValuePair>();
                    getticketsparams.add(new BasicNameValuePair("companyname",registeredcompany ));//registeredcompany
                    getticketsparams.add(new BasicNameValuePair("Assignedto", registeredemailid ));//registeredemailid
                    getticketsparams.add(new BasicNameValuePair("ticketnumber", selectedticketnumber ));

                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_ticketdetails, "GET", getticketsparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("tickets"); // JSON Array

                        JSONObject product2 = null;

//                        int	countval = productObj2.length();
//                        for(int i=0;i<countval;i++)
//                        {
                        product2 = productObj2.getJSONObject(0);

                        createdontxt = product2.getString("createddateandtime").split(" ")[0];//"Created On:"+
                        assignedontxt = product2.getString("assigneddateandtime").split(" ")[0];//"Assigned On:"+
                        ticketnumbertxt = "Ticket No:"+product2.getString("ticketnumber");;
                        Categortypetxt = product2.getString("source");//"Category:"+
                        prioritytxt = product2.getString("priority");//"Priority:"+
                        customernametxt = product2.getString("customername");
                        customertypetxt = product2.getString("customertype");
                        customermodetxt = product2.getString("questiontype");//+"("+product2.getString("atmid")+")";//"Customer:"+
                        facilityval=product2.getString("atmid");
                        if(product2.getString("subcategory").equalsIgnoreCase(""))
                        {
                            questiontypetxt = product2.getString("category");
                        }
                        else {
                            questiontypetxt = product2.getString("category") + "(" + product2.getString("subcategory") + ")";//"Type:"+
                        }
                        callreasontxt = product2.getString("questionorcallreason");//"CallReason:\n"+
                        latitude = product2.getString("latitude");
                        longitude =product2.getString("longitude");
                        location = product2.getString("location");
                        contactpersontxt = product2.getString("contactperson");//"Contact Person:"+
                        phonenumbertxt = product2.getString("phonenumber");//"Phone no:"+
                        productstxt = product2.getString("product");
                        if(productstxt.equalsIgnoreCase("no data available"))
                        {
                            productstxt = " ";
                        }
                        brand = product2.getString("brand");
                        if(brand.equalsIgnoreCase("no data available"))
                        {
                            brand = " ";
                        }
                        model = product2.getString("model");
                        if(model.equalsIgnoreCase("no data available"))
                        {
                            model = " ";
                        }
                        serialnumber = product2.getString("serialnumber");
                        if(serialnumber.equalsIgnoreCase("no data available"))
                        {
                            serialnumber = " ";
                        }

                        questionmode= product2.getString("questionmode");
                        questiontype=product2.getString("questiontype");
                        combinationname= product2.getString("combinationname");
                        combinationtype=product2.getString("combinationtype");

                        //}


                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            gettask = null;
            progressbar.setVisibility(View.GONE);
//            Toast.makeText(mycontext,"getsuccess="+getsuccess,Toast.LENGTH_LONG).show();
//            Toast.makeText(mycontext,"status="+status,Toast.LENGTH_LONG).show();
            if(status==1)
            {
                createdon.setText(Html.fromHtml("Created On:" + "<font color='#000000'>"+createdontxt+"</font>"));//(createdontxt);
                assignedon.setText(Html.fromHtml("Assigned On:" + "<font color='#000000'>"+assignedontxt+"</font>"));//(assignedontxt);
                ticketnumber.setText(ticketnumbertxt);
                Categortype.setText(Html.fromHtml("Category:" + "<font color='#000000'>"+Categortypetxt+"</font>"));//(Categortypetxt);
                priority.setText(Html.fromHtml("Priority:" + "<font color='#000000'>"+prioritytxt+"</font>"));//(prioritytxt);
                categorymode.setText(Html.fromHtml("CategoryMode:" + "<font color='#000000'>"+questionmode+"</font>"));//(customernametxt);
                customertype.setVisibility(View.VISIBLE);
                customertype.setText(Html.fromHtml("CustomerType:" + "<font color='#000000'>"+customertypetxt+"</font>"));//(customernametxt);
                type.setText(Html.fromHtml("CallType:" + "<font color='#000000'>"+questiontypetxt+"</font>"));//(questiontypetxt);
                callreason.setText(Html.fromHtml("CallReason:" + "<font color='#000000'>"+callreasontxt+"</font>"));//(callreasontxt);
                contactperson.setText(Html.fromHtml("Contact Person:" + "<font color='#000000'>"+contactpersontxt+"</font>"));//(contactpersontxt);
                phonenumber.setText(Html.fromHtml("Phone no:" + "<font color='#000000'>"+phonenumbertxt+"</font>"));//(phonenumbertxt);
//                products.setText(productstxt);
//                brands.setText(brand);
//                models.setText(model);
//                serials.setText(serialnumber);
                if(location.equalsIgnoreCase("no data available")||location.equalsIgnoreCase("")) {
                    address.setText(Html.fromHtml("Address:" + "<font color='#000000'>"+"Not Found"+"</font>"));
                }
                else
                {
                    address.setText(Html.fromHtml("Address:" + "<font color='#000000'>"+location+"</font>"));
                }

               ///////////////////////////////////////////////////////////////



                char[] ch=combinationtype.toCharArray();

                String[] name_array=combinationname.split("#@");

                StringBuilder sb=new StringBuilder();
                sb.append("Company");
                for(int i=0;i<ch.length;i++) {
                    if(ch[i]=='o')
                    {
                        customermode.setVisibility(View.VISIBLE);
                        customermode.setText(Html.fromHtml("CustomerMode:" + "<font color='#000000'>"+name_array[i+1]+"</font>"));
                    }
                    else if(ch[i]=='c')
                    {
                        //sb.append("#@CustomerName");
                        customer.setVisibility(View.VISIBLE);
                        customer.setText(Html.fromHtml("Customer:" + "<font color='#000000'>"+name_array[i+1]+"</font>"));
                        // customer.setText(name_array[i+1]);

                    }
                    else if(ch[i]=='f')
                    {
                        facility.setVisibility(View.VISIBLE);
                        facility.setText(Html.fromHtml("Facility:" + "<font color='#000000'>"+name_array[i+1]+"</font>"));
                    }
                    else if(ch[i]=='b')
                    {
                        brands_txt=name_array[i+1];
                    }
                    else if(ch[i]=='p')
                    {
                        products_txt=name_array[i+1];
                    }
                    else if(ch[i]=='m')
                    {
                        models_txt=name_array[i+1];
                    }
                    else if(ch[i]=='n')
                    {
                        serials_txt=name_array[i+1];
                    }
                    else if(ch[i]=='r')
                    {
                        designation_txt=name_array[i+1];
                    }
                    else if(ch[i]=='g')
                    {
                        group_txt=name_array[i+1];
                    }
                    else if(ch[i]=='s')
                    {
                        subgroup_txt=name_array[i+1];
                    }
                    else if(ch[i]=='t')
                    {
                        team_txt=name_array[i+1];
                    }
                }

                products.setText(products_txt);
                brands.setText(brands_txt);
                models.setText(models_txt);
                serials.setText(serials_txt);

                designation.setText(designation_txt);
                group.setText(group_txt);
                subgroup.setText(subgroup_txt);
                team.setText(team_txt);

                if(questionmode.equalsIgnoreCase("customer"))
                {
                    fifthsublayout.setVisibility(View.GONE);
                    sixthsublayout.setVisibility(View.GONE);

                }
                else if(questionmode.equalsIgnoreCase("employee"))
                {
                    thirdsublayout.setVisibility(View.GONE);
                    fourthsublayout.setVisibility(View.GONE);
                }
                else if(questionmode.equalsIgnoreCase("custom"))
                {
                    customermode.setVisibility(View.VISIBLE);
                    customermode.setText(Html.fromHtml("CustomerMode:" + "<font color='#000000'>"+customermodetxt+"</font>"));

                    customer.setVisibility(View.VISIBLE);
                    customer.setText(Html.fromHtml("Customer:" + "<font color='#000000'>"+customernametxt+"</font>"));

                    thirdsublayout.setVisibility(View.GONE);
                    fourthsublayout.setVisibility(View.GONE);
                    fifthsublayout.setVisibility(View.GONE);
                    sixthsublayout.setVisibility(View.GONE);
                }
                else if( questionmode.equalsIgnoreCase("product"))
                {
                    fifthsublayout.setVisibility(View.GONE);
                    sixthsublayout.setVisibility(View.GONE);
                    customermode.setVisibility(View.VISIBLE);
                    customermode.setText(Html.fromHtml("CustomerMode:" + "<font color='#000000'>"+customermodetxt+"</font>"));

                    customer.setVisibility(View.VISIBLE);
                    customer.setText(Html.fromHtml("Customer:" + "<font color='#000000'>"+customernametxt+"</font>"));
                    facility.setVisibility(View.VISIBLE);
                    facility.setText(Html.fromHtml("Customer:" + "<font color='#000000'>"+facilityval+"</font>"));
                }




                //////////////////////////////////////////////////////////////////////
                mapicon.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        try {
                            String geoUri = "";
                            if(latitude.equalsIgnoreCase("no data available"))
                            {
                                if(location.equalsIgnoreCase("no data available"))
                                {
                                   // Toast.makeText(mycontext,"No address found!!",Toast.LENGTH_LONG).show();
                                    snackBar.dismiss();
                                    snackBar = Snackbar.make(findViewById(android.R.id.content), "No address found!!", Snackbar.LENGTH_INDEFINITE);
                                    toast();
                                }
                                else
                                {
                                    geoUri = "http://maps.google.co.in/maps?q=" + location;
                                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(geoUri));
                                    mycontext.startActivity(intent);
                                }

                            }
                            else
                            {
                                geoUri = "http://maps.google.com/maps?q=loc:" + latitude + "," + longitude + " (" + location + ")";
                                Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(geoUri));
                                mycontext.startActivity(intent);
                            }

                        }catch(Exception e)
                        {
                            Toast.makeText(mycontext,"Map is not working!!",Toast.LENGTH_LONG).show();
                        }
                    }
                });


            }
            else
            {
               // Toast.makeText(mycontext,"No data found", Toast.LENGTH_LONG).show();
                snackBar.dismiss();
                snackBar = Snackbar.make(findViewById(android.R.id.content), "No data found", Snackbar.LENGTH_INDEFINITE);
                toast();
            }

        }
        @Override
        protected void onCancelled() {
            gettask = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
