package com.b2lmobitech.fieldcloudplus.serviceold;

import android.app.DatePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.DatePicker;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.workreportadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class workreportlist extends AppCompatActivity {
    private Animation fab_open, fab_close, rotate_forward, rotate_backward;
    private FloatingActionButton fab, fab1, fab2;
    private Boolean isFabOpen = false;
    private TextView addworktext,addcalendartext,history;
    private Context mycontext;
    private workreportadapter adapter;
    private ArrayList<String> ticketnumbers,workstatus,date,description;
    private ArrayList<Bitmap> image;
    private ListView workreportlistview;
    private ProgressBar progressbar;
    private  getworkreportlist getworkreport = null;
    private  int status = 0,getsuccess=0;
    private String url_get_workreport="",selecteddate ="0000-00-00", month,day,registeredcompany,registeredemailid;
    private SwipeRefreshLayout swipeContainer;
    private Snackbar snackBar;
    private sqldatabase mDbHelper;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_workreportlist);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);
        fab = (FloatingActionButton) findViewById(R.id.fab);
        fab1 = (FloatingActionButton) findViewById(R.id.fab1);
        fab2 = (FloatingActionButton) findViewById(R.id.fab2);
        fab_open = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.fab_open);
        fab_close = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.fab_close);
        rotate_forward = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.rotate_forward);
        rotate_backward = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.rotate_backward);
        addworktext = (TextView) findViewById(R.id.addworktext);
        addcalendartext = (TextView) findViewById(R.id.addcalendartext);
        workreportlistview = (ListView) findViewById(R.id.workreportlistview);
        progressbar = (ProgressBar) findViewById(R.id.workreportprogressBar);
        history = (TextView) findViewById(R.id.history);
        swipeContainer = (SwipeRefreshLayout) findViewById(R.id.swipeContainer);
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
                animateFAB();
            }
        });
        fab1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                mDbHelper.delete_sparestablefull();

                Intent intent = new Intent(mycontext, workreport.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                mycontext.startActivity(intent);
            }
        });
        fab2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                final Calendar c = Calendar.getInstance();
                int mYear = c.get(Calendar.YEAR); // current year
                int mMonth = c.get(Calendar.MONTH); // current month
                int mDay = c.get(Calendar.DAY_OF_MONTH); // current day
                // date picker dialog
                DatePickerDialog datePickerDialog = new DatePickerDialog(mycontext,
                        new DatePickerDialog.OnDateSetListener() {

                            @Override
                            public void onDateSet(DatePicker view, int year,
                                                  int monthOfYear, int dayOfMonth) {
                                // set day of month , month and year value in the edit text
                                monthOfYear = monthOfYear+1;
                                if(monthOfYear < 10){
                                    month = "0" + monthOfYear;
                                }
                                else
                                {
                                    month = "" + monthOfYear;
                                }
                                if(dayOfMonth < 10){

                                    day  = "0" + dayOfMonth ;
                                }
                                else
                                {
                                    day  = "" + dayOfMonth ;
                                }
                                selecteddate = year+"-"+month+"-"+day;
                                if(isNetworkAvailable())
                                {
                                    getworkreport = new getworkreportlist();
                                    StartAsyncTaskInParallel(getworkreport);
                                }
                                else
                                {
                                   // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
                                    snackBar.dismiss();
                                    snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
                                    toast();
                                }
                            }
                        }, mYear, mMonth, mDay);
                datePickerDialog.show();
            }
        });
        ticketnumbers=new ArrayList<String>();
        workstatus=new ArrayList<String>();
        date=new ArrayList<String>();
        description=new ArrayList<String>();
        image=new ArrayList<Bitmap>();
        adapter = new workreportadapter(mycontext, ticketnumbers,workstatus,date,description,image);
        workreportlistview.setAdapter(adapter);
        if(isNetworkAvailable())
        {
            history.setVisibility(View.GONE);
            getworkreport = new getworkreportlist();
            StartAsyncTaskInParallel(getworkreport);
        }
        else
        {
            history.setVisibility(View.VISIBLE);
            //Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }
        swipeContainer.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {

                if(isNetworkAvailable())
                {
                    selecteddate="0000-00-00";
                    getworkreport = new getworkreportlist();
                    StartAsyncTaskInParallel(getworkreport);
                }
                else
                {
                   // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
                    toast();
                }
                swipeContainer.setRefreshing(false);

            }
        });
    }


    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }

    public void animateFAB() {

        if (isFabOpen) {

            fab.startAnimation(rotate_backward);
            fab1.startAnimation(fab_close);
            fab2.startAnimation(fab_close);
            addworktext.setVisibility(View.GONE);
            addcalendartext.setVisibility(View.GONE);
            fab1.setClickable(false);
            fab2.setClickable(false);
            isFabOpen = false;


        } else {

            fab.startAnimation(rotate_forward);
            fab1.startAnimation(fab_open);
            fab2.startAnimation(fab_open);
            addworktext.setVisibility(View.VISIBLE);
            addcalendartext.setVisibility(View.VISIBLE);
            fab1.setClickable(true);
            fab2.setClickable(true);
            isFabOpen = true;


        }
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_workreportlist, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == android.R.id.home) {
            onBackPressed();
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
    public  boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    //    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private  void StartAsyncTaskInParallel(getworkreportlist task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class getworkreportlist extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            status = 0;
            ticketnumbers.clear();
            workstatus.clear();
            date.clear();
            description.clear();
            image.clear();
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_workreport"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_workreport = product.getString("url");


                    List<NameValuePair> getticketsparams = new ArrayList<NameValuePair>();
                    getticketsparams.add(new BasicNameValuePair("companyname",registeredcompany ));
                    getticketsparams.add(new BasicNameValuePair("workdoneby", registeredemailid ));
                    getticketsparams.add(new BasicNameValuePair("dateandtime", selecteddate ));

                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_workreport, "GET", getticketsparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("workreport"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();
                        for(int i=0;i<countval;i++) {
                            product2 = productObj2.getJSONObject(i);
                            ticketnumbers.add(product2.getString("ticketnumber"));
                            workstatus.add(product2.getString("workstatus"));
                            date.add(product2.getString("dateandtime"));
                            description.add(product2.getString("workreportdetails"));
                            image.add(globalvariables.StringToBitMap(product2.getString("image")));
                        }

                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            getworkreport = null;
            progressbar.setVisibility(View.GONE);
            //Toast.makeText(mycontext,"url_get_expenses"+url_get_expenses, Toast.LENGTH_LONG).show();
            if(status==1)
            {
                // Toast.makeText(mycontext,"ticketnumbers="+ticketnumbers, Toast.LENGTH_LONG).show();
                history.setVisibility(View.GONE);
            }
            else
            {
                // history.setVisibility(View.VISIBLE);
              //  Toast.makeText(mycontext,"No list found", Toast.LENGTH_LONG).show();
                snackBar.dismiss();
                snackBar = Snackbar.make(findViewById(android.R.id.content), "No list found", Snackbar.LENGTH_INDEFINITE);
                toast();
            }
            adapter.notifyDataSetChanged();
        }
        @Override
        protected void onCancelled() {
            getworkreport = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }

}
