package com.b2lmobitech.fieldcloudplus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.gesture.GestureOverlayView;
import android.graphics.Bitmap;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.util.Base64;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class signatureActivity extends AppCompatActivity {
    private String companyname="",emailid="",category="",subcategory="",question="",todaydate="",customername="",atmid="",questionumber="";
    private GestureOverlayView gestureView;
    private Context mycontext;
    private sqldatabase mDbHelper;
    private  ImageView imagepng;
    public static Context signaturecontext;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_signature);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        //getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        mycontext = this;
        signaturecontext = this;
        mDbHelper = new sqldatabase(mycontext);
//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
        companyname = getIntent().getExtras().getString("companyname");
        customername = getIntent().getExtras().getString("customername");
        atmid = getIntent().getExtras().getString("atmid");
        emailid = getIntent().getExtras().getString("emailid");
        category = getIntent().getExtras().getString("category");
        subcategory = getIntent().getExtras().getString("subcategory");
        questionumber = getIntent().getExtras().getString("questionumber");
        question = getIntent().getExtras().getString("question");
        SimpleDateFormat dateFormatter = new SimpleDateFormat
                ("yyyy-MM-dd HH:mm:ss");
        todaydate = dateFormatter.format(new Date());
        TextView questiontxt = (TextView)findViewById(R.id.questionform);
        Button clearbutton = (Button)findViewById(R.id.clear);
        gestureView = (GestureOverlayView)findViewById(R.id.signaturePad);
        imagepng = (ImageView)findViewById(R.id.imagepng);
        questiontxt.setText(question);
        clearbutton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gestureView.cancelClearAnimation();
                gestureView.clear(true);
                mDbHelper.delete_answerstable(companyname,customername,atmid,emailid,category,subcategory,questionumber,question);
                imagepng.setVisibility(v.GONE);
            }
        });
//        Cursor answertablecursor = mDbHelper.get_answerstable(companyname,emailid,category,subcategory,question);
//        //Toast.makeText(mycontext,"bitmapinstring="+bitmapinstring,Toast.LENGTH_LONG).show();
//        if(answertablecursor.moveToFirst())
//        {
//            imagepng.setVisibility(View.VISIBLE);
//            imagepng.setImageBitmap(globalvariables.StringToBitMap(answertablecursor.getString(answertablecursor.getColumnIndex(answerstable.IMAGE))));
//        }
//        else
//        {
//            imagepng.setVisibility(View.GONE);
//        }
//        answertablecursor.close();
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.signature, menu);
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        // int id = item.getItemId();

        //noinspection SimplifiableIfStatement
//        if (id == an) {
//
//        }
        switch (item.getItemId()) {
            //  case android.R.id.home:
//                if(gestureView.getGesture()==null)
//                {
//                    Toast.makeText(mycontext, "Please give signature.", Toast.LENGTH_LONG).show();
//                }
//                else {
//                    onBackPressed();
////                }
//                break;
            case R.id.signature_done:
                try {

//                    File f =new File("/sdcard/Android/data/com.B2lmobitech.FieldCloud/"+"/signature.png");
//                    if(f.exists()) {
//                        // do something here
//                        f.delete();
//                        f =new File("/sdcard/Android/data/com.B2lmobitech.FieldCloud/"+"/signature.png");
//                        f.createNewFile();
//                        FileOutputStream out = new FileOutputStream(f);
//                        bm.compress(Bitmap.CompressFormat.PNG, 100, out);
//                        out.flush();
//                        out.close();
//                    }
//                             File f = new File(Environment.getExternalStorageDirectory()//to create file
//                                     + File.separator + "signature.png");
                    //  f.createNewFile();
//                            FileOutputStream os = new FileOutputStream(f);
//                             os = new FileOutputStream(f);
//                             //compress to specified format (PNG), quality - which is ignored for PNG, and out stream
//                             bm.compress(Bitmap.CompressFormat.PNG, 100, os);
//                             os.close();
                    //---
                    if(gestureView.getGesture()==null)
                    {
                        Toast.makeText(mycontext, "Please give signature before submit.", Toast.LENGTH_LONG).show();
                    }
                    else
                    {
                        gestureView.setDrawingCacheEnabled(true);
                        Bitmap bm = Bitmap.createBitmap(gestureView.getDrawingCache());
                        ByteArrayOutputStream baos=new  ByteArrayOutputStream();
                        bm.compress(Bitmap.CompressFormat.PNG, 100, baos);//JPEG
                        byte [] b=baos.toByteArray();
                        String bitmapinstring = Base64.encodeToString(b, Base64.DEFAULT);
                        baos.close();
                        SimpleDateFormat dateFormatter2 = new SimpleDateFormat
                                ("yyyyMMdd_HHmmss");
                        Cursor answertablecursor = mDbHelper.get_answerstable(companyname, emailid, category, subcategory, question);
                        //Toast.makeText(mycontext,"bitmapinstring="+bitmapinstring,Toast.LENGTH_LONG).show();
                        //"SIG_" + dateFormatter2.format(new Date()) + ".png"
                        if (answertablecursor.getCount() != 0) {
                            mDbHelper.update_answerstable_summaryimage(category, subcategory, questionumber,question, "signature", "no data available", bm, "SIG_" + dateFormatter2.format(new Date()) + ".jpg", todaydate,"no");
                        } else {

                            mDbHelper.insert_answerstable(companyname, customername,atmid,emailid, category, subcategory, questionumber,question, "signature", "no data available", bm, "SIG_" + dateFormatter2.format(new Date()) + ".jpg", todaydate,"no");
                        }
                        answertablecursor.close();
                        Toast.makeText(mycontext, "Done", Toast.LENGTH_LONG).show();
                        // finish();
                        //  onBackPressed();
                        Intent intent = new Intent();
                        //intent.putExtra("done", "done");
                        setResult(Activity.RESULT_OK, intent);
                        finish();

                    }
                } catch (Exception e) {
                    //  Log.v("Gestures", e.getMessage());
                    Toast.makeText(mycontext,"Please try again!!"+e.getMessage(),Toast.LENGTH_LONG).show();
                    e.printStackTrace();
                }
                break;
            default:
                break;
        }
        return  true;
        //return super.onOptionsItemSelected(item);
    }
    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }

    @Override
    public void onBackPressed() {
//        Intent intent = new Intent();
//        //intent.putExtra("done", "done");
//        setResult(Activity.RESULT_OK, intent);
//        finish();
        // super.onBackPressed();
        Toast.makeText(mycontext,"Please submit the signature",Toast.LENGTH_LONG).show();
    }
}
