package com.b2lmobitech.fieldcloudplus.task;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Environment;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.service.GPSTracker;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;


public class Utility {

    public static final int MEDIA_TYPE_IMAGE = 1;
    public static GoogleApiClient mGoogleApiClient;
    public static Location mLastLocation;
    public static LocationRequest mLocationRequest;


    public static File getCapturedImageFile() {
        File mediaFile = null;
        File mediaStorageDir = new File(Environment.getExternalStorageDirectory()+"/Rover");
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdirs()) {
                return null;
            }
        }

        mediaFile = new File(mediaStorageDir.getPath() + File.separator

                + "IMG_" + System.currentTimeMillis() + ".jpg");
        try {
            mediaFile.createNewFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return mediaFile;
    }

    public static Bitmap bitmap(String str){
        byte[] decodedBytes = Base64.decode(str, 0);
        return BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
    }

    public static Bitmap processImage(Bitmap bitmap){

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        float  x= (float) bitmap.getHeight()/ (float) bitmap.getWidth();

        float s43= (float) 4/3;
        if(x==s43) {
            bitmap = Bitmap.createScaledBitmap(bitmap, 360, 480, true);
        }else {
            bitmap = Bitmap.createScaledBitmap(bitmap, 360, 640, true);
        }
        bitmap.compress(CompressFormat.JPEG, 100, stream);

        byte[] byteArray = stream.toByteArray();


        if(byteArray.length>160000) { //200KB

            bitmap.compress(CompressFormat.JPEG, 90, stream);
        }

        Log.e("IamgeSize",byteArray.length+" b");
        return bitmap;

    }
    // convert from bitmap to byte array
    public static byte[] getBytes(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(CompressFormat.JPEG, 100, stream);
        return stream.toByteArray();
    }

    // convert from byte array to String
    public static String getString(byte[] image) {
        String imgstring = Base64.encodeToString(image, Base64.DEFAULT);
        return imgstring;
    }

    public static String bitmap2string(Bitmap bm) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bm.compress(CompressFormat.JPEG, 100, stream);
        byte[] byteArray = stream.toByteArray();
        return Base64.encodeToString(byteArray, Base64.DEFAULT);
    }


    public static String getCurrentTime() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date().getTime());
    }

    public static String getCurrentDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime());
    }

    public static String getCurrentDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date().getTime());
    }

    public static String getDateTime(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
    }

    public static Date getDateTime(String str) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd").parse(str);
    }
    public static Date getDateOnly(Date date) throws ParseException {
        String dd=new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
        return new SimpleDateFormat("yyyy-MM-dd").parse(dd);
    }


    public static Date currentDate() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime()));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return new Date();
    }

    public static long days(Date firstdate) {

        long diif = firstdate.getTime() - currentDate().getTime();
        return diif / (1000 * 60 * 60 * 24);

    }

    public static int daysbetween(Date firstdate) {

        long diif = firstdate.getTime() - currentDate().getTime();
        return (int) (diif / (1000 * 60 * 60 * 24));

    }

    public static int daysbetween(Date firstdate, Date seconddate) {

        long diif = firstdate.getTime() - seconddate.getTime();
        return (int) (diif / (1000 * 60 * 60 * 24));

    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        return networkInfo != null && networkInfo.isConnected();
    }


    public static LatLang getBestLcoation(Context context) {

        LatLang latLang = new LatLang();
        Location gpsLocation = null;
        Location networkLocation = null;
        Location passivelocation = null;


        if (ActivityCompat.checkSelfPermission(context, android.Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(context, android.Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            LocationManager locationManager;
            String context2 = Context.LOCATION_SERVICE;
            locationManager = (LocationManager) context.getSystemService(context2);
            String gpsProvider = LocationManager.GPS_PROVIDER;
            String networkProvider = LocationManager.NETWORK_PROVIDER;
            String passiveProvider = LocationManager.PASSIVE_PROVIDER;

            if (locationManager.isProviderEnabled(gpsProvider)) {
                // Log.e("Location","gpsProvider");
                gpsLocation = locationManager.getLastKnownLocation(gpsProvider);
            }
            if (locationManager.isProviderEnabled(networkProvider)) {
                //  Log.e("Location","networkProvider");
                networkLocation = locationManager.getLastKnownLocation(networkProvider);
            }
            if (locationManager.isProviderEnabled(passiveProvider)) {
                // Log.e("Location","passiveProvider");
                passivelocation = locationManager.getLastKnownLocation(passiveProvider);
            }


        } else {
            Toast.makeText(context, "No Location Permisiion", Toast.LENGTH_SHORT).show();
        }

        if (gpsLocation != null) {
            // Log.e("Location","gpsLocation");
            double latdouble = gpsLocation.getLatitude();
            double londouble = gpsLocation.getLongitude();

            latLang.setLatitude(String.valueOf(latdouble));
            latLang.setLongitude(String.valueOf(londouble));

            Log.e("gps", String.valueOf(latdouble) + "," + String.valueOf(londouble));
        }

        if (networkLocation != null) {
            // Log.e("Location","networkLocation");
            double latdouble = networkLocation.getLatitude();
            double londouble = networkLocation.getLongitude();

            latLang.setLatitude(String.valueOf(latdouble));
            latLang.setLongitude(String.valueOf(londouble));
            Log.e("metwork", String.valueOf(latdouble) + "," + String.valueOf(londouble));

        }
        if (passivelocation != null) {
            // Log.e("Location","passivelocation");
            double latdouble = passivelocation.getLatitude();
            double londouble = passivelocation.getLongitude();

            latLang.setLatitude(String.valueOf(latdouble));
            latLang.setLongitude(String.valueOf(londouble));
            Log.e("passive", String.valueOf(latdouble) + "," + String.valueOf(londouble));
        }
        // Log.e("Location",latLang.getLatitude()+" "+latLang.getLongitude());

        return latLang;
    }

    public static LatLang getLocation(Context context) {
        LatLang latLang = new LatLang();
        /*LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
        Criteria criteria = new Criteria();
        String provider = locationManager.getBestProvider(criteria, false);
        @SuppressLint("MissingPermission") Location location = locationManager.getLastKnownLocation(provider);

        if (location!=null){
            double latdouble = location.getLatitude();
            double londouble = location.getLongitude();

            latLang.setLatitude(String.valueOf(latdouble));
            latLang.setLongitude(String.valueOf(londouble));
        }*/
        GPSTracker gpsTracker=new GPSTracker(context);

        latLang.setLatitude(String.valueOf(gpsTracker.getLatitude()));
        latLang.setLongitude(String.valueOf(gpsTracker.getLongitude()));

        Log.e("location",latLang.getLatitude()+","+latLang.getLongitude());
        gpsTracker.stopUsingGPS();
        return latLang;
    }

    public static LatLang getLcoation(Context context){
        final LatLang latLang = new LatLang();
        mGoogleApiClient = new GoogleApiClient.Builder(context)
                .addConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks() {
                    @Override
                    public void onConnected(@Nullable Bundle bundle) {

                    }

                    @Override
                    public void onConnectionSuspended(int i) {

                    }
                })
                .addOnConnectionFailedListener(new GoogleApiClient.OnConnectionFailedListener() {
                    @Override
                    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {

                    }
                })
                .addApi(LocationServices.API)
                .build();

            mGoogleApiClient.connect();

        if (ActivityCompat.checkSelfPermission(context, android.Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(context, android.Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return latLang;
        } else {

            LocationServices.getFusedLocationProviderClient(context).getLastLocation().addOnSuccessListener((Activity) context,new OnSuccessListener<Location>() {
                @Override
                public void onSuccess(Location location) {
                    if (location != null) {
                        location=mLastLocation;
                    }
                }
            });
            if (mLastLocation != null) {
              latLang.setLatitude(mLastLocation.getLatitude()+"");
              latLang.setLatitude(mLastLocation.getLatitude()+"");
            }
        }
        return latLang;

    }

  /*  public void settingRequest() {
        mLocationRequest = new LocationRequest();
        mLocationRequest.setInterval(10000);    // 10 seconds, in milliseconds
        mLocationRequest.setFastestInterval(1000);   // 1 second, in milliseconds
        mLocationRequest.setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);

        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder()
                .addLocationRequest(mLocationRequest);

        PendingResult<LocationSettingsResult> result =
                LocationServices.SettingsApi.checkLocationSettings(mGoogleApiClient,
                        builder.build());

        result.setResultCallback(new ResultCallback<LocationSettingsResult>() {

            @Override
            public void onResult(@NonNull LocationSettingsResult result) {
                final Status status = result.getStatus();
                final LocationSettingsStates state = result.getLocationSettingsStates();
                switch (status.getStatusCode()) {
                    case LocationSettingsStatusCodes.SUCCESS:
                        // All location settings are satisfied. The client can
                        // initialize location requests here.
                        getLocation();
                        break;
                    case LocationSettingsStatusCodes.RESOLUTION_REQUIRED:
                        // Location settings are not satisfied, but this can be fixed
                        // by showing the user a dialog.
                        try {
                            // Show the dialog by calling startResolutionForResult(),
                            // and check the result in onActivityResult().
                            status.startResolutionForResult(MainActivity.this, 1000);
                        } catch (IntentSender.SendIntentException e) {
                            // Ignore the error.
                        }
                        break;
                    case LocationSettingsStatusCodes.SETTINGS_CHANGE_UNAVAILABLE:
                        // Location settings are not satisfied. However, we have no way
                        // to fix the settings so we won't show the dialog.
                        break;
                }
            }

        });
    }*/



}
