package com.b2lmobitech.fieldcloudplus.task.activities;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.adapters.ActivitiesAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ActivitiesActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    String id;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_activities);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        id=getIntent().getStringExtra("id");
        getSupportActionBar().setTitle("Activities");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    @Override
    protected void onResume() {
        super.onResume();
        getActivities();
    }

    private void getActivities(){
        Map<String, String> params = new HashMap<>();
        Preference preference=Preference.getInstance(this);
        params.put("cname",preference.getCompanyName());
        params.put("id",id);
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_ACTIVITIES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getActivities(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getActivities(JSONObject jsonObject) throws JSONException{
        JSONArray jsonArray=jsonObject.getJSONArray("activities");
        ActivitiesAdapter activitiesAdapter=new ActivitiesAdapter(this,jsonArray);
        recyclerView.setAdapter(activitiesAdapter);
    }

    @Override
    public void itemClicked(int position) {

    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
