package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Parcelable;
import android.provider.Settings;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import com.google.android.material.tabs.TabLayout;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskListActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.AllTasksAdapter;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.listener.AcceptTaskListener;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class AllTasksActivity extends AppCompatActivity implements AcceptTaskListener {

    String tasklistd;
    RecyclerView recyclerView;
    TabLayout tabLayout;
    Database database;
    JSONArray jsonArray=new JSONArray();
    Snackbar snackbar;
    CoordinatorLayout coordinatorLayout;
    String projectId;
    MenuItem editTasklist,deleteTasklist;

    final String TODAY="Today",ACTIVE="Active",LATE="Late",NEW="NEW",UPCOMING="Upcoming",COMPLETED="Completed",UNASSIGNED="Unassigned";
    AllTasksAdapter allTasksAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_all_tasks);

        tasklistd=getIntent().getStringExtra("id");
        projectId=getIntent().getStringExtra("projectId");


        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        tabLayout=findViewById(R.id.tablayout);
        coordinatorLayout=findViewById(R.id.coordinatorLayout);
        tabLayout.addTab(tabLayout.newTab().setText(TODAY),true);
        tabLayout.addTab(tabLayout.newTab().setText(ACTIVE));
        tabLayout.addTab(tabLayout.newTab().setText(LATE));
        tabLayout.addTab(tabLayout.newTab().setText(NEW));
        tabLayout.addTab(tabLayout.newTab().setText(UPCOMING));
        tabLayout.addTab(tabLayout.newTab().setText(COMPLETED));
        setListeners();
        getSupportActionBar().setTitle("Tasks");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }

    @Override
    protected void onResume() {
        super.onResume();
        database=Database.getInstance(this);
        if(tasklistd==null || projectId==null){
            Preference preference=Preference.getInstance(this);
            tasklistd=preference.getTaskListId();
            projectId=preference.getProjectId();
        }
        if(MyRequestQueue.getInstance(this).isNoInternet()){
            setAdapter(tabLayout.getTabAt(tabLayout.getSelectedTabPosition()).getText().toString());
        }else{
            getTasks();
        }
    }

    private void setListeners(){



        tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {

            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                setAdapter(tab.getText().toString());
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {
            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
        tabLayout.getTabAt(0).select();

    }

    private void setAdapter(JSONArray Array,String string){
        if(snackbar!=null){
            snackbar.dismiss();
        }
        if(Array.length()==0){
            snackbar= Snackbar.make(coordinatorLayout, "No Tasks Found", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
        }

        Parcelable recyclerViewState = recyclerView.getLayoutManager().onSaveInstanceState();
        allTasksAdapter=new AllTasksAdapter(this,Array,string,Preference.getInstance(this).isResponsible(projectId));
        recyclerView.setAdapter(allTasksAdapter);
        try {
            recyclerView.getLayoutManager().onRestoreInstanceState(recyclerViewState);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void setAdapter(String string){
        Preference preference=Preference.getInstance(this);
        String email="";
        if(!preference.isResponsible(projectId)){
            email=preference.getEmailId();
        }
        switch (string){
            case ACTIVE:
                setAdapter(database.getPendingTasks(tasklistd,email),ACTIVE);
                break;
            case TODAY:
                setAdapter(database.getTodayTasks(tasklistd,email),TODAY);
                break;
            case COMPLETED:
                setAdapter(database.getCompletedTasks(tasklistd,email),COMPLETED);
                break;
            case LATE:
                setAdapter(database.getLateTasks(tasklistd,email),LATE);
                break;
            case NEW:
                setAdapter(database.getNewTasks(tasklistd,email),NEW);
                break;
            case UPCOMING:
                setAdapter(database.getUpcomingTasks(tasklistd,email),UPCOMING);
                break;
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
            case R.id.editTasklist:
                if(MyRequestQueue.getInstance(this).isNoNetwork()){
                    break;
                }
                Intent intent = new Intent(this, AddTaskListActivity.class);
                intent.putExtra("id",projectId);
                intent.putExtra("tasklistId",tasklistd);
                startActivity(intent);
                break;
            case R.id.delete:
                showAlert();
                break;
        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_alltask, menu);
        editTasklist=menu.findItem(R.id.editTasklist);
        deleteTasklist=menu.findItem(R.id.delete);
        if(Preference.getInstance(this).isResponsible(projectId)) {
            editTasklist.setVisible(true);
            deleteTasklist.setVisible(true);
        }else{
            editTasklist.setVisible(false);
            deleteTasklist.setVisible(false);
        }
        return true;
    }

    @Override
    public void acceptTask(String assignId){
        if(MyRequestQueue.getInstance(this).isNoNetwork()){
            return;
        }
        final LocationManager locationManager = (LocationManager)getSystemService(Context.LOCATION_SERVICE);

        boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
        if (!isGPSEnabled && !isNetworkEnabled) {
            //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(this);

            alertdialog.setTitle("Access Location");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("No network provider is enabled for location access!!");
            alertdialog.setPositiveButton("Turn On",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                        }
                    });
            alertdialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // TODO Auto-generated method stub

                }
            }).create();
            alertdialog.show();
            return;
        }

        final LatLang latLang=Utility.getLocation(getApplicationContext());

        Map<String, String>  params = new HashMap<String, String>();

        params.put("assign_id", assignId);
        params.put("datetime", DateUtils.getCurrentDateTime());
        params.put("latitude", latLang.getLatitude());
        params.put("longtitude",latLang.getLongitude());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ACCEPT_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json=new JSONObject(response);

                    int success = json.getInt("s");
                    if (success == 1) {
                        getTasks();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void getTasks(){
        Preference preference=Preference.getInstance(this);
        Database database= Database.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("mail",preference.getEmailId());
        params.put("id",tasklistd);
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());

        if(preference.getEmailId().equalsIgnoreCase(database.getProjectResponsible(projectId))){
            params.put("responsible", "yes");
        }else{
            params.put("responsible", "no");
        }

        params.put("list", database.getTasksList(tasklistd,false).toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_TASKS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getTasks(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void getTasks(JSONObject jsonObject) throws JSONException {

        JSONArray employeeArray=jsonObject.getJSONArray("employees");
        JSONArray taskArray=jsonObject.getJSONArray("tasks");
        JSONArray assignArray=jsonObject.getJSONArray("assigns");

        Database database=Database.getInstance(this);
        try {
            database.insertEmplyoees(employeeArray);
            database.insertTasks(taskArray);
            database.insertAssigns(assignArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        setAdapter(tabLayout.getTabAt(tabLayout.getSelectedTabPosition()).getText().toString());
    }

    private void deleteTasklist(){

        JSONObject jsonObject=new JSONObject();
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        try {
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }
            jsonObject.put("tasklist",tasklistd);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.DELETE_TASKLIST, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Database.getInstance(getApplicationContext()).deleteTasklist(tasklistd);
                        Toast.makeText(getApplicationContext(),"Tasklist Deleted",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Deleted Tasklist ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void showAlert(){
        new android.app.AlertDialog.Builder(this).setMessage("Tasklist Will be deleted")
                .setPositiveButton("CONTINUE", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // FIRE ZE MISSILES!
                        deleteTasklist();
                    }
                })
                .setNegativeButton("CLOSE", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {

                    }
                }).show();
    }

}
