package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddProjectActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectCategoryActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectCompanyActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectTagActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.ProjectAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.service.ReminderReceiver;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class Dashboard extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    Snackbar snackbar;
    CoordinatorLayout coordinatorLayout;
    JSONArray jsonArray=new JSONArray();
    JSONObject jsonObject;
    boolean menuCreated=false;
    MenuItem newProject,tags,clients,cats;
    JSONArray projectArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_task_dashboard);
        getSupportActionBar().setTitle("Projects");
        recyclerView=findViewById(R.id.project_recycle);
        recyclerView.setLayoutManager( new LinearLayoutManager(this));
        coordinatorLayout=findViewById(R.id.coordinator);
        setDailyReminder();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if(MyRequestQueue.getInstance(this).isNoInternet())
        {
            getProjectsOffline();
        }else{
            if(Database.getInstance(this).getProjects().length()==0){
                fetchAll();
            }else{
                getProjects();
            }
        }
    }

    private void getProjects(){
        Preference preference=Preference.getInstance(this);
        Map<String, String>  params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", new JSONArray().toString());
        //params.put("list", Database.getInstance(this).getProjectsList().toString());
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_PROJECTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getProjects(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fetchAll(){
        Preference preference=Preference.getInstance(this);
        Map<String, String>  params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.FETCH_ALL, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    fetchAll(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fetchAll(JSONObject jsonObject) throws JSONException {
        JSONArray projectArray=jsonObject.getJSONArray("projects");
        JSONArray milestoneArray=jsonObject.getJSONArray("milestones");
        JSONArray tasklistArray=jsonObject.getJSONArray("tasklists");
        JSONArray clientArray=jsonObject.getJSONArray("clients");
        JSONArray categoriesArray=jsonObject.getJSONArray("categories");
        JSONArray tagsArray=jsonObject.getJSONArray("tags");
        JSONArray employeeArray=jsonObject.getJSONArray("employees");
        JSONArray taskArray=jsonObject.getJSONArray("tasks");
        JSONArray assignArray=jsonObject.getJSONArray("assigns");

        Database database=Database.getInstance(this);
        try {
            database.insertProjects(projectArray);
            database.insertMilestones(milestoneArray);
            database.insertTaskLists(tasklistArray);
            database.insertAssigns(assignArray);
            database.insertTasks(taskArray);

            database.insertClients(clientArray);
            database.insertCategories(categoriesArray);
            database.insertTags(tagsArray);
            database.insertEmplyoees(employeeArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        getProjectsOffline();
    }

    private void getProjects(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray=jsonObject.getJSONArray("projects");
        Database database=Database.getInstance(this);
        database.deleteAllProjects();
        try {
            database.insertProjects(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        getProjectsOffline();
    }

    private void getProjectsOffline(){
        Preference preference=Preference.getInstance(this);

        Parcelable recyclerViewState = recyclerView.getLayoutManager().onSaveInstanceState();
        projectArray = Database.getInstance(this).getProjects();
        ProjectAdapter projectAdapter=new ProjectAdapter(this,projectArray);
        recyclerView.setAdapter(projectAdapter);
        recyclerView.getLayoutManager().onRestoreInstanceState(recyclerViewState);

        if(projectArray.length()==0) {
            findViewById(R.id.listEmptyText).setVisibility(View.VISIBLE);
            if (preference.isAdmin() || Database.getInstance(this).isResponsibleForAnyProject(preference.getEmailId())) {
                findViewById(R.id.addNewText).setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent intent = new Intent(getApplicationContext(), AddProjectActivity.class);
                        startActivity(intent);
                    }
                });
                findViewById(R.id.addNewText).setVisibility(View.VISIBLE);
            }else{
                findViewById(R.id.addNewText).setVisibility(View.GONE);
            }
        }else{
            findViewById(R.id.addNewText).setVisibility(View.GONE);
            findViewById(R.id.listEmptyText).setVisibility(View.GONE);
        }
        checkforMenuCreated();
    }

    private void setDailyReminder(){
        try {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(this);
            if (!prefs.getBoolean("firstTime", false)) {

            Intent alarmIntent = new Intent(this, ReminderReceiver.class);
            alarmIntent.putExtra("user", Preference.getInstance(this).getEmailId());
            PendingIntent pendingIntent = PendingIntent.getBroadcast(this, 0, alarmIntent, 0);

            AlarmManager manager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);

            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(Calendar.HOUR_OF_DAY, 6);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 1);

            manager.setRepeating(AlarmManager.RTC_WAKEUP, calendar.getTimeInMillis(),
                    AlarmManager.INTERVAL_DAY, pendingIntent);
                SharedPreferences.Editor editor = prefs.edit();
                editor.putBoolean("firstTime", true);
                editor.apply();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_task_dashboard, menu);
        newProject=menu.findItem(R.id.newProject);
        tags=menu.findItem(R.id.tags);
        cats=menu.findItem(R.id.category);
        clients=menu.findItem(R.id.client);
        newProject.setVisible(false);
        tags.setVisible(false);
        clients.setVisible(false);
        cats.setVisible(false);
        menuCreated=true;
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        final MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        switch (item.getItemId()){
            case R.id.newProject:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                Intent intent = new Intent(this, AddProjectActivity.class);
                startActivity(intent);
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
            case R.id.tags:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, SelectTagActivity.class);
                intent.putExtra("info",true);
                startActivity(intent);
                break;
            case R.id.category:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, SelectCategoryActivity.class);
                intent.putExtra("info",true);
                startActivity(intent);
                break;
            case R.id.client:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, SelectCompanyActivity.class);
                intent.putExtra("info",true);
                startActivity(intent);
                break;
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkforMenuCreated(){
        final Handler handler = new Handler();
        final Runnable runnable = new Runnable() {
            public void run() {
                if(menuCreated){ // just remove call backs
                    handler.removeCallbacks(this);
                    try {
                        manageActionBarIcons();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else { // post again
                    handler.postDelayed(this, 100);
                }
            }
        };
        handler.removeCallbacks(runnable);
        handler.postDelayed(runnable, 100);
    }

    private void manageActionBarIcons(){
        Preference preference=Preference.getInstance(this);
        if(preference.isAdmin() || Database.getInstance(this).isResponsibleForAnyProject(preference.getEmailId())){
            newProject.setVisible(true);
            tags.setVisible(true);
            clients.setVisible(true);
            cats.setVisible(true);
        }
    }

    @Override
    public void itemClicked(int position) {
        try {
            Intent intent=new Intent(getApplicationContext(), ProjectActivity.class);
            JSONObject jsonObject=projectArray.getJSONObject(position);
            intent.putExtra("id",jsonObject.getString(ProjectTable.PROJECTID));
            intent.putExtra("name",jsonObject.getString(ProjectTable.PROJECTNAME));
            startActivity(intent);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

}
