package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.text.InputType;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.listener.LocationUpdateListener;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.others.LocationUpdate;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

import static com.b2lmobitech.fieldcloudplus.task.others.LocationUpdate.REQUEST_CHECK_SETTINGS;

/**
 * Created by home on 11/2/2017.
 */

public class ExtendForm extends AppCompatActivity {

    TextView projectName,taskName,milestoneName,requestType;
    EditText requesetReason,newDate;
    LinearLayout newDatelayout;
    int daysbetween;
    Calendar cal;

    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    String assignId,taskId,end;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_request_form);

        getSupportActionBar().setTitle("Extension Form");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        assignId=getIntent().getStringExtra("assignId");
        taskId=getIntent().getStringExtra("taskId");
        end=getIntent().getStringExtra("end");

        getWidgets();
        //setValues();
        setListeners();


    }

    private void getWidgets(){

        projectName=findViewById(R.id.project_name);
        taskName=findViewById(R.id.task_name);
        milestoneName=findViewById(R.id.milestone_name);
        requestType=findViewById(R.id.request_type);
        requesetReason=findViewById(R.id.request_reason);
        newDate=findViewById(R.id.new_date);
        newDatelayout=findViewById(R.id.new_date_layout);
        newDatelayout.setVisibility(View.VISIBLE);
        newDate.setInputType(InputType.TYPE_NULL);
        coordinatorLayout=findViewById(R.id.coordinator);
        newDate.performClick();

    }

    private void setValues(){

      /*  TaskEncap taskEncap=arrayList.get(0);
        projectName.setText(taskEncap.getProjectname());
        taskName.setText(taskEncap.getTaskname());
        milestoneName.setText(taskEncap.getMilestonename());*/
        requestType.setText("Date");
    }

    private void setListeners(){
        final DatePickerDialog.OnDateSetListener dpd = new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {

                cal = new GregorianCalendar(year, monthOfYear, dayOfMonth);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                newDate.setText(df.format(cal.getTime()));
                try {
                    daysbetween=Utility.daysbetween(new Date(cal.getTimeInMillis()),DateUtils.fromDate(end));
                } catch (ParseException e) {
                    e.printStackTrace();
                }

            }
        };
        Calendar myCalendar = Calendar.getInstance();
        final DatePickerDialog dialog=  new DatePickerDialog(this, dpd, myCalendar
                .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                myCalendar.get(Calendar.DAY_OF_MONTH));
        try {
            myCalendar.setTime(DateUtils.fromDate(end));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        myCalendar.add(Calendar.DAY_OF_MONTH,1);
        dialog.getDatePicker().setMinDate(myCalendar.getTimeInMillis());
        myCalendar.add(Calendar.DAY_OF_MONTH,98);
        dialog.getDatePicker().setMaxDate(myCalendar.getTimeInMillis());
        newDate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.show();
            }
        });

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case R.id.done:
                if(MyRequestQueue.getInstance(this).isNoNetwork()){
                    break;
                }
                if(isValid()){
                    requestLocationUpdate();
                }
              break;
            case android.R.id.home:
                onBackPressed();
                return true;

        }
        return super.onOptionsItemSelected(item);
    }

    private void requestLocationUpdate(){

        LocationUpdate locationUpdate=LocationUpdate.getInstance(this);
        locationUpdate.connectLocation(new LocationUpdateListener() {
            @Override
            public void onLocationReceived(String latitude, String longtitude) {
                try {
                    request(latitude,longtitude);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        switch(requestCode){
            case  REQUEST_CHECK_SETTINGS:
                switch (resultCode) {
                    case Activity.RESULT_OK:
                        requestLocationUpdate();
                        break;
                    case Activity.RESULT_CANCELED:
                        RequestProgress.getInstance(this).hideProgressBar();
                        // The user was asked to change settings, but chose not to
                        break;
                    default:
                        break;
                }
                break;
        }


    }

    private void request(String latitude, String longtitude) throws JSONException {

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        Preference preference=Preference.getInstance(this);


        Map<String, String> params = new HashMap<String, String>();
        params.put("assignId",assignId);
        params.put("taskId",taskId);
        params.put("employeeId",preference.getEmailId());
        params.put("increasedays",daysbetween+"");
        params.put("latitude",latitude);
        params.put("longitude",longtitude);
        params.put("reason",requesetReason.getText().toString());
        params.put("datetime",Utility.getCurrentDateTime());

        myRequestQueue.addToQueue(TASKURL.REQUEST_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);

                    int success = json.getInt("s");
                    if (success == 1) {
                        //sqldatabase.insertTaskProgress(taskid,registeredemailid,progressDate,progress+"",finalActivities,datetime,"no",location.getLatitude()+"",location.getLongitude()+"");
                        finish();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private boolean isValid(){
        if(newDate.getText().toString().isEmpty()){
            snackbar= Snackbar.make(coordinatorLayout, "Select date", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return false;
        }

        if(requesetReason.getText().toString().isEmpty()){
            snackbar= Snackbar.make(coordinatorLayout, "Provide reason", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return false;
        }
        return true;
    }

}
