package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Intent;
import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddMilestoneActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.MilestoneAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class MilestoneActivity extends AppCompatActivity {

    String projectid;
    RecyclerView recyclerView;
    MenuItem newMilestone;
    boolean menuCreated=false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_milestone);
        projectid=getIntent().getStringExtra("id");
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Milestones");
        findViewById(R.id.addNewText).setVisibility(View.GONE);
        getMilestones();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if(MyRequestQueue.getInstance(this).isNoInternet()){
            getMilestonesOffline();
        }else{
            getMilestones();
        }
        findViewById(R.id.addNewText).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getApplicationContext(), AddMilestoneActivity.class);
                intent.putExtra("id",projectid);
                startActivity(intent);
            }
        });
    }

    private void getMilestones(){
        Preference preference=Preference.getInstance(this);
        Database database= Database.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("mail",preference.getEmailId());
        params.put("id",projectid);

        if(preference.getEmailId().equalsIgnoreCase(database.getProjectResponsible(projectid))){
            params.put("responsible", "yes");
        }else{
            params.put("responsible", "no");
        }
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        //params.put("list", database.getMilestonesList(projectid).toString());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_MILESTONES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getMilestones(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMilestones(JSONObject jsonObject) throws JSONException {
        Database database=Database.getInstance(this);
        JSONArray jsonArray=jsonObject.getJSONArray("list");
        database.deleteMilestones(projectid);
        try {
            database.insertMilestones(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        getMilestonesOffline();
    }

    private void getMilestonesOffline(){
        checkforMenuCreated();
        JSONArray jsonArray=Database.getInstance(this).getMilestones(projectid);
        if(jsonArray.length()==0) {
            findViewById(R.id.listEmptyText).setVisibility(View.VISIBLE);
        }else{
            findViewById(R.id.listEmptyText).setVisibility(View.GONE);
        }
        MilestoneAdapter milestoneAdapter = new MilestoneAdapter(this, jsonArray);
        recyclerView.setAdapter(milestoneAdapter);

        Preference preference=Preference.getInstance(this);
        if(jsonArray.length()==0) {
            if (preference.isAdmin() || Database.getInstance(this).getProjectResponsible(projectid).equalsIgnoreCase(preference.getEmailId())) {
                newMilestone.setVisible(true);
                findViewById(R.id.addNewText).setVisibility(View.VISIBLE);
            }else{
                newMilestone.setVisible(false);
                findViewById(R.id.addNewText).setVisibility(View.GONE);
            }
        }else{
            findViewById(R.id.listEmptyText).setVisibility(View.GONE);
            //findViewById(R.id.addNewText).setVisibility(View.VISIBLE);
        }
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_milestone, menu);
        newMilestone=menu.findItem(R.id.newMilestone);
        newMilestone.setVisible(false);
        menuCreated=true;
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case R.id.newMilestone:
                Intent intent = new Intent(this, AddMilestoneActivity.class);
                intent.putExtra("id",projectid);
                startActivity(intent);
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkforMenuCreated(){
        final Handler handler = new Handler();
        final Runnable runnable = new Runnable() {
            public void run() {
                if(menuCreated){ // just remove call backs
                    handler.removeCallbacks(this);
                    try {
                        manageActionBarIcons();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else { // post again
                    handler.postDelayed(this, 100);
                }
            }
        };
        handler.removeCallbacks(runnable);
        handler.postDelayed(runnable, 100);
    }

    private void manageActionBarIcons(){
        Preference preference=Preference.getInstance(this);
        if(preference.isAdmin() || Database.getInstance(this).getProjectResponsible(projectid).equalsIgnoreCase(preference.getEmailId())){
            newMilestone.setVisible(true);
            //findViewById(R.id.addNewText).setVisibility(View.VISIBLE);
        }
    }
}
