package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddMilestoneActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class MilestoneInfoActivity extends AppCompatActivity {

    TextView milestoneName,milestoneDescription;
    LinearLayout milestoneDetails;
    String id,projectId;
    MenuItem edit,delete;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_milestone_info);

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Milestone Details");

        milestoneDescription=findViewById(R.id.milestoneDescription);
        milestoneDetails=findViewById(R.id.milestoneDetails);
        milestoneName=findViewById(R.id.milestoneName);
        id=getIntent().getStringExtra("id");
        projectId=getIntent().getStringExtra("projectId");
        try {
            getMilestoneDetais();
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    @Override
    protected void onResume() {
        super.onResume();
        getMilestones();
    }

    private void getMilestoneDetais() throws JSONException {
        Database database= Database.getInstance(this);

        JSONObject jsonObject= database.getMilestoneDetails(id);
        milestoneDetails.removeAllViews();
        milestoneName.setText(jsonObject.getString(MilestoneTable.NAME));
        if(jsonObject.getString(MilestoneTable.DESCRIPTION).isEmpty()){
            milestoneDescription.setText(R.string.noDescription);
        }else{
            milestoneDescription.setText(jsonObject.getString(MilestoneTable.DESCRIPTION));
        }

       // addView("Start",jsonObject.getString(TaskTable.STARTDATE));
        addView("Project",database.getProjectName(jsonObject.getString(MilestoneTable.PROJECTID)));
        addView("Date",jsonObject.getString(MilestoneTable.ENDDATE));
        if(jsonObject.getString(MilestoneTable.RESPONSIBLEPERSON).equalsIgnoreCase(Preference.getInstance(getApplicationContext()).getEmailId())){
            addView("Responsible",getResources().getString(R.string.responsible));
        }else{
            addView("Responsible",database.getEmployeeName(jsonObject.getString(MilestoneTable.RESPONSIBLEPERSON)));
        }
        addView("Created On",jsonObject.getString(MilestoneTable.CREATEDDATETIME));
        addView("Created By",database.getEmployeeName(jsonObject.getString(MilestoneTable.CREATEDBY)));

        if(edit!=null) {
            if (Preference.getInstance(this).isResponsible(projectId)) {
                edit.setVisible(true);
                delete.setVisible(true);
            } else {
                edit.setVisible(false);
                delete.setVisible(false);
            }
        }
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        milestoneDetails.addView(view);
    }

    private void getMilestones(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("id",projectId);
        params.put("mid",id);

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_MILESTONES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getMilestones(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMilestones(JSONObject jsonObject) throws JSONException {
        Database database=Database.getInstance(this);
        JSONArray jsonArray=jsonObject.getJSONArray("list");
        try {
            database.insertMilestones(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        getMilestoneDetais();
        //invalidateOptionsMenu();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.task_milestone, menu);
        edit=menu.findItem(R.id.edit);
        delete=menu.findItem(R.id.delete);
        if(Preference.getInstance(this).isResponsible(projectId)){
            edit.setVisible(true);
            delete.setVisible(true);
        }else {
            edit.setVisible(false);
            delete.setVisible(false);
        }
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
            case R.id.edit:
                if(MyRequestQueue.getInstance(this).isNoNetwork()){
                    break;
                }
                try {
                    Intent intent = new Intent(this, AddMilestoneActivity.class);
                    intent.putExtra("id", projectId);
                    intent.putExtra("milestone", id);
                    startActivity(intent);
                }catch (Exception e){
                    e.printStackTrace();
                }
                break;
            case R.id.delete:
                showAlert();
                break;
        }
        return super.onOptionsItemSelected(item);
    }

    private void deleteMilestone(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        try {
            JSONObject jsonObject=new JSONObject();
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }
            jsonObject.put("milestoneid",id);
            params.put("data",jsonObject.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.DELETE_MILESTONE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Milstone Deleted Successfully",Toast.LENGTH_SHORT).show();
                        Database.getInstance(getApplicationContext()).deleteMilestone(id);
                        finish();
                    }else{

                        Toast.makeText(getApplicationContext(),"Unable to delete milestone",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void showAlert(){
        new AlertDialog.Builder(this).setMessage("Milestone Will be deleted")
                .setPositiveButton("CONTINUE", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // FIRE ZE MISSILES!
                        deleteMilestone();
                    }
                })
                .setNegativeButton("CLOSE", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {

                    }
                }).show();
    }




}
