package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.adapters.PeopleAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class PeopleActivity extends AppCompatActivity implements OnItemClickListener {

    String projectId;
    RecyclerView recyclerView;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_people);
        projectId=getIntent().getStringExtra("id");
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getPeoples();
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("People");
    }

    private void getPeoples(){

        Map<String, String> params = new HashMap<>();
        Preference preference=Preference.getInstance(this);
        params.put("id", projectId);
        params.put("mail",preference.getEmailId());
        if(preference.isAdmin()){
            params.put("role",preference.getDesignation());
        }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
            params.put("role","project");
        }else{
            params.put("role","employee");
        }
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_PEOPLES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getPeoples(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getPeoples(JSONObject jsonObject) throws JSONException{
        Database database=Database.getInstance(this);
        JSONArray employeeArray=jsonObject.getJSONArray("employees");
        try {
            database.insertEmplyoees(employeeArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if(employeeArray.length()==0){
            Toast.makeText(getApplicationContext(),"Task not assigned to anyone",Toast.LENGTH_SHORT).show();
            finish();
        }
        jsonArray=jsonObject.getJSONArray("peoples");
        PeopleAdapter peopleAdapter=new PeopleAdapter(this,jsonArray);
        recyclerView.setAdapter(peopleAdapter);

    }

    @Override
    public void itemClicked(int position) {
        Intent intent=new Intent(getApplicationContext(),TaskManagementActivity.class);
        intent.putExtra("id",projectId);
        try {
            intent.putExtra("employee",jsonArray.getJSONObject(position).getString("employee"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        startActivity(intent);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
