package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.core.content.FileProvider;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;

import android.text.InputType;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import com.android.volley.RequestQueue;
import com.b2lmobitech.fieldcloudplus.BuildConfig;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.adapters.AddedListAdapter;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.listener.ActivityDeletedListener;
import com.b2lmobitech.fieldcloudplus.task.listener.LocationUpdateListener;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.others.LocationUpdate;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress;
import com.b2lmobitech.fieldcloudplus.task.service.UpdateTaskService;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;
//import com.firebase.jobdispatcher.Constraint;
//import com.firebase.jobdispatcher.FirebaseJobDispatcher;
//import com.firebase.jobdispatcher.Job;
//import com.firebase.jobdispatcher.Lifetime;
//import com.firebase.jobdispatcher.Trigger;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static com.b2lmobitech.fieldcloudplus.task.others.LocationUpdate.REQUEST_CHECK_SETTINGS;

/**
 * Created by home on 11/6/2017.
 */

public class ProgressForm extends AppCompatActivity {

    Button add;
    RecyclerView recyclerView;
    ArrayList<String> arrayList = new ArrayList<>();
    EditText editText;
    AddedListAdapter addedListAdapter;
    SeekBar seekBar;
    int progress;
    TextView completed_precentage;
    ArrayList<TaskEncap> tasklsit = new ArrayList<>();
    MenuItem submit;
    ProgressDialog pDialog;
    RequestQueue requestQueue;
    String registeredcompany, registeredemailid, taskid;
    TaskEncap taskEncap;
    Sqlite sqldatabase;
    JSONArray jsonArray;
    JSONObject jsonObject;
    EditText date;
    Calendar cal;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    Uri imageUri;
    File mediaFile = null;
    Bitmap cambmp;
    String camstring = "null";
    FusedLocationProviderClient mFusedLocationClient;
    LocationRequest mLocationRequest;
    private long FASTEST_INTERVAL = 1000; /* 2 sec */
    private ImageView cameraButton, snapshot;
    protected static final int CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE = 0;
    android.location.Location location;
    LatLang latLang = new LatLang();
    LocationCallback locationCallback;
    LocationManager locationManager;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_progressform);
        getSupportActionBar().setTitle("Progress Update");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);


        getWidgets();
        progress = getIntent().getIntExtra("progress", 0);
        taskid = getIntent().getStringExtra("taskid");
        Database database=Database.getInstance(this);
        try {
            jsonObject=database.getTaskDetails(taskid);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        addedListAdapter = new AddedListAdapter(this, arrayList, new ActivityDeletedListener() {
            @Override
            public void activityDeleted(int position) {
                arrayList.remove(position);
                addedListAdapter.notifyDataSetChanged();
            }
        });
        recyclerView.setAdapter(addedListAdapter);
        completed_precentage.setText(String.format(Locale.getDefault(),"%d%%", progress));
        setDatePicker();
        showDialog();


    }

    private void getWidgets(){
        date = findViewById(R.id.progress_date);
        date.setInputType(InputType.TYPE_NULL);
        cameraButton = findViewById(R.id.cameraButton);
        snapshot = findViewById(R.id.snapshot);
        coordinatorLayout = findViewById(R.id.coordinator);
        completed_precentage = findViewById(R.id.completed_precentage);
        recyclerView = findViewById(R.id.recycle_view);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.setHasFixedSize(true);
        editText = findViewById(R.id.activity_text);

        findViewById(R.id.add_activity).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                addToList();
            }
        });

        cameraButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                OpenCamera();
            }
        });
    }

    private void addToList() {

        String str = editText.getText().toString().trim();

        if (str.isEmpty()) {
            snackbar= Snackbar.make(coordinatorLayout, "Can't be empty", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        } else if (arrayList.contains(str)) {
                snackbar= Snackbar.make(coordinatorLayout, "Already Exists", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        snackbar.dismiss();
                    }
                });
                snackbar.show();
                return;
        } else {
            arrayList.add(str);
            addedListAdapter.notifyDataSetChanged();
        }
        editText.setText("");
    }

    private void setDatePicker() {
        final DatePickerDialog.OnDateSetListener dpd = new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {

                cal = new GregorianCalendar(year, monthOfYear, dayOfMonth);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                date.setText(df.format(cal.getTime()));
            }
        };
        Calendar myCalendar = Calendar.getInstance();
        final DatePickerDialog dialog = new DatePickerDialog(this, dpd, myCalendar
                .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                myCalendar.get(Calendar.DAY_OF_MONTH));
        try {

            Date udate = DateUtils.fromDateTime(jsonObject.getString(TaskTable.STARTDATE));
            Date edate=DateUtils.fromDate(jsonObject.getString(TaskTable.STARTDATE));

            if (udate.before(edate)) {
                dialog.getDatePicker().setMinDate(udate.getTime());
            } else {
                dialog.getDatePicker().setMinDate(edate.getTime());
            }
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (JSONException e) {
            e.printStackTrace();
        }
        dialog.getDatePicker().setMaxDate(myCalendar.getTimeInMillis());
        date.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.show();
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        submit = findViewById(R.id.done);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(MyRequestQueue.getInstance(this).isNoNetwork()){
                    break;
                }
                requestLocationUpdate();
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public static void createJob(String datetime){

        Constraints constraints = new Constraints.Builder()
                // The Worker needs Network connectivity
                .setRequiredNetworkType(NetworkType.CONNECTED)
                // Needs the device to be charging
//                .setRequiresCharging(true)
                .build();
        OneTimeWorkRequest request =
                // Tell which work to execute
                new OneTimeWorkRequest.Builder(UpdateTaskService.class)
                        // Sets the input data for the ListenableWorker
                        .addTag(datetime)
                        // If you want to delay the start of work by 60 seconds
                        .setInitialDelay(60, TimeUnit.SECONDS)
                        // Set a backoff criteria to be used when retry-ing
//                        .setBackoffCriteria(BackoffCriteria.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                        // Set additional constraints
                        .setConstraints(constraints)
                        .build();
//        Job job = dispatcher.newJobBuilder()
//                .setLifetime(Lifetime.FOREVER)
//                .setService(UpdateTaskService.class)
//                .setTag(datetime)
//                .setTrigger(Trigger.executionWindow(0, 60))
//                .setConstraints(Constraint.ON_ANY_NETWORK)
//                .build();
//        return job;
    }

    private void showDialog(){
        if(!Utility.isNetworkAvailable(this)) {
            new AlertDialog.Builder(this).setTitle("No Internet Connection").setMessage("Progress will be saved in offline and feteched to server whenever internet connection available")
                    .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            // FIRE ZE MISSILES!
                        }
                    }).show();
        }
    }

    protected void OpenCamera(){
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        imageUri = getOutputMediaFileUri();
        intent.putExtra(MediaStore.EXTRA_OUTPUT, imageUri);
        startActivityForResult(intent, CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch(requestCode){
            case CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE:
                if (resultCode == RESULT_OK) {

                    try {
                        if (imageUri != null) {
                            try {
                                cambmp= BitmapFactory.decodeStream(this.getContentResolver().openInputStream(imageUri), null, null);
                                cambmp=Utility.processImage(cambmp);
                                snapshot.setImageBitmap(cambmp);
                            } catch (FileNotFoundException e) {
                                //e.printStackTrace();
                            }
                            camstring= Utility.bitmap2string(cambmp);
                        }

                    } catch (Exception e) {
                        Toast.makeText(getApplicationContext(), "please try again", Toast.LENGTH_SHORT).show();
                    }
                }else if (resultCode == RESULT_CANCELED) {
                    Toast.makeText(getApplicationContext(), "You cancelled image capture", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(getApplicationContext(), "Sorry! Failed to capture image", Toast.LENGTH_SHORT).show();
                }
                if(mediaFile!=null){
                    mediaFile.delete();
                }


                break;

            case  REQUEST_CHECK_SETTINGS:
                switch (resultCode) {
                    case Activity.RESULT_OK:
                        requestLocationUpdate();
                        break;
                    case Activity.RESULT_CANCELED:
                        RequestProgress.getInstance(this).hideProgressBar();
                        // The user was asked to change settings, but chose not to
                        break;
                    default:
                        break;
                }
                break;
        }


    }

    public Uri getOutputMediaFileUri() {

        //return FileProvider.getUriForFile(this,com.Rover.BuildConfig.APPLICATION_ID + ".provider",getOutputMediaFile(type));
        //Uri.fromFile(mediaFile);
        mediaFile=Utility.getCapturedImageFile();

        Uri uri= null;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            uri = FileProvider.getUriForFile(this,
                    BuildConfig.APPLICATION_ID + ".provider",
                    mediaFile);
        }else{
            uri= Uri.fromFile(mediaFile);
        }
        return uri;
    }

    private void requestLocationUpdate(){

        if(arrayList.size()==0){
            snackbar= Snackbar.make(coordinatorLayout, "Add completed activities", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }
        final String progressDate=date.getText().toString();
        if(progressDate.isEmpty()){
            snackbar= Snackbar.make(coordinatorLayout, "Select progress date", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }
        LocationUpdate locationUpdate=LocationUpdate.getInstance(this);
        locationUpdate.connectLocation(new LocationUpdateListener() {
            @Override
            public void onLocationReceived(String latitude, String longtitude) {
                try {
                    update(latitude,longtitude);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void update(String latitude, String longtitude) throws JSONException {

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        Preference preference=Preference.getInstance(this);
        StringBuilder csvBuilder = new StringBuilder();
        for(String activity : arrayList){
            csvBuilder.append(activity);
            csvBuilder.append("@#");
        }
        String activities = csvBuilder.toString();
        activities = activities.substring(0, activities.length() - "@#".length());
        final String finalActivities = activities;

        Map<String, String> params = new HashMap<String, String>();
        params.put("task_id",taskid);
        params.put("employee_id",preference.getEmailId());
        params.put("progress_date", date.getText().toString());
        params.put("progress",progress + "");
        params.put("latitude",latitude);
        params.put("longitude",longtitude);
        params.put("camera",camstring);
        params.put("completed_activities",finalActivities);
        params.put("completed_datetime",Utility.getCurrentDateTime());

        myRequestQueue.addToQueue(TASKURL.INSERT_PROGRESS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);

                    int success = json.getInt("s");
                    if (success == 1) {
                        //sqldatabase.insertTaskProgress(taskid,registeredemailid,progressDate,progress+"",finalActivities,datetime,"no",location.getLatitude()+"",location.getLongitude()+"");
                        finish();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }


}
