package com.b2lmobitech.fieldcloudplus.task.activities;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.adapters.ProgressListAdapter;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;

/**
 * Created by home on 11/13/2017.
 */

public class ProgressHistroy extends AppCompatActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_task_progresshistorty);

        getSupportActionBar().setTitle("Progress History");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        String id=getIntent().getStringExtra("id");
        JSONArray jsonArray= Database.getInstance(this).getProgressList(id);

        RecyclerView recyclerView=findViewById(R.id.recycle_view);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.setHasFixedSize(true);
        ProgressListAdapter progressListAdapter=new ProgressListAdapter(this,jsonArray);
        recyclerView.setAdapter(progressListAdapter);
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        onBackPressed();
        return true;
    }
}
