package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddProjectActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ProjectActivity extends AppCompatActivity {

    String projectid;
    Preference preference;
    MenuItem editProject,deleteProject;
    TextView projectName;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_project);
        projectid=getIntent().getStringExtra("id");
        if(projectid==null){
            projectid=Preference.getInstance(this).getProjectId();
        }

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Project");

        projectName=findViewById(R.id.projectName);
        projectName.setText(Database.getInstance(this).getProjectName(projectid));
        final MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        findViewById(R.id.milestonCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent=new Intent(getApplicationContext(),MilestoneActivity.class);
                intent.putExtra("id",projectid);
                startActivity(intent);

            }
        });

        findViewById(R.id.taskListCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent=new Intent(getApplicationContext(),TaskListActivity.class);
                intent.putExtra("id",projectid);
                startActivity(intent);
            }
        });

        findViewById(R.id.projectIcon).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent=new Intent(getApplicationContext(),ProjectInfoActivity.class);
                intent.putExtra("id",projectid);
                startActivity(intent);
            }
        });

        findViewById(R.id.requestCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(myRequestQueue.isNoNetwork()){
                    return;
                }
                Intent intent=new Intent(getApplicationContext(),Requests.class);
                intent.putExtra("id",projectid);
                startActivity(intent);
            }
        });




        preference= Preference.getInstance(this);
        if(preference.isAdmin() || Database.getInstance(this).isResponsibleForThisProject(projectid,preference.getEmailId())){
            findViewById(R.id.taskManagementCard).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(myRequestQueue.isNoNetwork()){
                        return;
                    }
                    Intent intent=new Intent(getApplicationContext(),TaskManagementActivity.class);
                    intent.putExtra("id",projectid);
                    startActivity(intent);
                }
            });
            findViewById(R.id.peopleCard).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(myRequestQueue.isNoNetwork()){
                        return;
                    }
                    Intent intent=new Intent(getApplicationContext(),PeopleActivity.class);
                    intent.putExtra("id",projectid);
                    startActivity(intent);
                }
            });

            findViewById(R.id.activityCard).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(myRequestQueue.isNoNetwork()){
                        return;
                    }
                    Intent intent=new Intent(getApplicationContext(),ActivitiesActivity.class);
                    intent.putExtra("id",projectid);
                    startActivity(intent);
                }
            });
        }else{
            findViewById(R.id.taskManagementCard).setVisibility(View.GONE);
            findViewById(R.id.peopleCard).setVisibility(View.GONE);
            findViewById(R.id.activityCard).setVisibility(View.INVISIBLE);

        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.task_project, menu);
        editProject=menu.findItem(R.id.edit);
        deleteProject=menu.findItem(R.id.delete);
        editProject.setVisible(false);
        deleteProject.setVisible(false);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
            case R.id.edit:
                if(MyRequestQueue.getInstance(this).isNoNetwork()){
                    break;
                }
                Intent intent = new Intent(this, AddProjectActivity.class);
                intent.putExtra("id",projectid);
                startActivity(intent);
                break;
            case R.id.delete:
                showAlert();
                break;

        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onResume() {
        super.onResume();
        getProjectsDetails();
    }

    private void getProjectsDetails(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("id",projectid);
        params.put("list", Database.getInstance(this).getProjectsList().toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_PROJECTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getProjects(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getProjects(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray=jsonObject.getJSONArray("projects");
        try {
            Database.getInstance(this).insertProjects(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        projectName.setText(Database.getInstance(this).getProjectName(projectid));
        if(Preference.getInstance(this).isResponsible(projectid)){
            editProject.setVisible(true);
            deleteProject.setVisible(true);
        }else{
            editProject.setVisible(false);
            deleteProject.setVisible(false);
        }
    }

    private void deleteProject(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("mail",preference.getEmailId());
        params.put("type",preference.getCompnayType());
        params.put("id",projectid);
        if(preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        }else{
            params.put("role","project");
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.DELETE_PROJECT, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Project deleted",Toast.LENGTH_SHORT).show();
                        Database.getInstance(getApplicationContext()).deleteProject(projectid);
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to delete project",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void showAlert(){
        new AlertDialog.Builder(this).setMessage("Project Will be deleted")
                .setPositiveButton("CONTINUE", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // FIRE ZE MISSILES!
                        deleteProject();
                    }
                })
                .setNegativeButton("CLOSE", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {

                    }
                }).show();
    }

}
