package com.b2lmobitech.fieldcloudplus.task.activities;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;

import org.json.JSONException;
import org.json.JSONObject;

public class ProjectInfoActivity extends AppCompatActivity {

    TextView projectName, projectDescription;
    LinearLayout projectDetails;
    String id;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_project_info);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Project Details");

        projectDetails = findViewById(R.id.projectDetails);
        projectDescription = findViewById(R.id.projectDescription);
        projectName = findViewById(R.id.projectName);
        id = getIntent().getStringExtra("id");
        try {
            getProjectDetais();
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    private void getProjectDetais() throws JSONException {
        Database database = Database.getInstance(this);

        JSONObject jsonObject = database.getProjectDetails(id);
        projectDetails.removeAllViews();
        projectName.setText(jsonObject.getString(ProjectTable.PROJECTNAME));
        if (jsonObject.getString(ProjectTable.DESCRIPTION).isEmpty()) {
            projectDescription.setText(R.string.noDescription);
        } else {
            projectDescription.setText(jsonObject.getString(ProjectTable.DESCRIPTION));
        }

        addView("Start",jsonObject.getString(ProjectTable.STARTDATE));
        addView("End", jsonObject.getString(ProjectTable.ENDDATE));
        addView("Responsible", database.getEmployeeName(jsonObject.getString(ProjectTable.RESPONSIBLEPERSON)));
        addView("Created On", jsonObject.getString(ProjectTable.CREATEDDATETIME));
        addView("Created By", database.getEmployeeName(jsonObject.getString(ProjectTable.CREATEDBY)));
    }

    private void addView(String key, String pair) {
        View view = getLayoutInflater().inflate(R.layout.mode_keypair, null);
        TextView keyText = view.findViewById(R.id.keyText);
        TextView pairText = view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        projectDetails.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
