package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.listener.LocationUpdateListener;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.others.LocationUpdate;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by home on 11/2/2017.
 */

public class RejectForm extends AppCompatActivity {

    TextView projectName,taskName,milestoneName,requestType;
    EditText requesetReason;
    String requestFor;
    String url="";
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    String assignId;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_request_form);


        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        requestFor=getIntent().getStringExtra("request");
        assignId=getIntent().getStringExtra("id");
        if(requestFor.equalsIgnoreCase("reject")){
            url= TASKURL.REJECT_TASK;
            getSupportActionBar().setTitle("Reject Task");
        }else{
            url= TASKURL.STOP_TASK;
            getSupportActionBar().setTitle("Stop Task");
        }

        findViewById(R.id.type_layout).setVisibility(View.GONE);
        getWidgets();
        try {
            setValues();
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    private void getWidgets(){

        projectName=findViewById(R.id.project_name);
        taskName=findViewById(R.id.task_name);
        milestoneName=findViewById(R.id.milestone_name);
        requestType=findViewById(R.id.request_type);
        requesetReason=findViewById(R.id.request_reason);
        coordinatorLayout=findViewById(R.id.coordinator);

    }

    private void setValues() throws JSONException {
        Database database=Database.getInstance(this);
        JSONObject jsonObject=database.getAssignDetails(assignId);
        projectName.setText(database.getProjectName(jsonObject.getString(TaskTable.PROJECTID)));
        taskName.setText(jsonObject.getString(TaskTable.NAME));
        milestoneName.setText(database.getMilestoneName(jsonObject.getString(TaskTable.MILESTONEID)));
        requestType.setText(requestFor);
    }

    private void checkLocation(){
        LocationUpdate locationUpdate=LocationUpdate.getInstance(this);
        locationUpdate.connectLocation(new LocationUpdateListener() {
            @Override
            public void onLocationReceived(String latitude, String longtitude) {
                stopOrRejectTask(latitude,longtitude);
            }
        });

    }

    public void stopOrRejectTask(String latitude, String longtitude){


        Map<String, String>  params = new HashMap<String, String>();

        params.put("assign_id",assignId);
        params.put("datetime", DateUtils.getCurrentDateTime());
        params.put("reason",requesetReason.getText().toString());
        params.put("latitude",latitude);
        params.put("longtitude",longtitude);

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);

        myRequestQueue.addToQueue(url, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json=new JSONObject(response);

                    int success = json.getInt("s");
                    if (success == 1) {
                        finish();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case R.id.done:
                if(MyRequestQueue.getInstance(this).isNoNetwork()){
                    break;
                }
                checkBeforeUpdate();
                break;
            case android.R.id.home:
                onBackPressed();
                return true;

        }
        return super.onOptionsItemSelected(item);
    }

    private void checkBeforeUpdate(){

        if(MyRequestQueue.getInstance(this).isNoInternet()) {
            snackbar= Snackbar.make(coordinatorLayout, "No Internet Connection", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }
        final String requestReason=requesetReason.getText().toString();

        if(requestReason.isEmpty()) {
            snackbar= Snackbar.make(coordinatorLayout, "Provide reason", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }

        new AlertDialog.Builder(this).setMessage("Task will be "+requestFor+"ed")
                .setPositiveButton(requestFor, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // FIRE ZE MISSILES!
                        checkLocation();
                    }
                })
                .setNegativeButton("cancel", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // User cancelled the dialog
                    }
                }).show();
    }

}
