package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.DialogInterface;
import android.content.Intent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.task.old.TaskDetails;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONObject;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class RequestDetails extends AppCompatActivity {

    private MenuItem delete;
    private CoordinatorLayout coordinatorLayout;
    private Snackbar snackbar;

    private TextView mainInfoText,taskName,requestDaysText;
    private RelativeLayout showInfoLayout;
    private LinearLayout requestDetails;
    private String requestId;
    boolean fromNotification=false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_request_details);

        getSupportActionBar().setTitle("Request Details");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        try {
            fromNotification = getIntent().getBooleanExtra("fromNotification", false);
        }catch (Exception e) {

        }
            requestId=getIntent().getStringExtra("id");
        getWidgets();
        setListeners();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if(Utility.isNetworkAvailable(this)){
            getRequests();
        }
    }

    private void getWidgets(){
        mainInfoText=findViewById(R.id.mainInfoText);
        taskName=findViewById(R.id.taskName);
        requestDaysText=findViewById(R.id.requestDaysText);
        showInfoLayout=findViewById(R.id.showInfoLayout);
        requestDetails=findViewById(R.id.requestDetails);
        coordinatorLayout=findViewById(R.id.coordinator);
    }


    private void setListeners(){
        taskName.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent=new Intent(RequestDetails.this, TaskDetails.class);
               // intent.putExtra("taskid",requestEncap.getTaskId());
                startActivity(intent);
            }
        });

        showInfoLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(requestDetails.getVisibility()==View.VISIBLE){
                    requestDetails.setVisibility(View.GONE);
                }else{
                    requestDetails.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    private void getRequests(){
        if(MyRequestQueue.getInstance(this).isNoNetwork()){
            return;
        }
        Map<String, String> params = new HashMap<>();
        params.put("id", requestId);

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_REQUESTS_DETAILS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        getRequests(jsonObject);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getRequests(JSONObject json) throws Exception{
        Database database=Database.getInstance(this);
        Preference preference=Preference.getInstance(this);
        JSONObject jsonObject=json.getJSONObject("data");
        taskName.setText(jsonObject.getString("task_name"));
        JSONArray employeeArray=json.getJSONArray("employees");
        database.insertEmplyoees(employeeArray);
        String rdays=jsonObject.getString("increasedays");
        if(rdays.equalsIgnoreCase("1")){
           requestDaysText.setText(MessageFormat.format("{0} Day", rdays));
        }else{
            requestDaysText.setText(String.format("%s Days", rdays));
        }
        String status=jsonObject.getString("r_status");
        mainInfoText.setText(status);
        requestDetails.removeAllViews();
        addView("Requested On",jsonObject.getString("r_datetime"));
        addView("Requested By",database.getEmployeeName(jsonObject.getString("employee_id")));
        if(fromNotification){
            Preference.getInstance(this).putProjectId(jsonObject.getString("project_id"));
        }
        addView("Reason",jsonObject.getString("reason"));
        addView("Task List",jsonObject.getString("listtask_name"));
        addView("Milestone",jsonObject.getString("milestone_name"));
        addView("Project",jsonObject.getString("project_name"));

        if(status.equalsIgnoreCase("accepted")){
            addView("Accepted On",jsonObject.getString("updatetime"));
            addView("Accepted By",database.getEmployeeName(jsonObject.getString("response_by")));
            addView("Response",jsonObject.getString("response"));
        }else if(status.equalsIgnoreCase("rejected")){
            addView("Rejected On",jsonObject.getString("updatetime"));
            addView("Rejected By",database.getEmployeeName(jsonObject.getString("response_by")));
            addView("Response",jsonObject.getString("response"));
        }

        if(jsonObject.getString("employee_id").equalsIgnoreCase(preference.getEmailId()) && status.equalsIgnoreCase("pending")){
            delete.setVisible(true);
        }else{
            delete.setVisible(false);
        }


    }

    private void deleteRequest(){


        Map<String, String> params = new HashMap<>();
        params.put("id", requestId);

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.DELETE_REQUEST, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Request Deleted Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Delete Request",Toast.LENGTH_SHORT).show();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });


    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_request_form, menu);
        delete=menu.findItem(R.id.delete);
        delete.setVisible(false);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){

            case R.id.delete:
                if(MyRequestQueue.getInstance(this).isNoNetwork()){
                    break;
                }
                    showDeleteDialog();
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);

    }

    private void showDeleteDialog(){

        if(!Utility.isNetworkAvailable(this)) {
            snackbar= Snackbar.make(coordinatorLayout, "No Internet Connection", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }

        new AlertDialog.Builder(this).setMessage("Request Will be deleted")
                .setPositiveButton("Delete", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // FIRE ZE MISSILES!
                        deleteRequest();
                    }
                })
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // User cancelled the dialog
                    }
                }).show();
    }


    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        requestDetails.addView(view);
    }

}
