package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Intent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.RquestUpdateActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.RequestListAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.task.listener.OnTaskActionSelected;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;


public class Requests extends AppCompatActivity implements OnTaskActionSelected {

    RecyclerView recyclerView;
    String projectId;
    SwipeRefreshLayout swipeRefreshLayout;
    Snackbar snackbar,nosnackbar;
    CoordinatorLayout coordinatorLayout;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_requests);

        getSupportActionBar().setTitle("Pending Requests");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        projectId=getIntent().getStringExtra("id");

        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        coordinatorLayout=findViewById(R.id.coordinator);
        swipeRefreshLayout=findViewById(R.id.swiperefresh);

        swipeRefreshLayout.setOnRefreshListener(
                new SwipeRefreshLayout.OnRefreshListener() {
                    @Override
                    public void onRefresh() {
                        // This method performs the actual data-refresh operation.
                        // The method calls setRefreshing(false) when it's finished.
                        getRequests();
                    }
                }
        );
        swipeRefreshLayout.setColorSchemeResources(android.R.color.holo_blue_bright,
                android.R.color.holo_green_light,
                android.R.color.holo_orange_light,
                android.R.color.holo_red_light);

    }

    @Override
    protected void onResume() {
        super.onResume();
        if(projectId==null){
            projectId=Preference.getInstance(this).getProjectId();
        }
        getRequests();
    }

    private void getRequests(){
        if(swipeRefreshLayout.isRefreshing()){
            swipeRefreshLayout.setRefreshing(false);
        }
        Map<String, String>  params = new HashMap<String, String>();

        Preference preference=Preference.getInstance(this);
        params.put("project_id", projectId);
        params.put("mail",preference.getEmailId());
        if(preference.isAdmin()){
            params.put("role",preference.getDesignation());
        }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
            params.put("role","project");
        }else{
            params.put("role","employee");
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_REQUESTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    getRequests(jsonObject.getJSONArray("requests"));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void getRequests(JSONArray jsonArray) throws JSONException{
        this.jsonArray=jsonArray;

        if(snackbar!=null){
            snackbar.dismiss();
        }
        if(jsonArray.length()==0){
            snackbar= Snackbar.make(coordinatorLayout, "No Pending Requests", Snackbar.LENGTH_INDEFINITE) .setAction("Show History", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                    Intent intent=new Intent(getApplicationContext(),RequestsHitstoryActivity.class);
                    intent.putExtra("id",projectId);
                    startActivity(intent);
                    finish();
                }
            });
            snackbar.show();
        }
        RequestListAdapter requestListAdapter=new RequestListAdapter(this,jsonArray,Preference.getInstance(this).isResponsible(projectId));
        recyclerView.setAdapter(requestListAdapter);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_request, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case R.id.history:
                Intent intent=new Intent(getApplicationContext(),RequestsHitstoryActivity.class);
                intent.putExtra("id",projectId);
                startActivity(intent);
                break;
            case android.R.id.home:
                onBackPressed();
                return true;

        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void taskSelected(int position, String action) {
        if(action.equalsIgnoreCase("details")){
            Intent intent=new Intent(getApplicationContext(),RequestDetails.class);
            intent.putExtra("title","Reject Request");
            try {
                intent.putExtra("id",jsonArray.getJSONObject(position).getString("id"));
            } catch (JSONException e) {
                e.printStackTrace();
            }
            startActivity(intent);
        }else if(action.equalsIgnoreCase("accepted") || action.equalsIgnoreCase("rejected")){
            Intent intent=new Intent(getApplicationContext(),RquestUpdateActivity.class);
            intent.putExtra("status",action);
            if(action.equalsIgnoreCase("accepted")){
                intent.putExtra("title", "Accept Request");
            }else{
                intent.putExtra("title", "Reject Request");
            }
            try {
                intent.putExtra("json",jsonArray.getJSONObject(position).toString());
            } catch (JSONException e) {
                e.printStackTrace();
            }
           startActivity(intent);
        }
    }

    private void updateRequest(String status,JSONObject jsonObject) throws ParseException, JSONException {
        Preference preference=Preference.getInstance(this);
        Date date= DateUtils.fromDate(jsonObject.getString("t_end_date"));
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(Calendar.DATE, jsonObject.getInt("increasedays"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());

        Map<String, String>  params = new HashMap<String, String>();
        params.put("enddate",df.format(c.getTime()));
        params.put("status", status);
        params.put("tid", jsonObject.getString("task_id"));
        params.put("id", jsonObject.getString("id"));
        params.put("mail",preference.getEmailId());
        params.put("type",preference.getCompnayType());
        if(preference.isAdmin()){
            params.put("role",preference.getDesignation());
        }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
            params.put("role","project");
        }else{
            params.put("role","employee");
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.REQUEST_UPDATE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Request Updated Successfully",Toast.LENGTH_SHORT).show();
                        getRequests();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to update Request",Toast.LENGTH_SHORT).show();
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

}
