package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Intent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.adapters.RequestHisotyAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class RequestsHitstoryActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    String projectId;
    SwipeRefreshLayout swipeRefreshLayout;
    Snackbar snackbar,nosnackbar;
    CoordinatorLayout coordinatorLayout;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_request_hitstory);
        getSupportActionBar().setTitle("Requests History");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        projectId=getIntent().getStringExtra("id");

        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        coordinatorLayout=findViewById(R.id.coordinatorLayout);
        swipeRefreshLayout=findViewById(R.id.swiperefresh);

        swipeRefreshLayout.setOnRefreshListener(
                new SwipeRefreshLayout.OnRefreshListener() {
                    @Override
                    public void onRefresh() {
                        // This method performs the actual data-refresh operation.
                        // The method calls setRefreshing(false) when it's finished.
                        getRequests();
                    }
                }
        );
        swipeRefreshLayout.setColorSchemeResources(android.R.color.holo_blue_bright,
                android.R.color.holo_green_light,
                android.R.color.holo_orange_light,
                android.R.color.holo_red_light);
    }

    @Override
    protected void onResume() {
        super.onResume();
        getRequests();
    }

    private void getRequests(){
        if(swipeRefreshLayout.isRefreshing()){
            swipeRefreshLayout.setRefreshing(false);
        }
        Map<String, String> params = new HashMap<String, String>();

        Preference preference=Preference.getInstance(this);
        params.put("project_id", projectId);
        params.put("mail",preference.getEmailId());
        if(preference.isAdmin()){
            params.put("role",preference.getDesignation());
        }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
            params.put("role","project");
        }else{
            params.put("role","employee");
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_REQUEST_HISTORY, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    getRequests(jsonObject.getJSONArray("requests"));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void getRequests(JSONArray jsonArray) throws JSONException{
        this.jsonArray=jsonArray;

        if(jsonArray.length()==0){
            snackbar= Snackbar.make(coordinatorLayout, "No Requests Found", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                    finish();
                }
            });
            snackbar.show();
        }

        RequestHisotyAdapter requestHisotyAdapter=new RequestHisotyAdapter(this,jsonArray,Preference.getInstance(this).isResponsible(projectId));
        recyclerView.setAdapter(requestHisotyAdapter);
    }

    @Override
    public void itemClicked(int position) {
        Intent intent=new Intent(getApplicationContext(),RequestDetails.class);
        try {
            intent.putExtra("id",jsonArray.getJSONObject(position).getString("id"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        startActivity(intent);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;

        }
        return super.onOptionsItemSelected(item);
    }
}
