package com.b2lmobitech.fieldcloudplus.task.activities;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.adapters.SearchResultAdapter;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;

import java.util.ArrayList;
import java.util.Date;

public class SearchResult extends AppCompatActivity {

    ArrayList<TaskEncap> taskLsit=new ArrayList<>();
    ArrayList<TaskEncap> searchList=new ArrayList<>();
    ArrayList<TaskEncap> adapterList=new ArrayList<>();

    String fromDate,toDate;
    RecyclerView recyclerView;
    Date selected1,selected2;
    SearchResultAdapter searchResultAdapter;
    TextView resultText;
    String type;
    String title;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_search_result);

        if(getIntent().getExtras()!=null){
            taskLsit=getIntent().getParcelableArrayListExtra("full_list");
            searchList=getIntent().getParcelableArrayListExtra("search_list");
            fromDate=getIntent().getStringExtra("fromDate");
            toDate=getIntent().getStringExtra("toDate");
            type=getIntent().getStringExtra("title");
        }
        resultText=findViewById(R.id.result_type);

        if(toDate.isEmpty()){
             resultText.setText(fromDate);
        }else{
            resultText.setText(fromDate+ " to "+toDate);
        }

        if(type.equalsIgnoreCase("Active")){
            title="Active Tasks";
        }else if(type.equalsIgnoreCase("Completed")){
            title="Completed Tasks";
        }else if(type.equalsIgnoreCase("Deadline")){
            title="Deadlines";
        }
        getSupportActionBar().setTitle(title);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        for(TaskEncap taskEncap:searchList){

            int dayend= 0;
            try {
                dayend = Utility.daysbetween(Utility.getDateTime(fromDate),taskEncap.getD_enddatte());

            if(taskEncap.getI_progress()==100 && taskEncap.getStatus().equalsIgnoreCase("completed"))
            {
                taskEncap.setCategory(TaskEnum.COMPLETED);
            }else if(taskEncap.getAssign_status().trim().equalsIgnoreCase("yetToAccept")) {
                taskEncap.setCategory(TaskEnum.NEW);
            }else{
                if (dayend!=0 && taskEncap.getD_enddatte().before(Utility.getDateTime(fromDate))){
                    taskEncap.setCategory(TaskEnum.LATE);
                } else if(taskEncap.getD_startdate().after(Utility.getDateTime(fromDate)) && taskEncap.getAssign_status().equalsIgnoreCase("accepted")){
                    taskEncap.setCategory(TaskEnum.UPCOMING);
                }else {
                    taskEncap.setCategory(TaskEnum.ACTIVE);
                }
            }
            } catch (Exception e) {
                e.printStackTrace();
            }

            adapterList.add(taskEncap);
        }

        recyclerView=findViewById(R.id.search_recycycle);
        searchResultAdapter=new SearchResultAdapter(this,searchList);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.setHasFixedSize(true);
        recyclerView.setAdapter(searchResultAdapter);
    }

}
