package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.DialogInterface;
import android.content.Intent;
import android.os.Handler;
import android.os.Parcelable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.ReduceProgressActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.TaskAssignActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.TaskReAssignActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.AllTasksAdapter;
import com.b2lmobitech.fieldcloudplus.task.adapters.TasksManagementAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.task.listener.OnTaskActionSelected;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TaskByStatusActivity extends AppCompatActivity implements OnTaskActionSelected {

    String projectId,status,employee;
    RecyclerView recyclerView;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_taskbystatus);
        projectId=getIntent().getStringExtra("id");
        status=getIntent().getStringExtra("status");
        employee=getIntent().getStringExtra("employee");

        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle(getIntent().getStringExtra("title"));

    }

    @Override
    protected void onResume() {
        super.onResume();
        getTasks();
    }

    private void getTasks(){

        jsonArray=Database.getInstance(this).getTasksByStatus(projectId,status,employee);
        JSONArray list=new JSONArray();


        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("mail",preference.getEmailId());
        params.put("id",projectId);
        params.put("status",status);

        if(employee!=null){
            try {
                for(int i=0; i<jsonArray.length(); i++){
                    if(jsonArray.getJSONObject(i).getString(AssignTable.EMPLYOEEID).equals(employee)) {
                        list.put(jsonArray.getJSONObject(i).getString(TaskTable.TASKID));
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            params.put("employee", employee);

        }else{
            try {
                for(int i=0; i<jsonArray.length(); i++){
                    list.put(jsonArray.getJSONObject(i).getString(TaskTable.TASKID));
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        params.put("list",list.toString());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_TASKBYSTATUS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getTasks(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasks(final JSONObject jsonObject) throws JSONException {

        final MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        final Database database=Database.getInstance(this);
        myRequestQueue.showProgressBar();
        final Handler handler = new Handler();
        final Runnable runnable = new Runnable() {
            public void run() {
                try {
                    database.insertEmplyoees(jsonObject.getJSONArray("employees"));
                    database.insertTasks(jsonObject.getJSONArray("tasks"));
                    database.insertAssigns(jsonObject.getJSONArray("assigns"));
                    setAdapter();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                myRequestQueue.hideProgressBar();
            }
        };
        handler.postAtFrontOfQueue(runnable);
    }

    private void setAdapter(){

        jsonArray=Database.getInstance(this).getTasksByStatus(projectId,status,employee);


        Parcelable recyclerViewState = recyclerView.getLayoutManager().onSaveInstanceState();

        if(status.equalsIgnoreCase("underprogress") || status.equalsIgnoreCase("late")){
            AllTasksAdapter allTasksAdapter=new AllTasksAdapter(this,jsonArray,"active",true);
            recyclerView.setAdapter(allTasksAdapter);
        }else{
            TasksManagementAdapter tasksManagementAdapter=new TasksManagementAdapter(this,jsonArray,status);
            recyclerView.setAdapter(tasksManagementAdapter);
        }
        if(jsonArray.length()==0){
            findViewById(R.id.noTasksFound).setVisibility(View.VISIBLE);
        }
        try {
            recyclerView.getLayoutManager().onRestoreInstanceState(recyclerViewState);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public void taskSelected(final int position, String action) {

        if(MyRequestQueue.getInstance(this).isNoNetwork()){
            return;
        }
        try {
            final JSONObject jsonObject=jsonArray.getJSONObject(position);

            if(action.equalsIgnoreCase("assign")){
                Intent intent=new Intent(getApplicationContext(), TaskAssignActivity.class);
                intent.putExtra("id",jsonObject.getString(TaskTable.TASKID));
                startActivity(intent);
            }else if(action.equalsIgnoreCase("unassign")){
                AlertDialog.Builder builder = new AlertDialog.Builder(this);
                builder.setPositiveButton("CONFIRM", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        try {
                            unassignTask(jsonObject.getString(AssignTable.ASSIGNID),jsonObject.getString(AssignTable.TASKID));
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });

                builder.setNegativeButton("CLOSE", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {

                    }
                });

                builder.setMessage("Are you sure want to unassign task");
                AlertDialog dialog = builder.create();
                dialog.show();
            }else if(action.equalsIgnoreCase("reassign")){
                Intent intent=new Intent(getApplicationContext(), TaskReAssignActivity.class);
                intent.putExtra("id",jsonObject.getString(TaskTable.TASKID));
                intent.putExtra("aid",jsonObject.getString(AssignTable.ASSIGNID));
                intent.putExtra("eid",jsonObject.getString(AssignTable.EMPLYOEEID));
                startActivity(intent);

            }else if(action.equalsIgnoreCase("complete")){
                completeTask(jsonObject.getString(AssignTable.ASSIGNID),jsonObject.getString(AssignTable.TASKID));
            }else if(action.equalsIgnoreCase("modify")){
                Intent intent=new Intent(getApplicationContext(), ReduceProgressActivity.class);
                intent.putExtra("id",jsonObject.getString(TaskTable.TASKID));
                intent.putExtra("name",jsonObject.getString(TaskTable.NAME));
                startActivity(intent);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void unassignTask(String assignId,String taskId){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("assignId",assignId);
            jsonObject.put("taskId",taskId);
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            jsonObject.put("role",preference.getDesignation());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.UNASSIGN_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Task Unassigned Successfully",Toast.LENGTH_SHORT).show();
                        getTasks();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Unassign Task ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }



    private void completeTask(String assignId,String taskId){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("assignId",assignId);
            jsonObject.put("taskId",taskId);
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.COMPLETE_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Task Completed Successfully",Toast.LENGTH_SHORT).show();
                        getTasks();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Complete Task ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                finish();
                break;
        }
        return super.onOptionsItemSelected(item);
    }

}
