package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Handler;
import android.provider.Settings;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskActivity;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TaskInfoActivity extends AppCompatActivity {

    LinearLayout taskDetails;
    TextView mainInfoText,taskName,descriptionText,completedText,completedPercentage;
    MenuItem stop,update,request,start,history,reminder,accept,reject,assign,unassign,edit,delete;
    RelativeLayout showInfoLayout,percentageLayout;
    SeekBar perccentageSeekbar;
    JSONObject jsonObject;
    String taskid;
    String assignid;
    boolean requestPlaced=true;
    boolean fromNotification=false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_task_info);
        taskid=getIntent().getStringExtra("id");
        try {
            fromNotification = getIntent().getBooleanExtra("fromNotification", false);
        }catch (Exception e){
            e.printStackTrace();
        }
        taskDetails=findViewById(R.id.taskDetails);
        mainInfoText=findViewById(R.id.mainInfoText);
        taskName=findViewById(R.id.taskName);
        descriptionText=findViewById(R.id.descriptionText);
        showInfoLayout=findViewById(R.id.showInfoLayout);
        perccentageSeekbar=findViewById(R.id.perccentageSeekbar);
        completedPercentage=findViewById(R.id.completedPercentage);
        completedText=findViewById(R.id.completedText);
        percentageLayout=findViewById(R.id.percentageLayout);

        getSupportActionBar().setTitle("Task Details");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        showInfoLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(taskDetails.getVisibility()==View.VISIBLE){
                    taskDetails.setVisibility(View.GONE);
                }else{
                    taskDetails.setVisibility(View.VISIBLE);
                }
            }
        });

        perccentageSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                completedPercentage.setText(i+"%");

                try {
                    if(i>jsonObject.getInt(TaskTable.PROGRESS)) {
                        update.setVisible(true);
                    }else{
                        update.setVisible(false);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
        getTasksDetais();
    }

    private void addTaskDetails() throws Exception {
        Database database= Database.getInstance(this);
        Preference preference=Preference.getInstance(this);
        boolean isResponsible=false,isAssignedToMe=false;


        jsonObject= database.getTaskDetails(taskid);
        taskDetails.removeAllViews();
        taskName.setText(jsonObject.getString(TaskTable.NAME));
        descriptionText.setText(jsonObject.getString(TaskTable.DESCRIPTION));

        addView("Start",jsonObject.getString(TaskTable.STARTDATE));
        addView("End",jsonObject.getString(TaskTable.ENDDATE));
        addView("Priority",jsonObject.getString(TaskTable.PRIORITY));
        addView("Task List",database.getTaskListName(jsonObject.getString(TaskTable.LISTTASKID)));
        addView("Project",database.getProjectName(jsonObject.getString(TaskTable.PROJECTID)));

        if(fromNotification){
            preference.putProjectId(jsonObject.getString(TaskTable.PROJECTID));
            preference.putTaskListId(jsonObject.getString(TaskTable.LISTTASKID));
        }

        if(!jsonObject.getString(TaskTable.STATUS).equalsIgnoreCase("unassigned")) {
            assignid=jsonObject.getString(AssignTable.ASSIGNID);
            if (jsonObject.getString(AssignTable.EMPLYOEEID).equalsIgnoreCase(Preference.getInstance(getApplicationContext()).getEmailId())) {
                addView("Assigned To", getString(R.string.responsible));
                isAssignedToMe = true;
            } else {
                addView("Assigned To", Database.getInstance(this).getEmployeeName(jsonObject.getString(AssignTable.EMPLYOEEID)));
                isAssignedToMe = false;
            }
        }

        String projectResponsible=database.getProjectResponsible(jsonObject.getString(TaskTable.PROJECTID));
        String role=preference.getDesignation();
        String emailid=preference.getEmailId();

        addView("Created On",jsonObject.getString(TaskTable.CREATEDDATETIME));
        addView("Created By",database.getEmployeeName(jsonObject.getString(TaskTable.CREATEDBY)));
        perccentageSeekbar.setProgress(jsonObject.getInt(TaskTable.PROGRESS));
        completedPercentage.setText(String.format("%s%%", jsonObject.getString(TaskTable.PROGRESS)));

        if(projectResponsible.equalsIgnoreCase(emailid) || role.equalsIgnoreCase("admin")){
            isResponsible=true;
        }else{
            isResponsible=false;
        }
        if(jsonObject.getString(TaskTable.STATUS).equalsIgnoreCase("unassigned")){
            if(DateUtils.fromDate(jsonObject.getString(TaskTable.ENDDATE)).before(DateUtils.currentDate())){
                mainInfoText.setText(String.format("Unassigned, %s", DateUtils.getLateDateString(jsonObject.getString(TaskTable.ENDDATE))));
            }else if(DateUtils.fromDate(jsonObject.getString(TaskTable.STARTDATE)).after(DateUtils.currentDate())){
                mainInfoText.setText(String.format("Unassigned, %s", DateUtils.getUpcomingDateString(jsonObject.getString(TaskTable.STARTDATE))));
            }else{
                mainInfoText.setText(String.format("Unassigned, %s", DateUtils.getDueDateString(jsonObject.getString(TaskTable.ENDDATE))));
            }
            manageActionBar(isResponsible,isAssignedToMe,"unassigned");

        }else if(jsonObject.getString(AssignTable.STATUS).equalsIgnoreCase("yettoaccept")){
            if(DateUtils.fromDate(jsonObject.getString(TaskTable.ENDDATE)).before(DateUtils.currentDate())){
                mainInfoText.setText(String.format("New Task, %s", DateUtils.getLateDateString(jsonObject.getString(TaskTable.ENDDATE))));
            }else if(DateUtils.fromDate(jsonObject.getString(TaskTable.STARTDATE)).after(DateUtils.currentDate())){
                mainInfoText.setText(String.format("New Task, %s", DateUtils.getUpcomingDateString(jsonObject.getString(TaskTable.STARTDATE))));
            }else{
                mainInfoText.setText(String.format("New Task, %s", DateUtils.getDueDateString(jsonObject.getString(TaskTable.ENDDATE))));
            }
            manageActionBar(isResponsible,isAssignedToMe,"yettoaccept");

        }else if(jsonObject.getString(AssignTable.STATUS).equalsIgnoreCase("accepted")){
            if(DateUtils.fromDate(jsonObject.getString(TaskTable.ENDDATE)).before(DateUtils.currentDate())){
                mainInfoText.setText("Accepted,"+DateUtils.getLateDateString(jsonObject.getString(TaskTable.ENDDATE)));
            }else if(DateUtils.fromDate(jsonObject.getString(TaskTable.STARTDATE)).after(DateUtils.currentDate())){
                mainInfoText.setText("Accepted,"+DateUtils.getUpcomingDateString(jsonObject.getString(TaskTable.STARTDATE)));
            }else{
                mainInfoText.setText("Accepted,"+DateUtils.getDueDateString(jsonObject.getString(TaskTable.ENDDATE)));
            }
            manageActionBar(isResponsible,isAssignedToMe,"accepted");

        }else if(jsonObject.getString(AssignTable.STATUS).equalsIgnoreCase("completed") ){
            addView("Completed On",jsonObject.getString(TaskTable.COMPLETEDDATETIME));
           // addView("Completed By",database.getEmployeeName(jsonObject.getString(TaskTable.COMPLETEDBY)));
            mainInfoText.setText(DateUtils.getCompletedDateString(jsonObject.getString(TaskTable.COMPLETEDDATETIME)));
            manageActionBar(isResponsible,isAssignedToMe,"completed");

        }else if(jsonObject.getString(AssignTable.STATUS).equalsIgnoreCase("underprogress")){
            mainInfoText.setText(DateUtils.getDueDateString(jsonObject.getString(TaskTable.ENDDATE)));
            if(jsonObject.getInt(TaskTable.PROGRESS)==90){
                manageActionBar(isResponsible,isAssignedToMe,"completeRequest");
            }else{
                manageActionBar(isResponsible,isAssignedToMe,"underprogress");
            }
        }else if(jsonObject.getString(AssignTable.STATUS).equalsIgnoreCase("declined")){
            mainInfoText.setText(DateUtils.getDueDateString(jsonObject.getString(TaskTable.ENDDATE)));

            if(DateUtils.fromDate(jsonObject.getString(TaskTable.ENDDATE)).before(DateUtils.currentDate())){
                mainInfoText.setText("Declined,"+DateUtils.getLateDateString(jsonObject.getString(TaskTable.ENDDATE)));
            }else if(DateUtils.fromDate(jsonObject.getString(TaskTable.STARTDATE)).after(DateUtils.currentDate())){
                mainInfoText.setText("Declined,"+DateUtils.getUpcomingDateString(jsonObject.getString(TaskTable.STARTDATE)));
            }else{
                mainInfoText.setText("Declined,"+DateUtils.getDueDateString(jsonObject.getString(TaskTable.ENDDATE)));
            }
             manageActionBar(isResponsible,isAssignedToMe,"declined");
        }else if(jsonObject.getString(TaskTable.STATUS).equalsIgnoreCase("stalled")){
            mainInfoText.setText("Stalled");
            manageActionBar(isResponsible,isAssignedToMe,"stalled");
            addView("Stalled On",jsonObject.getString(TaskTable.STALLEDDATETIME));
            addView("Stalled By",database.getEmployeeName(jsonObject.getString(TaskTable.STALLEDBY)));
        }else if(jsonObject.getString(TaskTable.STATUS).equalsIgnoreCase("stopped")){
            mainInfoText.setText("Stopped");
            manageActionBar(isResponsible,isAssignedToMe,"stopped");
            addView("Stopped On",jsonObject.getString(TaskTable.STOPPEDDATETIME));
        }
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        taskDetails.addView(view);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_all, menu);

        update=menu.findItem(R.id.update);
        start=menu.findItem(R.id.start);
        stop=menu.findItem(R.id.stop);
        request=menu.findItem(R.id.request);
        history=menu.findItem(R.id.history);
        reminder=menu.findItem(R.id.reminder);
        accept=menu.findItem(R.id.accept);
        reject=menu.findItem(R.id.reject);
        assign=menu.findItem(R.id.assign);
        unassign=menu.findItem(R.id.unassign);
        delete=menu.findItem(R.id.delete);
        edit=menu.findItem(R.id.edit);
        hideAll();
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        Intent intent;
        final MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);

        switch (item.getItemId()){
            case R.id.update:
                //updateProgress();
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, ProgressForm.class);
                intent.putExtra("taskid",taskid);
                intent.putExtra("progress",perccentageSeekbar.getProgress());
                startActivity(intent);
                break;
            case R.id.start:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                startTask();
                break;
            case R.id.accept:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                acceptTask();
                break;
            case R.id.stop:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, RejectForm.class);
                intent.putExtra("request", "stop");
                try {
                    intent.putExtra("id",jsonObject.getString(AssignTable.ASSIGNID));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                startActivity(intent);
                finish();
                break;
            case R.id.edit:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, AddTaskActivity.class);
                intent.putExtra("taskId", taskid);
                try {
                    intent.putExtra("id",jsonObject.getString(TaskTable.PROJECTID));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                startActivity(intent);
                break;
            case R.id.reject:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, RejectForm.class);
                intent.putExtra("request", "reject");
                try {
                    intent.putExtra("id",jsonObject.getString(AssignTable.ASSIGNID));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                startActivity(intent);
                finish();
                break;
            case R.id.reminder:
                //reminder();
                break;

            case R.id.request:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, ExtendForm.class);
                try {
                    intent.putExtra("assignId",jsonObject.getString(AssignTable.ASSIGNID));
                    intent.putExtra("taskId",jsonObject.getString(TaskTable.TASKID));
                    intent.putExtra("end",jsonObject.getString(TaskTable.ENDDATE));

                } catch (JSONException e) {
                    e.printStackTrace();
                }
                startActivity(intent);
                break;
            case R.id.history:
                if(myRequestQueue.isNoNetwork()){
                    break;
                }
                intent = new Intent(this, ProgressHistroy.class);
                try {
                        intent.putExtra("id",jsonObject.getString(TaskTable.TASKID));
                } catch (JSONException e) {
                        e.printStackTrace();
                }
                startActivity(intent);
                break;
            case R.id.delete:
                showAlert();
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkforMenuCreated(){
        final Handler handler = new Handler();
        final Runnable runnable = new Runnable() {
            public void run() {
                Log.d("Runnable","Handler is working");
                if(update!=null){ // just remove call backs
                    handler.removeCallbacks(this);
                    try {
                        addTaskDetails();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else { // post again
                    handler.postDelayed(this, 100);
                }
            }
        };
        handler.removeCallbacks(runnable);
        handler.postDelayed(runnable, 100);
    }

    public void acceptTask(){

        final LocationManager locationManager = (LocationManager)getSystemService(Context.LOCATION_SERVICE);

        boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
        if (!isGPSEnabled && !isNetworkEnabled) {
            //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(this);

            alertdialog.setTitle("Access Location");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("No network provider is enabled for location access!!");
            alertdialog.setPositiveButton("Turn On",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                        }
                    });
            alertdialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // TODO Auto-generated method stub

                }
            }).create();
            alertdialog.show();
            return;
        }

        final LatLang latLang= Utility.getLocation(getApplicationContext());

        Map<String, String> params = new HashMap<String, String>();

        params.put("assign_id", assignid);
        params.put("datetime", DateUtils.getCurrentDateTime());
        params.put("latitude", latLang.getLatitude());
        params.put("longtitude",latLang.getLongitude());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ACCEPT_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        getTasksDetais();
                    }
                    Toast.makeText(getApplicationContext(),jsonObject.getString("m"),Toast.LENGTH_SHORT).show();

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void getTasksDetais(){

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        Database database=Database.getInstance(this);
        if(myRequestQueue.isNoInternet()){
            checkforMenuCreated();
        }else{
            findViewById(R.id.mainLayout).setVisibility(View.GONE);
            Map<String, String> params = new HashMap<>();
            params.put("taskid", taskid);
            try {
                JSONObject jsonObject=database.getTaskDetails(taskid);
                params.put("tdt", database.getTasklistColumn(jsonObject.getString(TaskTable.LISTTASKID), TasklistTable.UPDATEDATETIME));
                params.put("mdt", database.getMilestoneColumn(jsonObject.getString(TaskTable.MILESTONEID), MilestoneTable.UPDATEDATETIME));
                params.put("pdt", database.getProjectColumn(jsonObject.getString(TaskTable.PROJECTID), ProjectTable.UPDATEDATETIME));
            }catch (Exception e){
                e.printStackTrace();
            }
            myRequestQueue.addToQueue(TASKURL.GET_TASK_DETAILS, params, new MyRequestFinishedListener() {
                @Override
                public void requestResult(String response) {
                    findViewById(R.id.mainLayout).setVisibility(View.VISIBLE);
                    try {
                        JSONObject jsonObject=new JSONObject(response);
                        getTaskDetails(new JSONObject(response));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

    }

    private void getTaskDetails(final JSONObject jsonObject) throws JSONException {

        JSONArray employeeArray=jsonObject.getJSONArray("employees");
        JSONArray taskArray=jsonObject.getJSONArray("tasks");
        JSONArray assignArray=jsonObject.getJSONArray("assigns");
        JSONArray progressArray=jsonObject.getJSONArray("progress");
        JSONArray milestoneArray=jsonObject.getJSONArray("milestones");
        JSONArray tasklistArray=jsonObject.getJSONArray("tasklists");
        JSONArray projectArray=jsonObject.getJSONArray("projects");

        Database database=Database.getInstance(this);
        try {
            database.insertEmplyoees(employeeArray);
            database.insertTasks(taskArray);
            database.insertAssigns(assignArray);
            database.insertProgress(progressArray);
            database.insertMilestones(milestoneArray);
            database.insertTaskLists(tasklistArray);
            database.insertProjects(projectArray);
        } catch (Exception e) {
            e.printStackTrace();
        }

        if(jsonObject.getBoolean("requested")){
            findViewById(R.id.requestText).setVisibility(View.VISIBLE);
            requestPlaced=true;
        }else{
            requestPlaced=false;
            findViewById(R.id.requestText).setVisibility(View.GONE);
        }
        /*findViewById(R.id.requestText).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent=new Intent(getApplicationContext(),RequestDetails.class);
                try {
                    intent.putExtra("id",jsonObject.getString("requestid"));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                startActivity(intent);
            }
        });*/
        checkforMenuCreated();

    }

    private void startTask(){

        final LocationManager locationManager = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);

        boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
        if (!isGPSEnabled && !isNetworkEnabled) {
            //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            android.app.AlertDialog.Builder alertdialog = new android.app.AlertDialog.Builder(this);

            alertdialog.setTitle("Access Location");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("No network provider is enabled for location access!!");
            alertdialog.setPositiveButton("Turn On",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                        }
                    });
            alertdialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // TODO Auto-generated method stub

                }
            }).create();
            alertdialog.show();
            return;
        }

        final LatLang latLang=Utility.getLocation(this);
        final String datetime=Utility.getCurrentDateTime();

        Map<String, String>  params = new HashMap<String, String>();

        params.put("assign_id", assignid);
        params.put("task_id",taskid);
        params.put("datetime",datetime);
        params.put("latitude", latLang.getLatitude());
        params.put("longtitude",latLang.getLongitude());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.START_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        getTasksDetais();
                    }
                    Toast.makeText(getApplicationContext(),jsonObject.getString("m"),Toast.LENGTH_SHORT).show();

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void hideAll(){
        start.setVisible(false);
        stop.setVisible(false);
        request.setVisible(false);
        history.setVisible(false);
        accept.setVisible(false);
        reject.setVisible(false);
        update.setVisible(false);
        reminder.setVisible(false);
        assign.setVisible(false);
        unassign.setVisible(false);
        delete.setVisible(false);
        edit.setVisible(false);
        percentageLayout.setVisibility(View.GONE);
    }

    private void manageActionBar(boolean isResponisble,boolean isAssignedToMe, String status){

        hideAll();
        if(isResponisble){
            edit.setVisible(true);
            delete.setVisible(true);
        }
        if(status.equalsIgnoreCase("unassigned") && isResponisble){
            assign.setVisible(false);
        }else if(status.equalsIgnoreCase("yettoaccept")){
            if(isAssignedToMe || isResponisble){
                accept.setVisible(true);
                reject.setVisible(true);
               /* if(isResponisble){
                    assign.setVisible(true);
                    unassign.setVisible(true);
                }*/
            }
            percentageLayout.setVisibility(View.GONE);
        }else if(status.equalsIgnoreCase("accepted")){
            percentageLayout.setVisibility(View.GONE);
            if(isAssignedToMe || isResponisble){
                start.setVisible(true);
               /* if(isResponisble){
                    assign.setVisible(true);
                    unassign.setVisible(true);
                }*/
            }
        }else if(status.equalsIgnoreCase("completed") || status.equalsIgnoreCase("stalled") || status.equalsIgnoreCase("stopped")){
            history.setVisible(true);
            percentageLayout.setVisibility(View.GONE);
            edit.setVisible(false);
        }else if(status.equalsIgnoreCase("declined") ){
            history.setVisible(false);
            percentageLayout.setVisibility(View.GONE);
            edit.setVisible(true);
        }else if(status.equalsIgnoreCase("completeRequest")){
            if(isAssignedToMe || isResponisble) {
                history.setVisible(true);
                percentageLayout.setVisibility(View.VISIBLE);
                edit.setVisible(false);
                perccentageSeekbar.setVisibility(View.GONE);
            }
        }else if(status.equalsIgnoreCase("underprogress")){
            history.setVisible(true);
            if(isAssignedToMe && !requestPlaced) {
                request.setVisible(true);
            }
            percentageLayout.setVisibility(View.VISIBLE);
            if(isResponisble || isAssignedToMe){
                stop.setVisible(true);
                //reminder.setVisible(true);
                perccentageSeekbar.setVisibility(View.VISIBLE);
            }else{
                perccentageSeekbar.setVisibility(View.GONE);
            }
        }
    }

    private void deleteTask(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        try {
            jsonObject.put("name",taskName.getText().toString());
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            jsonObject.put("taskId",taskid);
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else{
                jsonObject.put("role","project");
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.DELETE_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json=new JSONObject(response);
                    if(json.getInt("s")==1){
                        Database.getInstance(getApplicationContext()).deleteTask(taskid);
                        Toast.makeText(getApplicationContext(),"Task Deleted",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Delete Task ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void showAlert(){
        new android.app.AlertDialog.Builder(this).setMessage("Tasklist Will be deleted")
                .setPositiveButton("CONTINUE", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // FIRE ZE MISSILES!
                        deleteTask();
                    }
                })
                .setNegativeButton("CLOSE", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {

                    }
                }).show();
    }

}
