package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Intent;
import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskListActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.ListAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TaskListActivity extends AppCompatActivity implements OnItemClickListener{

    String projectid;
    RecyclerView recyclerView;
    MenuItem newTasklist;
    boolean menuCreated=false;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_task_list2);
        projectid=getIntent().getStringExtra("id");
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        getSupportActionBar().setTitle("Task Lists");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if(projectid==null){
            projectid=Preference.getInstance(this).getProjectId();
        }
        if(MyRequestQueue.getInstance(this).isNoInternet()){
            getTasklistsOffline();
        }else{
            getTasklists();
        }
    }

    private void getTasklists(){
        Preference preference=Preference.getInstance(this);
        Database database= Database.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("mail",preference.getEmailId());
        params.put("id",projectid);
        if(preference.getEmailId().equalsIgnoreCase(database.getProjectResponsible(projectid))){
            params.put("responsible", "yes");
        }else{
            params.put("responsible", "no");
        }
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", database.getTaskListLists(projectid).toString());
        //params.put("list", new JSONArray().toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_TASKLISTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getTasklists(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasklists(JSONObject jsonObject) throws JSONException {
        Database database=Database.getInstance(this);
        JSONArray jsonArray=jsonObject.getJSONArray("list");
        database.deleteTasklists(projectid);
        try {
            database.insertTaskLists(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        getTasklistsOffline();
    }

    private void getTasklistsOffline(){
        jsonArray=Database.getInstance(this).getTaskLists(projectid);
        if(jsonArray.length()==0){
            findViewById(R.id.listEmptyText).setVisibility(View.VISIBLE);
            if(Preference.getInstance(this).isResponsible(projectid)) {
                findViewById(R.id.addNewText).setVisibility(View.VISIBLE);
            }
            findViewById(R.id.addNewText).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    addNew();
                }
            });
        }else{
            findViewById(R.id.listEmptyText).setVisibility(View.GONE);
            findViewById(R.id.addNewText).setVisibility(View.GONE);
        }
        ListAdapter taskListAdapter= new ListAdapter(this,jsonArray);
        recyclerView.setAdapter(taskListAdapter);
        checkforMenuCreated();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_tasklist, menu);
        newTasklist=menu.findItem(R.id.newTasklist);
        newTasklist.setVisible(false);
        menuCreated=true;
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case R.id.newTasklist:
                addNew();
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void addNew(){
        Intent intent = new Intent(this, AddTaskListActivity.class);
        intent.putExtra("id",projectid);
        startActivity(intent);
    }

    private void checkforMenuCreated(){
        final Handler handler = new Handler();
        final Runnable runnable = new Runnable() {
            public void run() {
                Log.d("Runnable","Handler is working");
                if(menuCreated){ // just remove call backs
                    handler.removeCallbacks(this);
                    try {
                        manageActionBarIcons();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else { // post again
                    handler.postDelayed(this, 100);
                }
            }
        };
        handler.removeCallbacks(runnable);
        handler.postDelayed(runnable, 100);
    }

    private void manageActionBarIcons(){
        Preference preference=Preference.getInstance(this);
        if(preference.isResponsible(projectid)){
            newTasklist.setVisible(true);
            /*findViewById(R.id.addNewText).setVisibility(View.VISIBLE);
            findViewById(R.id.addNewText).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    addNew();
                }
            });*/
        }
    }

    @Override
    public void itemClicked(int position) {
        Intent intent=new Intent(getApplicationContext(), AllTasksActivity.class);
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            intent.putExtra("id",jsonObject.getString(TasklistTable.TASKLISTID));
            intent.putExtra("projectId",projectid);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        startActivity(intent);
    }

}
