package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Intent;
import androidx.core.widget.NestedScrollView;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TaskManagementActivity extends AppCompatActivity {

    String projectId;
    TextView unassignedCountText,assignedCountText,activeCountText,completedCountText,stalledCountText,stoppedCountText,lateCountText;
    NestedScrollView nestedScrollView;
    String employee;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_taskmanagement);

        projectId=getIntent().getStringExtra("id");
        employee=getIntent().getStringExtra("employee");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Task Management");

        try {
            unassignedCountText = findViewById(R.id.unassignedCountText);
            assignedCountText = findViewById(R.id.assignedCountText);
            activeCountText = findViewById(R.id.activeCountText);
            completedCountText = findViewById(R.id.completedCountText);
            stalledCountText = findViewById(R.id.stalledCountText);
            stoppedCountText = findViewById(R.id.stoppedCountText);
            nestedScrollView=findViewById(R.id.nestedScrollView);
            lateCountText=findViewById(R.id.lateCountText);
        }catch (Exception e){
            e.printStackTrace();
        }
        final MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);



        final Intent intent=new Intent(getApplicationContext(),TaskByStatusActivity.class);
        intent.putExtra("id",projectId);
        intent.putExtra("employee",employee);

        findViewById(R.id.assignedCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(myRequestQueue.isNoNetwork()){
                    return;
                }
                intent.putExtra("status","assigned");
                intent.putExtra("title","Assigned Tasks");
                startActivity(intent);
            }
        });

        findViewById(R.id.activeCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(myRequestQueue.isNoNetwork()){
                    return;
                }
                intent.putExtra("status","underprogress");
                intent.putExtra("title","Underprogress Tasks");
                startActivity(intent);
            }
        });

        findViewById(R.id.completedCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(myRequestQueue.isNoNetwork()){
                    return;
                }
                intent.putExtra("status","completed");
                intent.putExtra("title","Completed Tasks");
                startActivity(intent);
            }
        });

        findViewById(R.id.lateCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(myRequestQueue.isNoNetwork()){
                    return;
                }
                intent.putExtra("status","late");
                intent.putExtra("title","Late Tasks");
                startActivity(intent);
            }
        });

        findViewById(R.id.completedCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(myRequestQueue.isNoNetwork()){
                    return;
                }
                intent.putExtra("status","completed");
                intent.putExtra("title","Completed Tasks");
                startActivity(intent);
            }
        });

        findViewById(R.id.stalledCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(myRequestQueue.isNoNetwork()){
                    return;
                }
                intent.putExtra("status","stalled");
                intent.putExtra("title","Stalled Tasks");
                startActivity(intent);
            }
        });

        findViewById(R.id.stoppedCard).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(myRequestQueue.isNoNetwork()){
                    return;
                }
                intent.putExtra("status","stopped");
                intent.putExtra("title","Stopped Tasks");
                startActivity(intent);
            }
        });

        if(employee==null) {
            findViewById(R.id.newTaskCard).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (myRequestQueue.isNoNetwork()) {
                        return;
                    }
                    Intent intent = new Intent(getApplicationContext(), AddTaskActivity.class);
                    intent.putExtra("id", projectId);
                    startActivity(intent);
                }
            });

            findViewById(R.id.unassignedCard).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(myRequestQueue.isNoNetwork()){
                        return;
                    }
                    intent.putExtra("status","unassigned");
                    intent.putExtra("title","Unassigned Tasks");
                    startActivity(intent);
                }
            });
        }else{
            findViewById(R.id.newTaskCard).setVisibility(View.GONE);
            findViewById(R.id.unassignedCard).setVisibility(View.GONE);

        }

    }

    @Override
    protected void onResume() {
        super.onResume();
        getCounts();
    }

    private void getCounts(){

        Map<String, String> params = new HashMap<>();

        Preference preference=Preference.getInstance(this);
        params.put("id", projectId);
        if(employee!=null){
            params.put("employee", employee);
        }
        params.put("mail",preference.getEmailId());
        if(preference.isAdmin()){
            params.put("role",preference.getDesignation());
        }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
            params.put("role","project");
        }else{
            params.put("role","employee");
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_TASKCOUNTSBYPROJECT, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        getCounts(jsonObject.getJSONArray("counts"));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void getCounts(JSONArray jsonArray) throws JSONException{
        JSONObject jsonObject=jsonArray.getJSONObject(0);
        if(!jsonObject.getString("active").equalsIgnoreCase("null")) {
            activeCountText.setText(jsonObject.getString("active"));
            unassignedCountText.setText(jsonObject.getString("unassigned"));
            stoppedCountText.setText(jsonObject.getString("stopped"));
            stalledCountText.setText(jsonObject.getString("stalled"));
            completedCountText.setText(jsonObject.getString("completed"));
            assignedCountText.setText(jsonObject.getString("assigned"));
            lateCountText.setText(jsonObject.getString("late"));
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
