package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.EditText;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class AddCategoryActivity extends AppCompatActivity {

    EditText catName,catDescription;
    String id;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_addcategory);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        catName=findViewById(R.id.catName);
        catDescription=findViewById(R.id.catDescription);

        if(getIntent().getStringExtra("id")!=null){
            id=getIntent().getStringExtra("id");
            getSupportActionBar().setTitle("Edit Cateogry");
            try {
                setValues();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }else{
            getSupportActionBar().setTitle("New Category");
        }

    }

    private void setValues() throws JSONException {
        Database database= Database.getInstance(this);
        JSONObject jsonObject= database.getCategoryDetails(id);
        catName.setText(jsonObject.getString(CategoryTable.CATNAME));
        catDescription.setText(jsonObject.getString(CategoryTable.CATDESCRIPTION));
    }

    private void checkCategoryName(final boolean goNext){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("name",catName.getText().toString().trim());
        if(id!=null){
            params.put("id",id);
        }
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.CHECK_CATEGORYNAME, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(!jsonObject.getBoolean("exists")){
                        if(goNext){
                            if(id==null) {
                                addCategory();
                            }else {
                                updateCategory();
                            }
                        }
                    }else{
                        Validations.getInstance(AddCategoryActivity.this).showAlert("Category Name Already Exists");
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addCategory(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role","admin");
            }else{
                jsonObject.put("role","project");
            }
            jsonObject.put("des",catDescription .getText().toString());
            jsonObject.put("name",catName.getText().toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ADD_CATEGORY, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Category Created Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Create Category",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void updateCategory(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role","admin");
            }else{
                jsonObject.put("role","project");
            }
            jsonObject.put("des",catDescription .getText().toString());
            jsonObject.put("name",catName.getText().toString());
            jsonObject.put("id",id);

        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.UPDATE_CATEGORY, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Category Updated Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Update Category",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private boolean isValid(){

        Validations validations=Validations.getInstance(this);

        if(catName.getText().toString().isEmpty()){
            validations.showAlert("Enter Name");
            return false;
        }

        if(catDescription.getText().toString().isEmpty()){
            validations.showAlert("Fill Description");
            return false;
        }
        return true;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(isValid()) {
                    checkCategoryName(true);
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }


}
