package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.content.Context;
import com.google.android.material.textfield.TextInputLayout;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class AddClientActivity extends AppCompatActivity {

    TextInputLayout companyName,mobileNumber,phoneNumber,emailid,address,webAddress,rname,rmobile,rmail;
    String id;
    private String NDA="no data available";
    LinearLayout responseLayout;
    TextView moreDetails;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_addclient);

        getWidgets();

        if(getIntent().getStringExtra("id")!=null){
            getSupportActionBar().setTitle("Edit Client");
            id=getIntent().getStringExtra("id");
            try {
                setValues();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }else{
            getSupportActionBar().setTitle("New Client");
        }
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }

    private void setValues() throws JSONException{
        Database database= Database.getInstance(this);

        JSONObject jsonObject= database.getClientDetails(id);
        companyName.getEditText().setText(jsonObject.getString(ClientTable.COMPANYNAME));
        address.getEditText().setText(jsonObject.getString(ClientTable.ADDRESS));
        mobileNumber.getEditText().setText(jsonObject.getString(ClientTable.CMOBILE));
        phoneNumber.getEditText().setText(jsonObject.getString(ClientTable.CPHONE));
        emailid.getEditText().setText(jsonObject.getString(ClientTable.CEMAIL));
        webAddress.getEditText().setText(jsonObject.getString(ClientTable.WEBADDRESS));

        if(!jsonObject.getString(ClientTable.RESPONSIBLEPERSON).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEPERSON).equalsIgnoreCase(NDA)) {
            rname.getEditText().setText(jsonObject.getString(ClientTable.RESPONSIBLEPERSON));
        }
        if(!jsonObject.getString(ClientTable.RESPONSIBLEMAIL).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEMAIL).equalsIgnoreCase(NDA)) {
            rmail.getEditText().setText(jsonObject.getString(ClientTable.RESPONSIBLEMAIL));
        }

        if(!jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE).equalsIgnoreCase(NDA)) {
            rmobile.getEditText().setText(jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE));
        }
        responseLayout.setVisibility(View.VISIBLE);
        moreDetails.setVisibility(View.GONE);
    }


    private void getWidgets(){
        companyName=findViewById(R.id.companyName);
        mobileNumber=findViewById(R.id.mobileNumber);
        phoneNumber=findViewById(R.id.phoneNumber);
        emailid=findViewById(R.id.emailid);
        address=findViewById(R.id.address);
        webAddress=findViewById(R.id.webAddress);
        rname=findViewById(R.id.rname);
        rmobile=findViewById(R.id.rmobile);
        rmail=findViewById(R.id.rmail);
        responseLayout=findViewById(R.id.responseLayout);
        moreDetails=findViewById(R.id.moreDetails);
        companyName.getEditText().setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if(!hasFocus){
                    checkCompanyName(false);
                }
            }
        });
        moreDetails.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                responseLayout.setVisibility(View.VISIBLE);
                moreDetails.setVisibility(View.GONE);
            }
        });
    }

    private boolean isValid(){

        Validations validations=Validations.getInstance(this);
        if(companyName.getEditText().getText().toString().isEmpty()){
            validations.showAlert("Enter Company Name");
            return false;
        }
        if(mobileNumber.getEditText().getText().toString().isEmpty()){
            validations.showAlert("Enter Valid Mobile Number");
            return false;
        }
        if(phoneNumber.getEditText().getText().toString().isEmpty()){
            validations.showAlert("Enter Valid phone Number");
            return false;
        }
        if(emailid.getEditText().getText().toString().isEmpty()){
            validations.showAlert("Enter Valid Email");
            return false;
        }
        if(address.getEditText().getText().toString().isEmpty()){
            validations.showAlert("Enter Valid Address");
            return false;
        }
        if(webAddress.getEditText().getText().toString().isEmpty()){
            validations.showAlert("Enter Valid Web Address");
            return false;
        }
        return true;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                closeKeyboard();
                if(isValid()) {
                    checkCompanyName(true);
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkCompanyName(final boolean goNext){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("name",companyName.getEditText().getText().toString().trim());
        if(id!=null){
            params.put("id",id);
        }
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.CHECK_CLIENTNAME, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(!jsonObject.getBoolean("exists")){
                        if(goNext){
                            if(id!=null){
                                updateClient();
                            }else {
                                addClient();
                            }
                        }
                    }else{
                        Validations.getInstance(AddClientActivity.this).showAlert("Client Company Name Already Exists");
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addClient(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("cname",preference.getCompanyName());
        params.put("mail",preference.getEmailId());
        params.put("type",preference.getCompnayType());
        if(preference.isAdmin()){
            params.put("role","admin");
        }else{
            params.put("role","project");
        }
        params.put("name",companyName.getEditText().getText().toString().trim());
        params.put("mobile",mobileNumber.getEditText().getText().toString().trim());
        params.put("phone",phoneNumber.getEditText().getText().toString().trim());
        params.put("email",emailid.getEditText().getText().toString().trim());
        params.put("address",address.getEditText().getText().toString().trim());
        params.put("web",webAddress.getEditText().getText().toString().trim());
        params.put("rnmae",rname.getEditText().getText().toString().trim());
        params.put("rmobile",rmobile.getEditText().getText().toString().trim());
        params.put("rmail",rmail.getEditText().getText().toString().trim());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ADD_CLINET, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Client Added Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Add Client",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateClient(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("mail",preference.getEmailId());
        params.put("type",preference.getCompnayType());
        if(preference.isAdmin()){
            params.put("role","admin");
        }else{
            params.put("role","project");
        }
        params.put("name",companyName.getEditText().getText().toString().trim());
        params.put("mobile",mobileNumber.getEditText().getText().toString().trim());
        params.put("phone",phoneNumber.getEditText().getText().toString().trim());
        params.put("email",emailid.getEditText().getText().toString().trim());
        params.put("address",address.getEditText().getText().toString().trim());
        params.put("web",webAddress.getEditText().getText().toString().trim());
        params.put("rnmae",rname.getEditText().getText().toString().trim());
        params.put("rmobile",rmobile.getEditText().getText().toString().trim());
        params.put("rmail",rmail.getEditText().getText().toString().trim());

        if(id!=null){
            params.put("id",id);
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.UPDATE_CLINET, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Clinet Details Updated Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Update",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void closeKeyboard() {
        InputMethodManager inputManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        inputManager.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);

    }
}
