package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.DialogInterface;
import android.content.Intent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AddMilestoneActivity extends AppCompatActivity {

    EditText milestoneName,milestoneDescription;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    private final int TAG_REQUEST_CODE=22,RESPONSIBLE_REQUEST_CODE=24;
    TextView selectedTag,startDate,endDate,responsiblePerson;
    Calendar calendarStart=Calendar.getInstance(),calendarEnd=Calendar.getInstance();
    JSONObject jsonObject=new JSONObject();
    String projectId,milestoneId;
    private boolean projectEdited=false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_addmilestone);
        getWidgets();
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        projectId=getIntent().getStringExtra("id");



        if(getIntent().getStringExtra("milestone")!=null){
            getSupportActionBar().setTitle("Edit Milestone");
            milestoneId=getIntent().getStringExtra("milestone");
            try {
                setValues();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }else{
            getSupportActionBar().setTitle("New Milestone");
            try {
                jsonObject.put("tag","");
                jsonObject.put("responsible","");
                jsonObject.put("end","");
                jsonObject.put("start","");
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void setValues() throws Exception {
        Database database=Database.getInstance(this);
        JSONObject json=database.getMilestoneDetails(milestoneId);
        startDate.setText(json.getString(MilestoneTable.STARTDATE));
        endDate.setText(json.getString(MilestoneTable.ENDDATE));
        selectedTag.setText(database.getTagName(json.getString(MilestoneTable.TAG)));
        responsiblePerson.setText(database.getEmployeeName(json.getString(MilestoneTable.RESPONSIBLEPERSON)));
        milestoneName.setText(json.getString(MilestoneTable.NAME));
        milestoneDescription.setText(json.getString(MilestoneTable.DESCRIPTION));
        try {
            jsonObject.put("tag",json.getString(MilestoneTable.TAG));
            jsonObject.put("responsible",json.getString(MilestoneTable.RESPONSIBLEPERSON));
            jsonObject.put("end",json.getString(MilestoneTable.ENDDATE));
            jsonObject.put("start",json.getString(MilestoneTable.STARTDATE));
            jsonObject.put("des",json.getString(MilestoneTable.DESCRIPTION));
            jsonObject.put("name",json.getString(MilestoneTable.NAME));
            calendarStart.setTime(DateUtils.fromDate(jsonObject.getString("start")));
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    private void getWidgets(){
        milestoneName=findViewById(R.id.milestoneName);
        coordinatorLayout=findViewById(R.id.coordinatorLayout);
        selectedTag=findViewById(R.id.selectedTag);
        startDate=findViewById(R.id.startDate);
        endDate=findViewById(R.id.endDate);
        responsiblePerson=findViewById(R.id.responsiblePerson);
        milestoneDescription=findViewById(R.id.milestoneDescription);

        milestoneName.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if(!hasFocus){
                    if(!milestoneName.getText().toString().isEmpty()){
                        checkMilestoneName(false);
                    }
                }
            }
        });



        findViewById(R.id.tagLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectTagActivity.class),TAG_REQUEST_CODE);
            }
        });


        findViewById(R.id.responsibleLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectEmployeeActivity.class),RESPONSIBLE_REQUEST_CODE);
            }
        });

        findViewById(R.id.startDateLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectStartDate();
            }
        });

        findViewById(R.id.endDateLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectEndDate();
            }
        });

    }

    private void selectStartDate()  {

        DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                calendarStart.set(Calendar.YEAR, year);
                calendarStart.set(Calendar.MONTH, monthOfYear);
                calendarStart.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "yyyy-MM-dd"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                startDate.setText(sdf.format(calendarStart.getTime()));
                try {
                    jsonObject.put("start",new SimpleDateFormat("yyyy-MM-dd",Locale.getDefault()).format(calendarStart.getTime()));
                    if(calendarEnd.getTimeInMillis()<calendarStart.getTimeInMillis()){
                        endDate.setText("");
                        jsonObject.put("end","");
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }

        };
        DatePickerDialog datePicker =  new DatePickerDialog(this, fromDate, calendarStart
                .get(Calendar.YEAR), calendarStart.get(Calendar.MONTH),
                calendarStart.get(Calendar.DAY_OF_MONTH));
        datePicker.setTitle("Start Date");
        try {
            JSONObject projectJSON=Database.getInstance(this).getProjectDetails(projectId);
            datePicker.getDatePicker().setMinDate(DateUtils.fromDate(projectJSON.getString(ProjectTable.STARTDATE)).getTime());
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (JSONException e) {
            e.printStackTrace();
        }
        datePicker.show();
    }

    private void selectEndDate(){
        final DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                calendarEnd.set(Calendar.YEAR, year);
                calendarEnd.set(Calendar.MONTH, monthOfYear);
                calendarEnd.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "yyyy-MM-dd"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                endDate.setText(sdf.format(calendarEnd.getTime()));
                //edittext.setText(sdf.format(myCalendar.getTime()));
                try {
                    jsonObject.put("end",new SimpleDateFormat("yyyy-MM-dd",Locale.getDefault()).format(calendarEnd.getTime()));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

        };
        if(startDate.getText().toString().isEmpty()){
            Toast.makeText(getApplicationContext(),"Select from Date",Toast.LENGTH_SHORT).show();
            return;
        }

        DatePickerDialog datePicker = new DatePickerDialog(this, toDate, calendarEnd
                .get(Calendar.YEAR), calendarEnd.get(Calendar.MONTH),
                calendarEnd.get(Calendar.DAY_OF_MONTH));
        datePicker.getDatePicker().setMinDate(calendarStart.getTimeInMillis());
        datePicker.setTitle("End Date");
        datePicker.show();
    }

    private void checkMilestoneName(final boolean goNext){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("name",milestoneName.getText().toString().trim());
        params.put("id",projectId);
        if(milestoneId!=null) {
            params.put("milestone", milestoneId);
        }
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.CHECK_MILESTONENAME, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(!jsonObject.getBoolean("exists")){
                        if(goNext){
                            if(milestoneId==null) {
                                addMilestone();
                            }else{
                                updateMilestone();
                        }
                        }
                    }else{
                        Validations.getInstance(AddMilestoneActivity.this).showAlert("Milestone Name Already Exists");
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addMilestone(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        try {
            jsonObject.put("des",milestoneDescription.getText().toString());
            jsonObject.put("name",milestoneName.getText().toString());
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }
            jsonObject.put("id",projectId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ADD_MILESTONE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        Toast.makeText(getApplicationContext(),"Milstone Added Successfully",Toast.LENGTH_SHORT).show();
                        checkProjectUpdated();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Add Milestone ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void updateMilestone(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        try {
            jsonObject.put("des",milestoneDescription.getText().toString());
            jsonObject.put("name",milestoneName.getText().toString());
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }
            jsonObject.put("id",projectId);
            jsonObject.put("milestoneid",milestoneId);

        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.UPDATE_MILESTONE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Milstone Updated Successfully",Toast.LENGTH_SHORT).show();
                        checkProjectUpdated();
                    }else{

                        Toast.makeText(getApplicationContext(),jsonObject.getString("m"),Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private boolean isValid(){
        Validations validations=Validations.getInstance(this);
        if(milestoneName.getText().toString().isEmpty()){
            validations.showAlert("Enter Task Name");
            return false;
        }
        if(milestoneDescription.getText().toString().isEmpty()){
            validations.showAlert("Fill Description");
            return false;
        }
        try {
            if(jsonObject.getString("responsible").isEmpty()){
                validations.showAlert("Select Resposible Person");
                return false;
            }
            if(jsonObject.getString("start").isEmpty()){
                validations.showAlert("Select Start Date");
                return false;
            }

            if(jsonObject.getString("end").isEmpty()){
                validations.showAlert("Select End Date");
                return false;
            }else{
                JSONObject projectJSON=Database.getInstance(this).getProjectDetails(projectId);
                int difference=DateUtils.fromDate(jsonObject.getString("end"))
                        .compareTo(DateUtils.fromDate(projectJSON.getString(ProjectTable.ENDDATE)));
                if(difference>0){
                    projectEdited=true;
                    showAlert(projectJSON.getString(ProjectTable.ENDDATE));
                    return false;
                }else{
                    projectEdited=false;
                    return true;
                }
            }


        } catch (JSONException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return true;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(isValid()) {
                    checkMilestoneName(true);
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if(resultCode==RESULT_OK){
            switch(requestCode){
                case TAG_REQUEST_CODE:
                    selectedTag.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("tag",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case RESPONSIBLE_REQUEST_CODE:
                    responsiblePerson.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("responsible",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
            }
        }
    }

    private void showAlert(String deadline){
        new AlertDialog.Builder(this).setMessage("Selected end date is after the project deadline("+deadline+"). " +
                "Project deadline will be extended respectively.")
                .setPositiveButton("CONTINUE", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // FIRE ZE MISSILES!
                        checkMilestoneName(true);
                    }
                })
                .setNegativeButton("CLOSE", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {

                    }
                }).show();
    }

    private void getProjectsDetails(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("id",projectId);
        params.put("list", Database.getInstance(this).getProjectsList().toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_PROJECTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getProjects(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getProjects(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray=jsonObject.getJSONArray("projects");
        try {
            Database.getInstance(this).insertProjects(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        finish();
    }

    private void checkProjectUpdated(){
        if(projectEdited){
            getProjectsDetails();
        }else{
            finish();
        }
    }

}
