package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.DatePickerDialog;
import android.content.Intent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.appcompat.widget.SwitchCompat;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AddProjectActivity extends AppCompatActivity {

    EditText projectName,projectDescription;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    private final int TAG_REQUEST_CODE=22,CAT_REQUEST_CODE=21,COMPNAY_REQUEST_CODE=23,RESPONSIBLE_REQUEST_CODE=24;
    TextView selectedTag,selectedCategoty,startDate,endDate,otherCompany,responsiblePerson;
    Calendar calendarStart=Calendar.getInstance(),calendarEnd=Calendar.getInstance();
    SwitchCompat isIntenalProject;
    JSONObject jsonObject=new JSONObject(),defaultJSON=new JSONObject();
    String projectId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_addproject);
        getWidgets();
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        if(getIntent().getStringExtra("id")==null) {
            getSupportActionBar().setTitle("New Project");
            try {
                jsonObject.put("tag","");
                jsonObject.put("cat","");
                jsonObject.put("responsible","");
                jsonObject.put("companyid","");
                jsonObject.put("end","");
                jsonObject.put("start","");
                jsonObject.put("client","1");
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }else{
            projectId=getIntent().getStringExtra("id");
            getSupportActionBar().setTitle("Edit Project");
            try {
                setValues();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

    }

    private void setValues() throws JSONException {
        Database database=Database.getInstance(this);
        JSONObject jsonObject= Database.getInstance(this).getProjectDetails(projectId);
        projectName.setText(jsonObject.getString(ProjectTable.PROJECTNAME));
        projectDescription.setText(jsonObject.getString(ProjectTable.DESCRIPTION));
        if(database.getTagName(jsonObject.getString(ProjectTable.TAGID)).isEmpty()){
            selectedTag.setText("Tap to Select");
        }else {
            selectedTag.setText(database.getTagName(jsonObject.getString(ProjectTable.TAGID)));
        }

        if(database.getCategoryName(jsonObject.getString(ProjectTable.CATID)).isEmpty()){
            selectedCategoty.setText("Tap to Select");
        }else {
            selectedCategoty.setText(database.getCategoryName(jsonObject.getString(ProjectTable.CATID)));
        }

        if(jsonObject.getString(ProjectTable.CLIENT).equalsIgnoreCase("0")){
            isIntenalProject.setChecked(true);
            otherCompany.setVisibility(View.GONE);
            otherCompany.setText("Tap to Select");
            this.jsonObject.put("client","0");
            this.jsonObject.put("companyid","Ours");
        }else{
            this.jsonObject.put("client","1");
            this.jsonObject.put("companyid",jsonObject.getString(ProjectTable.CLIENTCOMPANYID));
            isIntenalProject.setChecked(false);
            otherCompany.setText(database.getClientName(jsonObject.getString(ProjectTable.CLIENTCOMPANYID)));
        }
        responsiblePerson.setText(database.getEmployeeName(jsonObject.getString(ProjectTable.RESPONSIBLEPERSON)));
        startDate.setText(jsonObject.getString(ProjectTable.STARTDATE));
        endDate.setText(jsonObject.getString(ProjectTable.ENDDATE));
        this.jsonObject.put("tag",jsonObject.getString(ProjectTable.TAGID));
        this.jsonObject.put("cat",jsonObject.getString(ProjectTable.CATID));
        this.jsonObject.put("responsible",jsonObject.getString(ProjectTable.RESPONSIBLEPERSON));
        this.jsonObject.put("end",jsonObject.getString(ProjectTable.STARTDATE));
        this.jsonObject.put("start",jsonObject.getString(ProjectTable.ENDDATE));
        this.jsonObject.put("des",jsonObject.getString(ProjectTable.DESCRIPTION));
        this.jsonObject.put("name",jsonObject.getString(ProjectTable.PROJECTNAME));
        defaultJSON=jsonObject;
    }

    private void getWidgets(){
        projectName=findViewById(R.id.projectName);
        coordinatorLayout=findViewById(R.id.coordinatorLayout);
        selectedTag=findViewById(R.id.selectedTag);
        selectedCategoty=findViewById(R.id.selectedCategoty);
        startDate=findViewById(R.id.startDate);
        endDate=findViewById(R.id.endDate);
        otherCompany=findViewById(R.id.otherCompany);
        responsiblePerson=findViewById(R.id.responsiblePerson);
        projectDescription=findViewById(R.id.projectDescription);

        isIntenalProject=findViewById(R.id.isIntenalProject);

        projectName.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if(!hasFocus){
                    if(!projectName.getText().toString().isEmpty()){
                        checkProjectName(false);
                    }
                }
            }
        });

        isIntenalProject.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if(isChecked){
                    findViewById(R.id.otherCompanyLayout).setVisibility(View.GONE);
                    findViewById(R.id.divider).setVisibility(View.GONE);
                    try {
                        jsonObject.put("client","0");
                        jsonObject.put("companyid","Ours");
                        otherCompany.setText("Tap to Select");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                }else{
                    findViewById(R.id.otherCompanyLayout).setVisibility(View.VISIBLE);
                    findViewById(R.id.divider).setVisibility(View.VISIBLE);
                    try {
                        jsonObject.put("client","1");
                        jsonObject.put("companyid","Ours");
                        otherCompany.setText("");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });

        findViewById(R.id.tagLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectTagActivity.class),TAG_REQUEST_CODE);
            }
        });

        findViewById(R.id.categoryLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectCategoryActivity.class),CAT_REQUEST_CODE);
            }
        });

        findViewById(R.id.otherCompanyLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectCompanyActivity.class),COMPNAY_REQUEST_CODE);
            }
        });

        findViewById(R.id.responsibleLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectEmployeeActivity.class),RESPONSIBLE_REQUEST_CODE);
            }
        });

        findViewById(R.id.startDateLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectStartDate();
            }
        });

        findViewById(R.id.endDateLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectEndDate();
            }
        });

    }

    private void checkProjectName(final boolean goNext){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("pname",projectName.getText().toString().trim());
        if(projectId!=null){
            params.put("id",projectId);
        }
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.CHECK_PROJECTNAME, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(!jsonObject.getBoolean("exists")){
                        if(goNext){
                            if(projectId==null) {
                                addProject();
                            }else{
                                updateProject();
                            }
                        }
                    }else{
                        Validations.getInstance(AddProjectActivity.this).showAlert("Project Name Already Exists");
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if(resultCode==RESULT_OK){
            switch(requestCode){
                case TAG_REQUEST_CODE:
                    selectedTag.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("tag",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case CAT_REQUEST_CODE:
                    selectedCategoty.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("cat",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case COMPNAY_REQUEST_CODE:
                    otherCompany.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("companyid",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case RESPONSIBLE_REQUEST_CODE:
                    responsiblePerson.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("responsible",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
            }
        }
    }

    private void selectStartDate(){
        DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                calendarStart.set(Calendar.YEAR, year);
                calendarStart.set(Calendar.MONTH, monthOfYear);
                calendarStart.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "dd/MM/yyyy"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                startDate.setText(sdf.format(calendarStart.getTime()));
                try {
                    jsonObject.put("start",new SimpleDateFormat("yyyy-MM-dd",Locale.getDefault()).format(calendarStart.getTime()));
                    if(calendarEnd.getTimeInMillis()<calendarStart.getTimeInMillis()){
                        endDate.setText("");
                        jsonObject.put("end","");
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }

        };
        DatePickerDialog datePicker =  new DatePickerDialog(this, fromDate, calendarStart
                        .get(Calendar.YEAR), calendarStart.get(Calendar.MONTH),
                        calendarStart.get(Calendar.DAY_OF_MONTH));
        datePicker.setTitle("Start Date");
        datePicker.show();
    }

    private void selectEndDate(){
        final DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                calendarEnd.set(Calendar.YEAR, year);
                calendarEnd.set(Calendar.MONTH, monthOfYear);
                calendarEnd.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "dd/MM/yyyy"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                endDate.setText(sdf.format(calendarEnd.getTime()));
                //edittext.setText(sdf.format(myCalendar.getTime()));
                try {
                    jsonObject.put("end",new SimpleDateFormat("yyyy-MM-dd",Locale.getDefault()).format(calendarEnd.getTime()));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

        };
        if(startDate.getText().toString().isEmpty()){
            Toast.makeText(getApplicationContext(),"Select from Date",Toast.LENGTH_SHORT).show();
            return;
        }

        DatePickerDialog datePicker = new DatePickerDialog(this, toDate, calendarEnd
                .get(Calendar.YEAR), calendarEnd.get(Calendar.MONTH),
                calendarEnd.get(Calendar.DAY_OF_MONTH));
        datePicker.getDatePicker().setMinDate(calendarStart.getTimeInMillis());
        datePicker.setTitle("End Date");
        datePicker.show();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(isValid()) {
                    checkProjectName(true);
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void addProject(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("mail",preference.getEmailId());
        params.put("type",preference.getCompnayType());
        if(preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        }else{
            params.put("role","project");
        }
        try {
            jsonObject.put("des",projectDescription.getText().toString());
            jsonObject.put("name",projectName.getText().toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());




        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ADD_PROJECT, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        Toast.makeText(getApplicationContext(),"Project Created Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Create Project",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void updateProject(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("mail",preference.getEmailId());
        params.put("type",preference.getCompnayType());
        if(projectId!=null){
            params.put("id",projectId);
        }
        if(preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        }else{
            params.put("role","project");
        }

        try {
            jsonObject.put("des",projectDescription.getText().toString());
            jsonObject.put("name",projectName.getText().toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        if(defaultJSON.toString().equalsIgnoreCase(jsonObject.toString())){
            Toast.makeText(getApplicationContext(),"Project Updated Successfully",Toast.LENGTH_SHORT).show();
            finish();
        }
        params.put("data",jsonObject.toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.UPDATE_PROJECT, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Project Updated Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Update Project",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private boolean isValid(){

        Validations validations=Validations.getInstance(this);

        if(projectName.getText().toString().isEmpty()){
            validations.showAlert("Enter Project Name");
            return false;
        }

        if(projectDescription.getText().toString().isEmpty()){
            validations.showAlert("Fill Description");
            return false;
        }
        try {
            if(jsonObject.getString("responsible").isEmpty()){
                validations.showAlert("Select Resposible Person");
                return false;
            }

            if(jsonObject.getString("start").isEmpty()){
                validations.showAlert("Select Start Date");
                return false;
            }
            if(jsonObject.getString("end").isEmpty()){
                validations.showAlert("Select End Date");
                return false;
            }
            if(jsonObject.getString("client").equalsIgnoreCase("1") && jsonObject.getString("companyid").isEmpty()){
                validations.showAlert("Select Company");
                return false;
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return true;
    }



}
