package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TagTable;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class AddTagActivity extends AppCompatActivity {

    EditText tagName;
    Spinner weightage;
    String id;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_add_tag);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        id=getIntent().getStringExtra("id");
        tagName=findViewById(R.id.tagName);
        weightage=findViewById(R.id.weightage);
        weightage.setMinimumHeight(tagName.getHeight());
        if(id!=null){
            getSupportActionBar().setTitle("Edit Tag");
            try {
                setValues();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }else{
            getSupportActionBar().setTitle("New Tag");
        }

    }

    private void setValues() throws JSONException {
        Database database= Database.getInstance(this);
        JSONObject jsonObject= database.getTagDetails(id);
        tagName.setText(jsonObject.getString(TagTable.TAGNAME));
        weightage.setSelection(jsonObject.getInt(TagTable.WEIGHTAGE)-1);

    }

    private void checkTagName(final boolean goNext){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("name",tagName.getText().toString().trim());
        if(id!=null){
            params.put("id",id);
        }
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.CHECK_TAGNAME, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(!jsonObject.getBoolean("exists")){
                        if(goNext){
                            if(id!=null){
                                updateTag();
                            }else {
                                addTag();
                            }
                        }
                    }else{
                        Validations.getInstance(AddTagActivity.this).showAlert("Tag Name Already Exists");
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addTag(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role","admin");
            }else{
                jsonObject.put("role","project");
            }
            jsonObject.put("wieghtage",weightage.getSelectedItem().toString());
            jsonObject.put("name",tagName.getText().toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ADD_TAG, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Tag Created Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Create Tag",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void updateTag(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role","admin");
            }else{
                jsonObject.put("role","project");
            }
            jsonObject.put("wieghtage",weightage.getSelectedItem().toString());
            jsonObject.put("name",tagName.getText().toString());
            jsonObject.put("id",id);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.UPDATE_TAG, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Tag Updated Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Update Tag",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private boolean isValid(){

        Validations validations=Validations.getInstance(this);

        if(tagName.getText().toString().isEmpty()){
            validations.showAlert("Enter Name");
            return false;
        }
        return true;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(isValid()) {
                    checkTagName(true);
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
