package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.DatePickerDialog;
import android.content.DialogInterface;
import android.content.Intent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AddTaskActivity extends AppCompatActivity {

    EditText taskName,taskDescription;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    private final int TAG_REQUEST_CODE=22,PROJECT_REQUEST_CODE=21,TASKLIST_REQUEST_CODE=23,RESPONSIBLE_REQUEST_CODE=24;
    TextView selectedTag,selectedProject,startDate,endDate,selectedTasklist,assignedPerson,priority;
    Calendar calendarStart=Calendar.getInstance(),calendarEnd=Calendar.getInstance();
    JSONObject jsonObject=new JSONObject();
    String projectId,taskId,employeeId="",assignId="";
    private boolean projectEdited=false,milestoneEdited=false;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_addtask);
        projectId=getIntent().getStringExtra("id");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getWidgets();
        if(getIntent().getStringExtra("taskId")!=null){
            taskId=getIntent().getStringExtra("taskId");
            try {
                setValues();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }else{
            getSupportActionBar().setTitle("New Task");
            try {
                jsonObject.put("project","");
                jsonObject.put("tag","");
                jsonObject.put("tasklist","");
                jsonObject.put("assignedTo","");
                jsonObject.put("priority","");
                jsonObject.put("end","");
                jsonObject.put("start","");
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        setListeners();

    }

    private void setValues() throws Exception {
        Database database=Database.getInstance(this);
        JSONObject json=database.getTaskDetails(taskId);
        taskName.setText(json.getString(TaskTable.NAME));
        taskDescription.setText(json.getString(TaskTable.DESCRIPTION));
        startDate.setText(json.getString(TaskTable.STARTDATE));
        endDate.setText(json.getString(TaskTable.ENDDATE));
        priority.setText(json.getString(TaskTable.PRIORITY));
        try {
            if (!json.getString(AssignTable.EMPLYOEEID).equalsIgnoreCase("null")) {
                assignedPerson.setText(database.getEmployeeName(json.getString(AssignTable.EMPLYOEEID)));
                employeeId = json.getString(AssignTable.EMPLYOEEID);
                assignId = json.getString(AssignTable.ASSIGNID);
                jsonObject.put("assignedTo",json.getString(AssignTable.EMPLYOEEID));
            }
        }catch (JSONException e){
            e.printStackTrace();
            jsonObject.put("assignedTo","");
        }

        selectedTasklist.setText(database.getTaskListName(json.getString(TaskTable.LISTTASKID)));
        selectedProject.setText(database.getProjectName(json.getString(TaskTable.PROJECTID)));
        selectedTag.setText(database.getTagName(json.getString(TaskTable.TAG)));
        jsonObject.put("project",json.getString(TaskTable.PROJECTID));
        jsonObject.put("tag",json.getString(TaskTable.TAG));
        jsonObject.put("tasklist",json.getString(TaskTable.LISTTASKID));
        jsonObject.put("priority",json.getString(TaskTable.PRIORITY));
        jsonObject.put("end",json.getString(TaskTable.ENDDATE));
        jsonObject.put("start",json.getString(TaskTable.STARTDATE));
        jsonObject.put("name",json.getString(TaskTable.NAME));
        jsonObject.put("des",json.getString(TaskTable.DESCRIPTION));
        calendarStart.setTime(DateUtils.fromDate(jsonObject.getString("start")));

    }

    private void getWidgets(){
        taskName=findViewById(R.id.taskName);
        coordinatorLayout=findViewById(R.id.coordinatorLayout);
        selectedTag=findViewById(R.id.selectedTag);
        selectedProject=findViewById(R.id.selectedProject);
        startDate=findViewById(R.id.startDate);
        endDate=findViewById(R.id.endDate);
        selectedTasklist=findViewById(R.id.selectedTasklist);
        assignedPerson=findViewById(R.id.assignedPerson);
        priority=findViewById(R.id.priority);
        taskDescription=findViewById(R.id.taskDescription);
    }

    private void setListeners(){
        findViewById(R.id.tagLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectTagActivity.class),TAG_REQUEST_CODE);
            }
        });

        if(projectId.isEmpty()){
            findViewById(R.id.projectLayout).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent=new Intent(getApplicationContext(), SelectCategoryActivity.class);
                    intent.putExtra("id",projectId);
                    startActivityForResult(intent,PROJECT_REQUEST_CODE);
                }
            });
        }else{
            try {
                jsonObject.put("project",projectId);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            selectedProject.setText(Database.getInstance(this).getProjectName(projectId));
        }

        findViewById(R.id.tasklistLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent=new Intent(getApplicationContext(), SelectTasklistActivity.class);
                intent.putExtra("id",projectId);
                intent.putExtra("return",true);
                if(taskId==null) {
                    startActivityForResult(intent, TASKLIST_REQUEST_CODE);
                }
            }
        });

        findViewById(R.id.assignedLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectEmployeeActivity.class),RESPONSIBLE_REQUEST_CODE);
            }
        });

        findViewById(R.id.startDateLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectStartDate();
            }
        });

        findViewById(R.id.endDateLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectEndDate();
            }
        });

        findViewById(R.id.priorityLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectPriority();
            }
        });
    }

    private void selectStartDate(){
        DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                calendarStart.set(Calendar.YEAR, year);
                calendarStart.set(Calendar.MONTH, monthOfYear);
                calendarStart.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                startDate.setText(sdf.format(calendarStart.getTime()));
                try {
                    jsonObject.put("start",sdf.format(calendarStart.getTime()));
                    if(calendarEnd.getTimeInMillis()<calendarStart.getTimeInMillis()){
                        endDate.setText("");
                        jsonObject.put("end","");
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }

        };
        DatePickerDialog datePicker =  new DatePickerDialog(this, fromDate, calendarStart
                .get(Calendar.YEAR), calendarStart.get(Calendar.MONTH),
                calendarStart.get(Calendar.DAY_OF_MONTH));
        datePicker.setTitle("Start Date");
        datePicker.show();
    }

    private void selectEndDate(){
        final DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                calendarEnd.set(Calendar.YEAR, year);
                calendarEnd.set(Calendar.MONTH, monthOfYear);
                calendarEnd.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "yyyy-MM-dd"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.getDefault());
                endDate.setText(sdf.format(calendarEnd.getTime()));
                //edittext.setText(sdf.format(myCalendar.getTime()));
                try {
                    jsonObject.put("end",sdf.format(calendarEnd.getTime()));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

        };
        if(startDate.getText().toString().isEmpty()){
            Toast.makeText(getApplicationContext(),"Select from Date",Toast.LENGTH_SHORT).show();
            return;
        }

        DatePickerDialog datePicker = new DatePickerDialog(this, toDate, calendarEnd
                .get(Calendar.YEAR), calendarEnd.get(Calendar.MONTH),
                calendarEnd.get(Calendar.DAY_OF_MONTH));
        datePicker.getDatePicker().setMinDate(calendarStart.getTimeInMillis());
        datePicker.setTitle("End Date");
        datePicker.show();
    }

    private void selectPriority(){
        final AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this);

        LayoutInflater inflater = this.getLayoutInflater();
        final View dialogView= inflater.inflate(R.layout.alert_priority, null);
        dialogBuilder.setView(dialogView);
        final AlertDialog alertDialog=dialogBuilder.create();

        RadioButton priorityHigh=dialogView.findViewById(R.id.priorityHigh);
        RadioButton priorityMedium=dialogView.findViewById(R.id.priorityMedium);
        RadioButton priorityLow=dialogView.findViewById(R.id.priorityLow);

        priorityHigh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.hide();
                priority.setText(R.string.priority_high);
                try {
                    jsonObject.put("priority","High");
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

        priorityMedium.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.hide();
                priority.setText(R.string.priority_medium);
                try {
                    jsonObject.put("priority","Medium");
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }
        });
        priorityLow.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.hide();
                priority.setText(R.string.priority_low);
                try {
                    jsonObject.put("priority","Low");
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }
        });

        alertDialog.show();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if(resultCode==RESULT_OK){
            switch(requestCode){
                case TAG_REQUEST_CODE:
                    selectedTag.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("tag",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case PROJECT_REQUEST_CODE:
                    selectedProject.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("project",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case TASKLIST_REQUEST_CODE:
                    selectedTasklist.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("tasklist",data.getStringExtra("id"));
                        jsonObject.put("milestone",data.getStringExtra("milestone"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case RESPONSIBLE_REQUEST_CODE:
                    assignedPerson.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("assignedTo",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(isValid()) {
                    checkTaskName(true);
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private boolean isValid(){
        Validations validations=Validations.getInstance(this);

        if(taskName.getText().toString().isEmpty()){
            validations.showAlert("Enter Task Name");
            return false;
        }
        if(taskDescription.getText().toString().isEmpty()){
            validations.showAlert("Fill Description");
            return false;
        }
        try {
            if(jsonObject.getString("tasklist").isEmpty()){
                validations.showAlert("Select TaskList");
                return false;
            }
            if(jsonObject.getString("priority").isEmpty()){
                validations.showAlert("Choose Priority");
                return false;
            }



            if(jsonObject.getString("start").isEmpty()){
                validations.showAlert("Provide Start Date");
                return false;
            }
            if(jsonObject.getString("end").isEmpty()){
                validations.showAlert("Provide End Date");
                return false;
            }else{
                JSONObject projectJSON=Database.getInstance(this).getProjectDetails(projectId);
                JSONObject milestonJSON=Database.getInstance(this).getMilestoneDetails(jsonObject.getString("milestone"));

                Date projectEnddate= DateUtils.fromDate(projectJSON.getString(ProjectTable.ENDDATE));
                Date milestoneEnddate= DateUtils.fromDate(milestonJSON.getString(MilestoneTable.ENDDATE));
                Date enddate=calendarEnd.getTime();
                if(milestoneEnddate.before(enddate)){
                    milestoneEdited=true;
                    if(projectEnddate.before(enddate)){
                        String str="Selected end date is after the project deadline("+projectJSON.getString(ProjectTable.ENDDATE)
                                +") and milestone deadline("+milestonJSON.getString(MilestoneTable.ENDDATE)+"), Both deadlines will be extended";
                        showAlert(str);
                        projectEdited=true;
                    }else{
                        String str="Selected end date is after the milestone deadline("+milestonJSON.getString(MilestoneTable.ENDDATE)
                                +"). Milestone deadline will be extended";
                        showAlert(str);
                        projectEdited=false;
                    }
                    return false;
                }else{
                    milestoneEdited=false;
                }


            }

        } catch (JSONException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return true;
    }

    private void checkTaskName(final boolean goNext){
        Map<String, String> params = new HashMap<String, String>();
        params.put("name",taskName.getText().toString().trim());
        try {
            params.put("id",jsonObject.getString("tasklist"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        if(taskId!=null){
            params.put("taskId",taskId);
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.CHECK_TASKNAME, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(!jsonObject.getBoolean("exists")){
                        if(goNext){
                            if(taskId==null) {
                                addTask();
                            }else{
                                updateTask();
                            }
                        }
                    }else{
                        Validations.getInstance(AddTaskActivity.this).showAlert("Task Name Already Exists");
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addTask(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        try {
            jsonObject.put("name",taskName.getText().toString());
            jsonObject.put("des",taskDescription.getText().toString());
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ADD_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json=new JSONObject(response);
                    if(json.getInt("s")==1){
                        if(!jsonObject.getString("assignedTo").isEmpty()){
                            assignTask(jsonObject.getString("assignedTo"),json.getString("id"),"Task Added Successfully");
                        }else{
                            Toast.makeText(getApplicationContext(),"Task Added Successfully",Toast.LENGTH_SHORT).show();
                          checkUpdates();
                        }

                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Add Task ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void assignTask(String employeeid, String taskId, final String message){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("taskId",taskId);
            jsonObject.put("assignedTo",employeeid);
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            jsonObject.put("role",preference.getDesignation());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ASSIGN_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),message,Toast.LENGTH_SHORT).show();
                    }
                    finish();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void updateTask(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        try {
            jsonObject.put("name",taskName.getText().toString());
            jsonObject.put("des",taskDescription.getText().toString());
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            jsonObject.put("employee",employeeId);
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }
            if(assignId!=null){
                jsonObject.put("assignId",assignId);
            }
            jsonObject.put("taskId",taskId);



        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.UPDATE_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json=new JSONObject(response);
                    if(json.getInt("s")==1){

                        if(!jsonObject.getString("assignedTo").isEmpty() && !jsonObject.getString("assignedTo").equalsIgnoreCase(employeeId)){
                            assignTask(jsonObject.getString("assignedTo"),taskId,"Task Updated Successfully");
                        }else{
                            Toast.makeText(getApplicationContext(),"Task Updated Successfully",Toast.LENGTH_SHORT).show();
                            checkUpdates();
                        }

                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Update Task ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void showAlert(String str){
        new android.app.AlertDialog.Builder(this).setMessage(str)
                .setPositiveButton("CONTINUE", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        // FIRE ZE MISSILES!
                        checkTaskName(true);
                    }
                })
                .setNegativeButton("CLOSE", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {

                    }
                }).show();
    }

    private void checkUpdates(){
        if(milestoneEdited){
            getMilestones();
        }else if(projectEdited){
            getProjectsDetails();
        }else{
            finish();
        }
    }

    private void getProjectsDetails(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("id",projectId);
        params.put("list", Database.getInstance(this).getProjectsList().toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_PROJECTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONArray jsonArray=jsonObject.getJSONArray("projects");
                    try {
                        Database.getInstance(getApplicationContext()).insertProjects(jsonArray);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    finish();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMilestones(){
        Preference preference=Preference.getInstance(this);
        Database database= Database.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("mail",preference.getEmailId());
        params.put("id",projectId);
        try {
            params.put("mid",jsonObject.getString("milestoneid"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_MILESTONES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    Database database=Database.getInstance(getApplicationContext());
                    JSONArray jsonArray=jsonObject.getJSONArray("list");
                    try {
                        database.insertMilestones(jsonArray);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    if(projectEdited){
                        getProjectsDetails();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }


}
