package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.content.Intent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class AddTaskListActivity extends AppCompatActivity {

    EditText tasklistName,tasklistDescription;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    private final int MILESTONE_REQUEST_CODE=22,RESPONSIBLE_REQUEST_CODE=24;
    TextView selectedMilestone,responsiblePerson;
    JSONObject jsonObject=new JSONObject();
    String projectId,tasklistId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_addtasklist);
        getWidgets();
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        projectId=getIntent().getStringExtra("id");
        if(getIntent().getStringExtra("tasklistId")!=null){
            tasklistId=getIntent().getStringExtra("tasklistId");
            try {
                setValues();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }else {
            getSupportActionBar().setTitle("New TaskList");
            try {
                jsonObject.put("milestone", "");
                jsonObject.put("responsible", "");
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void setValues() throws Exception {
        Database database=Database.getInstance(this);
        JSONObject json=database.getTasklsitDetails(tasklistId);
        selectedMilestone.setText(database.getMilestoneName(json.getString(TasklistTable.MILESTONEID)));
        responsiblePerson.setText(database.getEmployeeName(json.getString(TasklistTable.RESPONSIBLEPERSON)));
        tasklistName.setText(json.getString(TasklistTable.NAME));
        tasklistDescription.setText(json.getString(TasklistTable.DESCRIPTION));
        try {
            jsonObject.put("milestone",json.getString(TasklistTable.MILESTONEID));
            jsonObject.put("responsible",json.getString(TasklistTable.RESPONSIBLEPERSON));
            jsonObject.put("des",json.getString(TasklistTable.DESCRIPTION));
            jsonObject.put("name",json.getString(TasklistTable.NAME));
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    private void getWidgets(){
        tasklistName=findViewById(R.id.tasklistName);
        coordinatorLayout=findViewById(R.id.coordinatorLayout);
        selectedMilestone=findViewById(R.id.selectedMilestone);
        responsiblePerson=findViewById(R.id.responsiblePerson);
        tasklistDescription=findViewById(R.id.tasklistDescription);

        tasklistName.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if(!hasFocus){
                    if(!tasklistName.getText().toString().isEmpty()){
                        checkTasklistName(false);
                    }
                }
            }
        });

        findViewById(R.id.milstoneLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getApplicationContext(), SelectMilestoneActivity.class);
                intent.putExtra("id",projectId);
                startActivityForResult(intent,MILESTONE_REQUEST_CODE);
            }
        });


        findViewById(R.id.responsibleLayout).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(new Intent(getApplicationContext(), SelectEmployeeActivity.class),RESPONSIBLE_REQUEST_CODE);
            }
        });

    }

    private void checkTasklistName(final boolean goNext){
        Map<String, String> params = new HashMap<>();
        params.put("name",tasklistName.getText().toString().trim());
        params.put("id",projectId);
        if(tasklistId!=null){
            params.put("listtask",tasklistId);
        }

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.CHECK_TASKLISTNAME, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(!jsonObject.getBoolean("exists")){
                        if(goNext){
                            if(tasklistId==null) {
                                addTasklist();
                            }else{
                                updateTasklist();
                            }
                        }
                    }else{
                        Validations.getInstance(AddTaskListActivity.this).showAlert("Tasklist Name Already Exists");
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addTasklist(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        try {
            jsonObject.put("des",tasklistDescription.getText().toString());
            jsonObject.put("name",tasklistName.getText().toString());
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            jsonObject.put("id",projectId);
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ADD_TASKLIST, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        Toast.makeText(getApplicationContext(),"Tasklist Added Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Add Tasklist ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void updateTasklist(){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        try {
            jsonObject.put("des",tasklistDescription.getText().toString());
            jsonObject.put("name",tasklistName.getText().toString());
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            jsonObject.put("id",projectId);
            jsonObject.put("tasklist",tasklistId);
            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.UPDATE_TASKLIST, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Tasklist Updated Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Update Tasklist ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private boolean isValid(){
        Validations validations=Validations.getInstance(this);

        if(tasklistName.getText().toString().isEmpty()){
            validations.showAlert("Enter Name");
            return false;
        }

        if(tasklistDescription.getText().toString().isEmpty()){
            validations.showAlert("Fill Description");
            return false;
        }

        try {
            if(jsonObject.getString("responsible").isEmpty()){
                validations.showAlert("Select Resposible Person");
                return false;
            }

            if(jsonObject.getString("milestone").isEmpty()){
                validations.showAlert("Select Milestone");
                return false;
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return true;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(isValid()) {
                    checkTasklistName(true);
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if(resultCode==RESULT_OK){
            switch(requestCode){
                case MILESTONE_REQUEST_CODE:
                    selectedMilestone.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("milestone",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case RESPONSIBLE_REQUEST_CODE:
                    responsiblePerson.setText(data.getStringExtra("name"));
                    try {
                        jsonObject.put("responsible",data.getStringExtra("id"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
            }
        }
    }


}
