package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.content.DialogInterface;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.AssignTable;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ReduceProgressActivity extends AppCompatActivity {

    EditText reasonText;
    TextView taskName,completedPercentage;
    SeekBar perccentageSeekbar;
    String projectId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_reduceprogress);
        reasonText=findViewById(R.id.reasonText);
        taskName=findViewById(R.id.taskName);
        completedPercentage=findViewById(R.id.completedPercentage);
        perccentageSeekbar=findViewById(R.id.perccentageSeekbar);
        perccentageSeekbar.setMax(90);

        getSupportActionBar().setTitle("Reduce Progress");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        projectId=getIntent().getStringExtra("id");
        taskName.setText(getIntent().getStringExtra("name"));

        perccentageSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                completedPercentage.setText(String.format("%d%%", seekBar.getProgress()));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.done:
                if(isValid()){
                    reduceProgress();
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }


    private boolean isValid(){
        if(reasonText.getText().toString().isEmpty()){
            new AlertDialog.Builder(this).setMessage("Enter Valid Reason")
                    .setPositiveButton("CLOSE", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            // FIRE ZE MISSILES!

                        }
                    }).show();
            return false;
        }
        if(perccentageSeekbar.getProgress()==90){
            new AlertDialog.Builder(this).setMessage("Reduce the Progress")
                    .setPositiveButton("CLOSE", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            // FIRE ZE MISSILES!

                        }
                    }).show();
            return false;
        }

        return true;
    }

    private void reduceProgress(){
        Preference preference=Preference.getInstance(this);
        JSONObject jsonObject=new JSONObject();
        Map<String, String> params = new HashMap<String, String>();
        try {
            jsonObject.put("reason",reasonText.getText().toString());
            jsonObject.put("progress",perccentageSeekbar.getProgress()+"");
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());

            if(preference.isAdmin()){
                jsonObject.put("role",preference.getDesignation());
            }else if(Database.getInstance(this).isResponsibleForThisProject(projectId,preference.getEmailId())){
                jsonObject.put("role","project");
            }else{
                jsonObject.put("role","employee");
            }
            jsonObject.put("id",projectId);
            JSONObject employee=Database.getInstance(this).getWorkingPerson(projectId);
            jsonObject.put("assignId",employee.getString(AssignTable.ASSIGNID));
            jsonObject.put("employee",employee.getString(AssignTable.EMPLYOEEID));

        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.TASK_REDUCEPROGRESS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Progress Reduced Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Reduced Progress ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}
