package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import org.json.JSONException;
import org.json.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class RquestUpdateActivity extends AppCompatActivity {

    EditText requestResponse;
    String status;
    JSONObject jsonObject;
    LinearLayout linearLayout;
    TextView alertText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_rquest_update);
        requestResponse=findViewById(R.id.requestResponse);
        status=getIntent().getStringExtra("status");
        linearLayout=findViewById(R.id.linearLayout);
        alertText=findViewById(R.id.alertText);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle(getIntent().getStringExtra("title"));
        try {
            jsonObject=new JSONObject(getIntent().getStringExtra("json"));
            addViews();
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void addViews() throws JSONException {
        addView("Project Deadline",jsonObject.getString("p_end_date"));
        addView("Milestone Deadline",jsonObject.getString("m_enddate"));
        addView("Current Deadline",jsonObject.getString("t_end_date"));
        addView("Requested Deadline",jsonObject.getString("newd"));
        addView("Previous Requests",jsonObject.getString("counts"));
        if(status.equalsIgnoreCase("accepted")) {
            if (jsonObject.getBoolean("afterp") && jsonObject.getBoolean("afterm")) {
                alertText.setText("Project and Milestone deadline will be extended to " + jsonObject.getString("newd"));
            } else if (jsonObject.getBoolean("afterm")) {
                alertText.setText("Milestone deadline will be extended to " + jsonObject.getString("newd"));
            } else if (jsonObject.getBoolean("afterp")) {
                alertText.setText("Project deadline will be extended to " + jsonObject.getString("newd"));
            } else {
                alertText.setVisibility(View.GONE);
            }
        }else{
            alertText.setVisibility(View.GONE);
        }
    }

    private void updateRequest() throws ParseException, JSONException {

        if(requestResponse.getText().toString().isEmpty()){
            Toast.makeText(getApplicationContext(),"Please provide response",Toast.LENGTH_SHORT).show();
            return;
        }
        Preference preference=Preference.getInstance(this);
        Date date= DateUtils.fromDate(jsonObject.getString("t_end_date"));
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(Calendar.DATE, jsonObject.getInt("increasedays"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());

        Map<String, String> params = new HashMap<>();
        params.put("enddate",jsonObject.getString("newd"));
        params.put("status", status);
        params.put("tid", jsonObject.getString("task_id"));
        params.put("id", jsonObject.getString("id"));
        params.put("milestone", jsonObject.getString("t_milestone_id"));
        params.put("project", jsonObject.getString("project_id"));
        params.put("mail",preference.getEmailId());
        params.put("type",preference.getCompnayType());
        params.put("response",requestResponse.getText().toString());


        MyRequestQueue.getInstance(this).addToQueue(TASKURL.REQUEST_UPDATE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Request Updated Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to update Request",Toast.LENGTH_SHORT).show();
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case R.id.done:
                try {
                    updateRequest();
                } catch (ParseException e) {
                    e.printStackTrace();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            case android.R.id.home:
                onBackPressed();
                return true;

        }
        return super.onOptionsItemSelected(item);
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        linearLayout.addView(view);
    }

}
