package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.management.CategoryInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectCategoryAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class SelectCategoryActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    JSONArray jsonArray;
    boolean showInfo;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_selectcategory);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);

        showInfo=getIntent().getBooleanExtra("info",false);
        if(showInfo) {
            getSupportActionBar().setTitle("Categories");
        }else{
            getSupportActionBar().setTitle("Select Category");
        }
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    @Override
    protected void onResume() {
        super.onResume();
        getCategory();
    }

    private void getCategory(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("list",new JSONArray().toString());
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_CATEGORIES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getCategory(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getCategory(JSONObject jsonObject) throws JSONException{
        jsonArray=jsonObject.getJSONArray("categories");
        try {
            Database.getInstance(this).insertCategories(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        SelectCategoryAdapter selectCategoryAdapter=new SelectCategoryAdapter(this,jsonArray);
        recyclerView.setAdapter(selectCategoryAdapter);
    }

    @Override
    public void itemClicked(int position) {

        if(showInfo){
            Intent intent=new Intent(getApplicationContext(), CategoryInfoActivity.class);
            try {
                JSONObject jsonObject=jsonArray.getJSONObject(position);
                intent.putExtra("id", jsonObject.getString(CategoryTable.CATID));
            } catch (JSONException e) {
                e.printStackTrace();
            }
            startActivity(intent);
        }else {
            Intent intent = new Intent();
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(position);
                intent.putExtra("id", jsonObject.getString(CategoryTable.CATID));
                intent.putExtra("name", jsonObject.getString(CategoryTable.CATNAME));
            } catch (JSONException e) {
                e.printStackTrace();
            }
            setResult(Activity.RESULT_OK, intent);
            finish();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.add, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.add:
                startActivity(new Intent(getApplicationContext(),AddCategoryActivity.class));
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
