package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectEmployeeAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class SelectEmployeeActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_selectemployee);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setTitle("Responsible Person");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getEmployees();
    }

    private void getEmployees(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("list",new JSONArray().toString());
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_EMPLOYEES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getEmployees(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getEmployees(JSONObject jsonObject) throws JSONException{
        jsonArray=jsonObject.getJSONArray("employees");
        SelectEmployeeAdapter selectEmployeeAdapter=new SelectEmployeeAdapter(this,jsonArray);
        recyclerView.setAdapter(selectEmployeeAdapter);
    }

    @Override
    public void itemClicked(int position) {
        Intent intent=new Intent();
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            intent.putExtra("id",jsonObject.getString("emailid"));
            intent.putExtra("name",jsonObject.getString("employeename"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        setResult(Activity.RESULT_OK,intent);
        finish();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
