package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectMilestoneAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class SelectMilestoneActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    JSONArray jsonArray;
    String projectid;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_selectmilestone);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        recyclerView.setNestedScrollingEnabled(true);
        projectid=getIntent().getStringExtra("id");
        getSupportActionBar().setTitle("Select Milestone");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        findViewById(R.id.addNewMilestone).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getApplicationContext(), AddMilestoneActivity.class);
                intent.putExtra("id",projectid);
                startActivity(intent);
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
        getMilestones();
    }

    private void getMilestones(){
        Preference preference=Preference.getInstance(this);
        Database database= Database.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        String emailid=preference.getEmailId();
        params.put("mail",emailid);
        params.put("id",projectid);

        if(emailid.equalsIgnoreCase(database.getProjectResponsible(projectid))){
            params.put("responsible", "yes");
        }else{
            params.put("responsible", "no");
        }
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_MILESTONES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getMilestones(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMilestones(JSONObject jsonObject) throws JSONException {
        Database database=Database.getInstance(this);
        JSONArray jsonArray=jsonObject.getJSONArray("list");
        try {
            database.insertMilestones(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        getMilestonesOffline();
    }

    private void getMilestonesOffline(){
        jsonArray=Database.getInstance(this).getMilestones(projectid);
        SelectMilestoneAdapter selectMilestoneAdapter=new SelectMilestoneAdapter(this,jsonArray);
        recyclerView.setAdapter(selectMilestoneAdapter);
    }

    @Override
    public void itemClicked(int position) {
        Intent intent=new Intent();
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            intent.putExtra("id",jsonObject.getString(MilestoneTable.MILESTONEID));
            intent.putExtra("name",jsonObject.getString(MilestoneTable.NAME));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        setResult(Activity.RESULT_OK,intent);
        finish();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
