package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectTasklistAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class SelectTasklistActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    JSONArray jsonArray;
    String projectid;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_select_tasklist);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        projectid=getIntent().getStringExtra("id");
        getSupportActionBar().setTitle("Select Tasklist");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        findViewById(R.id.addNewTasklist).setVisibility(View.GONE);
    }

    @Override
    protected void onResume() {
        super.onResume();
        getTasklists();
    }

    private void getTasklists(){
        Preference preference=Preference.getInstance(this);
        Database database= Database.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        String emailid=preference.getEmailId();
        params.put("mail",emailid);
        params.put("id",projectid);

        if(emailid.equalsIgnoreCase(database.getProjectResponsible(projectid))){
            params.put("responsible", "yes");
        }else{
            params.put("responsible", "no");
        }
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_TASKLISTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getTasklists(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasklists(JSONObject jsonObject) throws JSONException {
        Database database=Database.getInstance(this);
        JSONArray jsonArray=jsonObject.getJSONArray("list");
        try {
            database.insertTaskLists(jsonArray);
        } catch (Exception e) {
            e.printStackTrace();
        }
        getTasklistsOffline();
    }

    private void getTasklistsOffline(){
        jsonArray=Database.getInstance(this).getTaskLists(projectid);
        SelectTasklistAdapter selectTasklistAdapter=new SelectTasklistAdapter(this,jsonArray);
        recyclerView.setAdapter(selectTasklistAdapter);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_tasklist, menu);
        return true;
    }

    @Override
    public void itemClicked(int position) {
        Intent intent=new Intent();
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            intent.putExtra("id",jsonObject.getString(TasklistTable.TASKLISTID));
            intent.putExtra("name",jsonObject.getString(TasklistTable.NAME));
            intent.putExtra("milestone",jsonObject.getString(TasklistTable.MILESTONEID));

        } catch (JSONException e) {
            e.printStackTrace();
        }
        setResult(Activity.RESULT_OK,intent);
        finish();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
            case R.id.newTasklist:
                Intent intent = new Intent(getApplicationContext(), AddTaskListActivity.class);
                intent.putExtra("id",projectid);
                startActivity(intent);
                break;
        }
        return super.onOptionsItemSelected(item);
    }

}
