package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.content.DialogInterface;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectEmployeeAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TaskAssignActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    JSONArray jsonArray;
    String taskId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_selectemployee);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        taskId=getIntent().getStringExtra("id");
        getSupportActionBar().setTitle("Assign Task");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getEmployees();
    }

    private void getEmployees(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("list",new JSONArray().toString());
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_EMPLOYEES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getEmployees(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getEmployees(JSONObject jsonObject) throws JSONException{
        jsonArray=jsonObject.getJSONArray("employees");
        SelectEmployeeAdapter selectEmployeeAdapter=new SelectEmployeeAdapter(this,jsonArray);
        recyclerView.setAdapter(selectEmployeeAdapter);
    }

    @Override
    public void itemClicked(final int position) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setPositiveButton("CONFIRM", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                try {
                    assignTask(jsonArray.getJSONObject(position).getString("emailid"));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                }
            });

        builder.setNegativeButton("CLOSE", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {

            }
        });

        try {
            builder.setMessage("Assign Task to "+jsonArray.getJSONObject(position).getString("employeename"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        AlertDialog dialog = builder.create();
        dialog.show();

    }



    private void assignTask(String employeeid){

        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject=new JSONObject();
        try {
            jsonObject.put("taskId",taskId);
            jsonObject.put("assignedTo",employeeid);
            jsonObject.put("cname",preference.getCompanyName());
            jsonObject.put("mail",preference.getEmailId());
            jsonObject.put("type",preference.getCompnayType());
            jsonObject.put("role",preference.getDesignation());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data",jsonObject.toString());

        MyRequestQueue.getInstance(this).addToQueue(TASKURL.ASSIGN_TASK, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getBoolean("s")){
                        Toast.makeText(getApplicationContext(),"Task Assigned Successfully",Toast.LENGTH_SHORT).show();
                        finish();
                    }else{
                        Toast.makeText(getApplicationContext(),"Unable to Assign Task ",Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
