package com.b2lmobitech.fieldcloudplus.task.activities.management;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddCategoryActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class CategoryInfoActivity extends AppCompatActivity {

    LinearLayout catDetails;
    String id;
    MenuItem edit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_categoryinfo);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Category Details");
        catDetails=findViewById(R.id.catDetails);
        id=getIntent().getStringExtra("id");
    }

    @Override
    protected void onResume() {
        super.onResume();
        getCategory();
    }

    private void getCategory(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("list",new JSONArray().toString());
        params.put("tagid",id);
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_CATEGORIES, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getCategory(new JSONObject(response));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getCategory(JSONObject jsonObject) throws Exception {
        JSONArray jsonArray=jsonObject.getJSONArray("categories");
        Database.getInstance(this).insertCategories(jsonArray);
        addCategoryDetails();
    }

    private void addCategoryDetails() throws JSONException {
        Database database= Database.getInstance(this);

        JSONObject jsonObject= database.getCategoryDetails(id);
        catDetails.removeAllViews();
        addView("Name",jsonObject.getString(CategoryTable.CATNAME));
        addView("Description",jsonObject.getString(CategoryTable.CATDESCRIPTION));
        addView("Created On",jsonObject.getString(CategoryTable.CREATEDDATETIME));
        if(!database.getEmployeeName(jsonObject.getString(CategoryTable.CREATEDBY)).isEmpty()){
            addView("Created By",database.getEmployeeName(jsonObject.getString(CategoryTable.CREATEDBY)));
        }
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        catDetails.addView(view);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.edit, menu);
        edit=menu.findItem(R.id.edit);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
            case R.id.edit:
                try {
                    Intent intent = new Intent(this, AddCategoryActivity.class);
                    intent.putExtra("id", id);
                    startActivity(intent);
                }catch (Exception e){
                    e.printStackTrace();
                }
                break;
        }
        return super.onOptionsItemSelected(item);
    }
}
