package com.b2lmobitech.fieldcloudplus.task.activities.management;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddClientActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ClientInfoActivity extends AppCompatActivity {

    LinearLayout clientDetails;
    String id;
    MenuItem edit;
    private String NDA="no data available";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_clientinfo);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Client Details");
        clientDetails=findViewById(R.id.clientDetails);
        id=getIntent().getStringExtra("id");
    }

    @Override
    protected void onResume() {
        super.onResume();
        getClients();
    }

    private void getClients(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("cname",preference.getCompanyName());
        params.put("list",new JSONArray().toString());
        params.put("id",id);
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_CLIENTS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getClients(new JSONObject(response));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getClients(JSONObject jsonObject) throws Exception {
        JSONArray jsonArray=jsonObject.getJSONArray("clients");
        Database.getInstance(this).insertClients(jsonArray);
        addClientDetails();
    }

    private void addClientDetails() throws JSONException {
        Database database= Database.getInstance(this);

        JSONObject jsonObject= database.getClientDetails(id);
        clientDetails.removeAllViews();
        addView("Compnay Name",jsonObject.getString(ClientTable.COMPANYNAME));
        addView("Compnay Address",jsonObject.getString(ClientTable.ADDRESS));
        addView("Compnay Mobile",jsonObject.getString(ClientTable.CMOBILE));
        addView("Compnay Phone",jsonObject.getString(ClientTable.CPHONE));
        addView("Compnay Email",jsonObject.getString(ClientTable.CEMAIL));
        addView("Web Address",jsonObject.getString(ClientTable.WEBADDRESS));

        if(!jsonObject.getString(ClientTable.RESPONSIBLEPERSON).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEPERSON).equalsIgnoreCase(NDA)) {
            addView("Responsible Person", jsonObject.getString(ClientTable.RESPONSIBLEPERSON));
        }
        if(!jsonObject.getString(ClientTable.RESPONSIBLEMAIL).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEMAIL).equalsIgnoreCase(NDA)) {
            addView("Responsible Person Email", jsonObject.getString(ClientTable.RESPONSIBLEMAIL));
        }
        if(!jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE).equalsIgnoreCase(NDA)) {
            addView("Responsible Person Mobile", jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE));
        }
        addView("Created On",jsonObject.getString(ClientTable.CREATEDDATETIME));
        if(!database.getEmployeeName(jsonObject.getString(ClientTable.CREATEDBY)).isEmpty()){
            addView("Created By",database.getEmployeeName(jsonObject.getString(ClientTable.CREATEDBY)));
        }
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        clientDetails.addView(view);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.edit, menu);
        edit=menu.findItem(R.id.edit);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
            case R.id.edit:
                try {
                    Intent intent = new Intent(this, AddClientActivity.class);
                    intent.putExtra("id", id);
                    startActivity(intent);
                }catch (Exception e){
                    e.printStackTrace();
                }
                break;
        }
        return super.onOptionsItemSelected(item);
    }
}
