package com.b2lmobitech.fieldcloudplus.task.activities.management;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTagActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TagTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TagInfoActivity extends AppCompatActivity {

    LinearLayout tagDetails;
    String id;
    MenuItem edit;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_taginfo);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Tag Details");
        tagDetails=findViewById(R.id.tagDetails);
        id=getIntent().getStringExtra("id");
    }

    @Override
    protected void onResume() {
        super.onResume();
        getTags();
    }

    private void getTags(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<String, String>();
        params.put("cname",preference.getCompanyName());
        params.put("list",new JSONArray().toString());
        params.put("tagid",id);
        MyRequestQueue.getInstance(this).addToQueue(TASKURL.GET_TAGS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getTags(new JSONObject(response));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTags(JSONObject jsonObject) throws Exception {
        JSONArray jsonArray=jsonObject.getJSONArray("tags");
        Database.getInstance(this).insertTags(jsonArray);
        addTagDetails();
    }

    private void addTagDetails() throws JSONException {
        Database database= Database.getInstance(this);

        JSONObject jsonObject= database.getTagDetails(id);
        tagDetails.removeAllViews();
        addView("Name",jsonObject.getString(TagTable.TAGNAME));
        addView("Weightage",jsonObject.getString(TagTable.WEIGHTAGE));
        addView("Created On",jsonObject.getString(TagTable.CREATEDDATETIME));
        if(!database.getEmployeeName(jsonObject.getString(TagTable.CREATEDBY)).isEmpty()){
            addView("Created By",database.getEmployeeName(jsonObject.getString(TagTable.CREATEDBY)));
        }
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.mode_keypair,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        tagDetails.addView(view);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.edit, menu);
        edit=menu.findItem(R.id.edit);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
            case R.id.edit:
                try {
                    Intent intent = new Intent(this, AddTagActivity.class);
                    intent.putExtra("id", id);
                    startActivity(intent);
                }catch (Exception e){
                    e.printStackTrace();
                }
                break;
        }
        return super.onOptionsItemSelected(item);
    }

}
