package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 10/31/2017.
 */

public class ActivitiesAdapter extends  RecyclerView.Adapter<ActivitiesAdapter.viewHolder>{

    Context context;
    JSONArray jsonArray;
    private Database database;
    OnItemClickListener onItemClickListener;
    private final String NDA="no data available";
    private final String bullot="\u2022";

    public ActivitiesAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        database=Database.getInstance(context);
        onItemClickListener= (OnItemClickListener) context;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            final JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());

            holder.text1.setText(jsonObject.getString("act_description"));

            holder.text2.setText(database.getEmployeeName(jsonObject.getString("created_by")));
            if(jsonObject.getString("created_by").equalsIgnoreCase(NDA)){
                holder.text3.setText(String.format("%s",jsonObject.getString("act_datetime")));
            }else{
                holder.text3.setText(String.format("%s %s %s", database.getEmployeeName(jsonObject.getString("created_by")), bullot, jsonObject.getString("act_datetime")));
            }

            if(holder.getAdapterPosition() ==0 || !jsonObject.getString("act_date").equalsIgnoreCase(jsonArray.getJSONObject(holder.getAdapterPosition()-1).getString("act_date"))){
                holder.date.setText(jsonObject.getString("act_date"));
            }else{
                holder.date.setVisibility(View.GONE);
            }
            String status=jsonObject.getString("act_p_status");
            if(status.equalsIgnoreCase("assigned")){
                holder.iconImage.setImageResource(R.drawable.ic_user_assign);
            }else if(status.equalsIgnoreCase("unassigned")){
                holder.iconImage.setImageResource(R.drawable.ic_user_unassign);
            }else if(status.equalsIgnoreCase("add")){
                holder.iconImage.setImageResource(R.drawable.ic_plus);
            }else if(status.equalsIgnoreCase("edit")){
                holder.iconImage.setImageResource(R.drawable.ic_task_disapprove);
            }else if(status.equalsIgnoreCase("progress")){
                holder.iconImage.setImageResource(R.drawable.ic_hourglass);
            }else if(status.equalsIgnoreCase("completed")){
                holder.iconImage.setImageResource(R.drawable.ic_task_approve);
            }else if(status.equalsIgnoreCase("stopped")){
                holder.iconImage.setImageResource(R.drawable.ic_task_stop);
            }else if(status.equalsIgnoreCase("stalled")){
                holder.iconImage.setImageResource(R.drawable.ic_check_list);
            }else if(status.equalsIgnoreCase("begin")){
                holder.iconImage.setImageResource(R.drawable.ic_check_list);
            }else if(status.equalsIgnoreCase("underprogress")){
                holder.iconImage.setImageResource(R.drawable.ic_check_list);
            }else if(status.equalsIgnoreCase("date")){
                holder.iconImage.setImageResource(R.drawable.ic_calendar);
            }else if(status.equalsIgnoreCase("delete")){
                holder.iconImage.setImageResource(R.drawable.ic_delete);
            }

            if(!jsonObject.getString("task_id").equalsIgnoreCase(NDA)){
                holder.text2.setText(Html.fromHtml("Task: <b>"+jsonObject.getString("task_name")+"</b>"));
            }else if(!jsonObject.getString("tasklist_id").equalsIgnoreCase(NDA)){
                holder.text2.setText(Html.fromHtml("Tasklist: <b>"+jsonObject.getString("listtask_name")+"</b>"));
            }else if(!jsonObject.getString("milestone_id").equalsIgnoreCase(NDA)){
                holder.text2.setText(Html.fromHtml("Milestone: <b>"+jsonObject.getString("milestone_name")+"</b>"));
            }else if(!jsonObject.getString("project_id").equalsIgnoreCase(NDA)){
                holder.text2.setText(Html.fromHtml("Project: <b>"+jsonObject.getString("project_name")+"</b>"));
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_activities, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView text1,text2,text3,date;
        CardView cardView;
        ImageView iconImage;
        public viewHolder(View itemView) {
            super(itemView);
            text1=itemView.findViewById(R.id.text1);
            text2=itemView.findViewById(R.id.text2);
            cardView=itemView.findViewById(R.id.cardView);
            text3=itemView.findViewById(R.id.text3);
            date=itemView.findViewById(R.id.date);
            iconImage=itemView.findViewById(R.id.iconImage);
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onItemClickListener.itemClicked(getAdapterPosition());
                }
            });
            setIsRecyclable(false);
        }
    }

}
